/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.navigator;

import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.carpetorgaddition.network.s2c.WaypointUpdateS2CPacket;
import org.carpetorgaddition.periodic.navigator.AbstractNavigator;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.util.MathUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.util.WorldUtils;
import org.carpetorgaddition.wheel.TextBuilder;
import org.carpetorgaddition.wheel.Waypoint;
import org.carpetorgaddition.wheel.provider.TextProvider;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WaypointNavigator
extends AbstractNavigator {
    private final Waypoint waypoint;
    private final class_1937 world;
    @NotNull
    private class_1937 playerWorld;
    @NotNull
    private class_1937 prevPlayerWorld;
    private final class_2338 target;
    @Nullable
    private final class_2338 secondTarget;

    public WaypointNavigator(@NotNull class_3222 player, Waypoint waypoint) {
        super(player);
        this.waypoint = waypoint;
        class_2338 blockPos = this.waypoint.getBlockPos();
        if (blockPos == null) {
            throw new NullPointerException();
        }
        this.target = blockPos;
        this.secondTarget = this.waypoint.getAnotherBlockPos();
        this.world = waypoint.getWorld();
        this.playerWorld = FetcherUtils.getWorld(player);
        this.prevPlayerWorld = this.world;
    }

    @Override
    public void tick() {
        this.playerWorld = FetcherUtils.getWorld(this.player);
        class_2338 playerPos = this.player.method_24515();
        if (this.world.equals(this.playerWorld)) {
            class_2561 display = TextBuilder.translate("carpet.commands.navigate.hud.in", this.waypoint.getName(), TextProvider.simpleBlockPos(this.target));
            int distance = MathUtils.getBlockIntegerDistance(playerPos, this.target);
            class_2561 text = this.getHUDText(this.target.method_46558(), display, distance);
            MessageUtils.sendMessageToHud((class_1657)this.player, text);
        } else if (this.canMapping(this.secondTarget)) {
            TextBuilder builder = new TextBuilder(TextProvider.simpleBlockPos(this.secondTarget));
            builder.setItalic();
            class_2561 in = TextBuilder.translate("carpet.commands.navigate.hud.in", this.waypoint.getName(), builder.build());
            int distance = MathUtils.getBlockIntegerDistance(playerPos, this.secondTarget);
            class_2561 text = this.getHUDText(this.secondTarget.method_46558(), in, distance);
            MessageUtils.sendMessageToHud((class_1657)this.player, text);
        } else {
            class_2561 dimensionName = TextProvider.dimension((class_1937)WorldUtils.getWorld(FetcherUtils.getServer(this.player), this.waypoint.getWorldAsString()));
            class_2561 in = TextBuilder.translate("carpet.commands.navigate.hud.in", this.waypoint.getName(), TextBuilder.combineAll(dimensionName, TextProvider.simpleBlockPos(this.target)));
            MessageUtils.sendMessageToHud((class_1657)this.player, in);
        }
        this.syncWaypoint(false);
        this.prevPlayerWorld = this.playerWorld;
    }

    @Contract(value="null -> false")
    private boolean canMapping(class_2338 second) {
        if (second == null) {
            return false;
        }
        return WorldUtils.canMappingPos(this.world, this.playerWorld);
    }

    @Override
    protected WaypointUpdateS2CPacket createPacket() {
        if (this.canMapping(this.secondTarget)) {
            return new WaypointUpdateS2CPacket(this.secondTarget, this.playerWorld);
        }
        return new WaypointUpdateS2CPacket(this.target, this.world);
    }

    @Override
    protected boolean updateRequired() {
        return !this.prevPlayerWorld.equals(this.playerWorld);
    }

    @Override
    public boolean isArrive() {
        if (this.playerWorld.equals(this.world) && MathUtils.getBlockIntegerDistance(this.player.method_24515(), this.waypoint.getBlockPos()) <= 8) {
            MessageUtils.sendMessageToHud((class_1657)this.player, TextBuilder.translate("carpet.commands.navigate.hud.reach", new Object[0]));
            this.clear();
            return true;
        }
        return false;
    }

    @Override
    public WaypointNavigator copy(class_3222 player) {
        if (this.waypoint.getBlockPos() == null) {
            return null;
        }
        return new WaypointNavigator(player, this.waypoint);
    }
}

