/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.wheel.screen;

import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.periodic.ServerComponentCoordinator;
import org.carpetorgaddition.periodic.express.Express;
import org.carpetorgaddition.periodic.express.ExpressManager;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.util.GenericUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.wheel.TextBuilder;
import org.carpetorgaddition.wheel.inventory.AutoGrowInventory;
import org.carpetorgaddition.wheel.inventory.ImmutableInventory;
import org.carpetorgaddition.wheel.provider.CommandProvider;
import org.carpetorgaddition.wheel.provider.TextProvider;

public class ShipExpressScreenHandler
extends class_1707 {
    private final class_1263 inventory;
    private final ExpressManager expressManager;
    private final MinecraftServer server;
    private final class_3222 sourcePlayer;
    private final GameProfile recipient;

    public ShipExpressScreenHandler(int syncId, class_1661 playerInventory, class_3222 sourcePlayer, GameProfile recipient, class_1263 inventory) {
        super(class_3917.field_17326, syncId, playerInventory, inventory, 3);
        this.inventory = inventory;
        this.server = FetcherUtils.getServer(sourcePlayer);
        this.expressManager = ServerComponentCoordinator.getCoordinator(this.server).getExpressManager();
        this.sourcePlayer = sourcePlayer;
        this.recipient = recipient;
    }

    public void method_7595(class_1657 player) {
        class_1799 stack;
        int i;
        super.method_7595(player);
        if (this.inventory.method_5442()) {
            return;
        }
        AutoGrowInventory autoGrowInventory = new AutoGrowInventory();
        for (i = 0; i < this.inventory.method_5439(); ++i) {
            class_1799 itemStack = this.inventory.method_5438(i);
            if (itemStack.method_7960()) continue;
            autoGrowInventory.addStack(itemStack);
        }
        for (i = 0; i < autoGrowInventory.method_5439() && !(stack = autoGrowInventory.method_5438(i)).method_7960(); ++i) {
            Express express = new Express(this.server, this.sourcePlayer, this.recipient, stack, this.expressManager.generateNumber());
            try {
                this.expressManager.putNoMessage(express);
                continue;
            }
            catch (IOException e) {
                CarpetOrgAddition.LOGGER.error("\u6279\u91cf\u53d1\u9001\u7269\u54c1\u65f6\u9047\u5230\u610f\u5916\u9519\u8bef", (Throwable)e);
                MessageUtils.sendErrorMessage(this.sourcePlayer.method_64396(), e, "carpet.commands.mail.multiple.error", new Object[0]);
                return;
            }
        }
        this.sendFeedback(autoGrowInventory);
    }

    public void sendFeedback(AutoGrowInventory inventory) {
        Object[] objectArray;
        class_1799 firstStack = inventory.method_5438(0);
        int onlyOneKind = 0;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960() || onlyOneKind != 0 && class_1799.method_7973((class_1799)firstStack, (class_1799)stack)) continue;
            onlyOneKind = 1;
            if (firstStack.method_31574(stack.method_7909())) continue;
            onlyOneKind = 2;
            break;
        }
        Optional<class_3222> optional = GenericUtils.getPlayer(this.server, this.recipient);
        class_2561 playerName = optional.map(class_1657::method_5476).orElse(TextBuilder.create(this.recipient.name()));
        class_2561 command = TextProvider.clickRun(CommandProvider.cancelAllExpress());
        int count = inventory.count();
        switch (onlyOneKind) {
            case 0: {
                class_2561 itemCount = TextProvider.itemCount(count, firstStack.method_7914());
                Object[] objectArray2 = new Object[4];
                objectArray2[0] = playerName;
                objectArray2[1] = itemCount;
                objectArray2[2] = firstStack.method_7954();
                objectArray = objectArray2;
                objectArray2[3] = command;
                break;
            }
            case 1: {
                class_2561 hoverableText = firstStack.method_7909().method_7854().method_7954();
                class_2561 itemCount = TextProvider.itemCount(count, firstStack.method_7914());
                Object[] objectArray3 = new Object[4];
                objectArray3[0] = playerName;
                objectArray3[1] = itemCount;
                objectArray3[2] = hoverableText;
                objectArray = objectArray3;
                objectArray3[3] = command;
                break;
            }
            case 2: {
                class_2561 itemText = TextBuilder.translate("carpet.command.item.item", new Object[0]);
                Object[] objectArray4 = new Object[4];
                objectArray4[0] = playerName;
                objectArray4[1] = count;
                objectArray4[2] = TextProvider.inventory(itemText, inventory);
                objectArray = objectArray4;
                objectArray4[3] = command;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        Object[] args = objectArray;
        MessageUtils.sendMessage(this.sourcePlayer, "carpet.commands.mail.sending.multiple", args);
        if (optional.isEmpty()) {
            TextBuilder builder = TextBuilder.of("carpet.commands.mail.sending.offline_player", new Object[0]);
            builder.setGrayItalic();
            MessageUtils.sendMessage(this.sourcePlayer, builder.build());
        } else {
            class_3222 player = optional.get();
            MessageUtils.sendMessage(player, "carpet.commands.mail.receive.multiple", this.sourcePlayer.method_5476(), args[1], args[2], TextProvider.clickRun(CommandProvider.receiveAllExpress()));
            Express.playXpOrbPickupSound(player);
            Express.checkRecipientPermission(this.sourcePlayer, player);
        }
        if (onlyOneKind == 2) {
            CarpetOrgAddition.LOGGER.info("{}\u5411{}\u53d1\u9001\u4e86{}", new Object[]{FetcherUtils.getPlayerName((class_1657)this.sourcePlayer), this.recipient, new ImmutableInventory(inventory)});
        } else {
            CarpetOrgAddition.LOGGER.info("{}\u5411{}\u53d1\u9001\u4e86{}\u4e2a{}", new Object[]{FetcherUtils.getPlayerName((class_1657)this.sourcePlayer), this.recipient, ((class_2561)args[1]).getString(), firstStack.method_7964().getString()});
        }
    }
}

