/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.rule;

import net.minecraft.class_3222;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.rule.CustomRuleControl;
import org.carpetorgaddition.rule.RuleSelfManager;
import org.carpetorgaddition.rule.value.BlockDropsDirectlyEnterInventory;
import org.carpetorgaddition.util.FetcherUtils;

public class CustomRuleControls {
    public static final CustomRuleControl<Boolean> BLOCK_DROPS_DIRECTLY_ENTER_INVENTORY = new CustomRuleControl<Boolean>(){

        @Override
        public Boolean getRuleValue(class_3222 player) {
            if (player == null) {
                return false;
            }
            return switch (CarpetOrgAdditionSettings.blockDropsDirectlyEnterInventory.get()) {
                default -> throw new MatchException(null, null);
                case BlockDropsDirectlyEnterInventory.TRUE -> true;
                case BlockDropsDirectlyEnterInventory.FALSE -> false;
                case BlockDropsDirectlyEnterInventory.CUSTOM -> {
                    RuleSelfManager ruleSelfManager = FetcherUtils.getRuleSelfManager(player);
                    yield ruleSelfManager.isEnabled(player, this);
                }
            };
        }

        @Override
        public boolean isServerDecision() {
            return CarpetOrgAdditionSettings.blockDropsDirectlyEnterInventory.get() != BlockDropsDirectlyEnterInventory.CUSTOM;
        }
    };
    public static final CustomRuleControl<Integer> ITEM_PICKUP_RANGE_EXPAND = new CustomRuleControl<Integer>(){

        @Override
        public Integer getRuleValue(class_3222 player) {
            int range = CarpetOrgAdditionSettings.itemPickupRangeExpand.get();
            if (range == 0) {
                return 0;
            }
            if (CarpetOrgAdditionSettings.itemPickupRangeExpandPlayerControl.get().booleanValue()) {
                RuleSelfManager ruleSelfManager = FetcherUtils.getRuleSelfManager(player);
                return ruleSelfManager.isEnabled(player, this) ? range : 0;
            }
            return range;
        }

        @Override
        public boolean isServerDecision() {
            return CarpetOrgAdditionSettings.itemPickupRangeExpandPlayerControl.get() == false;
        }
    };
}

