/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.wheel.inventory;

import carpet.patches.EntityPlayerMPFake;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntImmutableList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.exception.InfiniteLoopException;
import org.carpetorgaddition.periodic.fakeplayer.FakePlayerUtils;
import org.carpetorgaddition.util.InventoryUtils;
import org.carpetorgaddition.wheel.inventory.AbstractCustomSizeInventory;
import org.carpetorgaddition.wheel.screen.QuickShulkerScreenHandler;
import org.jetbrains.annotations.CheckReturnValue;
import org.jetbrains.annotations.NotNull;

public class PlayerStorageInventory
implements class_1263 {
    private final class_1661 playerInventory;
    private final EntityPlayerMPFake fakePlayer;
    private final IntList indexMapping;

    public PlayerStorageInventory(EntityPlayerMPFake fakePlayer) {
        this.playerInventory = fakePlayer.method_31548();
        this.fakePlayer = fakePlayer;
        IntArrayList list = new IntArrayList(37);
        class_2371 main = this.playerInventory.field_7547;
        for (int i = 0; i < main.size(); ++i) {
            list.add(i);
        }
        list.add(40);
        this.indexMapping = new IntImmutableList((IntList)list);
    }

    public int method_5439() {
        return this.indexMapping.size();
    }

    public boolean method_5442() {
        for (int i = 0; i < this.method_5439(); ++i) {
            class_1799 itemStack = this.method_5438(i);
            if (itemStack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int slot) {
        return this.playerInventory.method_5438(this.map(slot));
    }

    public class_1799 getStack(class_1268 hand) {
        return switch (hand) {
            default -> throw new MatchException(null, null);
            case class_1268.field_5808 -> this.fakePlayer.method_6047();
            case class_1268.field_5810 -> this.fakePlayer.method_6079();
        };
    }

    public class_1799 method_5434(int slot, int amount) {
        return this.playerInventory.method_5434(this.map(slot), amount);
    }

    public class_1799 method_5441(int slot) {
        return this.playerInventory.method_5441(this.map(slot));
    }

    public void method_5447(int slot, class_1799 stack) {
        this.playerInventory.method_5447(this.map(slot), stack);
    }

    public void setStack(class_1268 hand, class_1799 stack) {
        this.fakePlayer.method_6122(hand, stack);
    }

    public void method_5431() {
        this.playerInventory.method_5431();
    }

    public boolean method_5443(class_1657 player) {
        return this.playerInventory.method_5443(player);
    }

    public void method_5448() {
        for (int i = 0; i < this.method_5439(); ++i) {
            this.method_5447(i, class_1799.field_8037);
        }
    }

    public void drop(int index) {
        class_1799 itemStack = this.method_5438(index);
        this.method_5447(index, class_1799.field_8037);
        this.fakePlayer.method_7329(itemStack, false, true);
    }

    public boolean drop(Predicate<class_1799> predicate) {
        boolean dropped = false;
        for (int i = 0; i < this.method_5439(); ++i) {
            class_1799 itemStack = this.method_5438(i);
            if (itemStack.method_7960() || !predicate.test(itemStack)) continue;
            this.drop(i);
            dropped = true;
        }
        return dropped;
    }

    public boolean insertWithShulkerBoxPriority(class_1799 itemStack) {
        class_1799 remaining = this.insertToShulkerBox(itemStack);
        if (remaining.method_7960()) {
            return false;
        }
        this.insert(remaining);
        if (remaining.method_7960()) {
            return false;
        }
        FakePlayerUtils.dropItem(this.fakePlayer, remaining);
        return true;
    }

    public void insertWithInventoryPriority(class_1799 itemStack) {
        this.insert(itemStack);
        if (itemStack.method_7960()) {
            return;
        }
        class_1799 remaining = this.insertToShulkerBox(itemStack);
        if (remaining.method_7960()) {
            return;
        }
        FakePlayerUtils.dropItem(this.fakePlayer, remaining);
    }

    @NotNull
    @CheckReturnValue
    private class_1799 insertToShulkerBox(class_1799 itemStack) {
        if (CarpetOrgAdditionSettings.fakePlayerPickItemFromShulkerBox.get().booleanValue()) {
            int last;
            itemStack = itemStack.method_51164();
            ArrayList<Integer> shulkers = new ArrayList<Integer>();
            for (int i = 0; i < this.method_5439(); ++i) {
                class_1799 shulker = this.method_5438(i);
                if (!InventoryUtils.isShulkerBoxItem(shulker)) continue;
                shulkers.add(i);
                if (!InventoryUtils.canAcceptAsSingleItemType(shulker, itemStack, false) && !InventoryUtils.isJunkBox(shulker) || !(itemStack = InventoryUtils.addItemToShulkerBox(shulker, itemStack)).method_7960()) continue;
                return class_1799.field_8037;
            }
            for (Integer index : shulkers) {
                class_1799 shulker = this.method_5438(index);
                if (!InventoryUtils.canAcceptAsSingleItemType(shulker, itemStack, true) || !(itemStack = InventoryUtils.addItemToShulkerBox(shulker, itemStack)).method_7960()) continue;
                return class_1799.field_8037;
            }
            if (!shulkers.isEmpty() && (last = ((Integer)shulkers.getLast()).intValue()) < this.method_5439() - 1 && this.method_5438(last).method_7947() > 1) {
                this.splitStackedShulkerBox(last, last + 1);
                itemStack = InventoryUtils.addItemToShulkerBox(this.method_5438(last + 1), itemStack);
            }
        }
        return itemStack;
    }

    public void insert(class_1799 itemStack) {
        this.playerInventory.method_7394(itemStack);
        if (itemStack.method_7960()) {
            return;
        }
        class_1799 offHandStack = this.getStack(class_1268.field_5810);
        if (offHandStack.method_7960()) {
            this.setStack(class_1268.field_5810, itemStack.method_51164());
        } else if (InventoryUtils.canMergeTo(itemStack, offHandStack)) {
            InventoryUtils.mergeStack(itemStack, offHandStack);
        }
    }

    private void splitStackedShulkerBox(int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        class_1799 from = this.method_5438(fromIndex);
        class_1799 to = this.method_5438(toIndex);
        if (to.method_7960()) {
            class_1799 split = from.method_7971(1);
            this.method_5447(toIndex, split);
        }
    }

    public void sort() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int index = 0; index < this.method_5439(); ++index) {
            if (!this.isValidSlot(index)) continue;
            list.add(index);
            class_1799 itemStack = this.method_5438(index);
            if (InventoryUtils.isItemStackFull(itemStack)) continue;
            this.merge(index, itemStack);
        }
        this.sort(list);
    }

    private void sort(List<Integer> list) {
        if (list.isEmpty()) {
            return;
        }
        int start = 0;
        int end = list.size() - 1;
        class_1799 pivot = this.method_5438(list.getFirst());
        while (start < end) {
            boolean infiniteLoop = true;
            while (end > start && InventoryUtils.compare(pivot, this.method_5438(list.get(end))) <= 0) {
                --end;
                infiniteLoop = false;
            }
            while (end > start && InventoryUtils.compare(pivot, this.method_5438(list.get(start))) >= 0) {
                ++start;
                infiniteLoop = false;
            }
            if (infiniteLoop) {
                throw new InfiniteLoopException("Trapped in an infinite loop while sorting items");
            }
            this.swap(list.get(start), list.get(end));
        }
        this.swap(list.getFirst(), list.get(start));
        this.sort(list.subList(0, start));
        this.sort(list.subList(start + 1, list.size()));
    }

    private void merge(int index, class_1799 itemStack) {
        for (int i = index + 1; i < this.method_5439(); ++i) {
            class_1799 slotStack;
            if (!this.isValidSlot(i) || (slotStack = this.method_5438(i)).method_7960() || !InventoryUtils.canMergeTo(itemStack, slotStack)) continue;
            InventoryUtils.mergeStack(itemStack, slotStack);
            if (!itemStack.method_7960()) continue;
            return;
        }
    }

    private boolean isValidSlot(int index) {
        class_1799 itemStack = this.method_5438(index);
        if (itemStack.method_7947() > itemStack.method_7914()) {
            return false;
        }
        if (itemStack == AbstractCustomSizeInventory.PLACEHOLDER) {
            return false;
        }
        if (InventoryUtils.isGcaItem(itemStack)) {
            return false;
        }
        class_1703 class_17032 = this.fakePlayer.field_7512;
        if (class_17032 instanceof QuickShulkerScreenHandler) {
            QuickShulkerScreenHandler quickShulkerScreenHandler = (QuickShulkerScreenHandler)class_17032;
            return itemStack != quickShulkerScreenHandler.getShulkerBox();
        }
        return true;
    }

    public boolean replenishment(Predicate<class_1799> predicate) {
        return this.replenishment(class_1268.field_5808, predicate);
    }

    public boolean replenishment(class_1268 hand, Predicate<class_1799> predicate) {
        class_1799 stackInHand = this.getStack(hand);
        if (predicate.test(stackInHand)) {
            return true;
        }
        boolean pickItemFromShulker = CarpetOrgAdditionSettings.fakePlayerPickItemFromShulkerBox.get();
        ArrayList<Integer> shulkers = new ArrayList<Integer>();
        int headSlot = this.getHandSlotIndex(hand);
        for (int i = 0; i < this.method_5439(); ++i) {
            class_1799 shulker;
            if (i == headSlot) continue;
            if (predicate.test(this.method_5438(i))) {
                this.swap(i, headSlot);
                return true;
            }
            if (!pickItemFromShulker || (shulker = this.method_5438(i)).method_7960() || !InventoryUtils.isShulkerBoxItem(shulker)) continue;
            shulkers.add(i);
        }
        if (pickItemFromShulker) {
            for (Integer index : shulkers) {
                class_1799 shulker = this.method_5438(index);
                class_1799 picked = InventoryUtils.pickItemFromShulkerBox(shulker, predicate);
                if (picked.method_7960()) continue;
                this.fakePlayer.method_6122(hand, picked);
                this.insertWithInventoryPriority(stackInHand);
                return true;
            }
        }
        return false;
    }

    private int getHandSlotIndex(class_1268 hand) {
        return switch (hand) {
            default -> throw new MatchException(null, null);
            case class_1268.field_5808 -> this.playerInventory.field_7545;
            case class_1268.field_5810 -> 36;
        };
    }

    public boolean contains(Predicate<class_1799> predicate) {
        boolean pickItemFromShulker = CarpetOrgAdditionSettings.fakePlayerPickItemFromShulkerBox.get();
        for (int i = 0; i < this.method_5439(); ++i) {
            class_1799 itemStack = this.method_5438(i);
            if (itemStack.method_7960()) continue;
            if (predicate.test(itemStack)) {
                return true;
            }
            if (!pickItemFromShulker || !InventoryUtils.contains(itemStack, predicate)) continue;
            return true;
        }
        return false;
    }

    private void swap(int first, int second) {
        if (first == second) {
            return;
        }
        class_1799 firstStack = this.method_5438(first);
        class_1799 secondStack = this.method_5438(second);
        this.method_5447(first, secondStack);
        this.method_5447(second, firstStack);
    }

    private int map(int index) {
        return this.indexMapping.getInt(index);
    }
}

