/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.wheel.page;

import java.lang.ref.ReferenceQueue;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.class_2168;
import org.carpetorgaddition.wheel.page.PagedCache;
import org.carpetorgaddition.wheel.page.PagedCollection;

public class PageManager {
    private final ReferenceQueue<PagedCollection> referenceQueue = new ReferenceQueue();
    private final HashMap<Integer, PagedCache> pagingList = new HashMap();
    private int currentId = 0;

    public void tick() {
        PagedCache cache;
        while ((cache = (PagedCache)this.referenceQueue.poll()) != null) {
            this.pagingList.remove(cache.getId());
        }
        this.pagingList.entrySet().removeIf(entry -> ((PagedCache)entry.getValue()).canFreeMemory());
    }

    public PagedCollection newPagedCollection(class_2168 source) {
        PagedCollection collection = new PagedCollection(this.currentId, source);
        this.pagingList.put(this.currentId, new PagedCache(collection, this.referenceQueue, this.currentId));
        ++this.currentId;
        return collection;
    }

    public Optional<PagedCollection> get(int id) {
        PagedCache cache = this.pagingList.get(id);
        if (cache == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((PagedCollection)cache.get());
    }
}

