/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.task.search;

import carpet.patches.EntityPlayerMPFake;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1492;
import net.minecraft.class_1533;
import net.minecraft.class_1542;
import net.minecraft.class_1646;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2624;
import net.minecraft.class_7265;
import net.minecraft.class_7298;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.command.FinderCommand;
import org.carpetorgaddition.exception.TaskExecutionException;
import org.carpetorgaddition.mixin.accessor.AbstractHorseEntityAccessor;
import org.carpetorgaddition.periodic.task.ServerTask;
import org.carpetorgaddition.util.CommandUtils;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.wheel.BlockEntityRegion;
import org.carpetorgaddition.wheel.ItemStackStatistics;
import org.carpetorgaddition.wheel.TextBuilder;
import org.carpetorgaddition.wheel.inventory.ImmutableInventory;
import org.carpetorgaddition.wheel.page.PageManager;
import org.carpetorgaddition.wheel.page.PagedCollection;
import org.carpetorgaddition.wheel.predicate.ItemStackPredicate;
import org.carpetorgaddition.wheel.provider.TextProvider;

public class ItemSearchTask
extends ServerTask {
    private final class_1937 world;
    private final BlockEntityRegion blockEntities;
    private final class_2168 source;
    private Iterator<class_1297> entitySearchIterator;
    private Iterator<class_2586> blockEntitySearchIterator;
    private FindState findState;
    private int count;
    private boolean shulkerBox;
    private long startTime;
    private int tickCount;
    private final ItemStackPredicate predicate;
    private final ArrayList<Result> results = new ArrayList();
    private final PagedCollection pagedCollection;

    public ItemSearchTask(class_1937 world, ItemStackPredicate predicate, BlockEntityRegion blockEntities, class_2168 source) {
        this.world = world;
        this.blockEntities = blockEntities;
        this.findState = FindState.BLOCK;
        this.tickCount = 0;
        this.predicate = predicate;
        this.source = source;
        PageManager pageManager = FetcherUtils.getPageManager(source.method_9211());
        this.pagedCollection = pageManager.newPagedCollection(this.source);
    }

    /*
     * Exception decompiling
     */
    @Override
    public void tick() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void searchFromContainer() {
        if (this.blockEntitySearchIterator == null) {
            this.blockEntitySearchIterator = this.blockEntities.iterator();
        }
        while (this.blockEntitySearchIterator.hasNext()) {
            class_2561 class_25612;
            if (this.timeout()) {
                return;
            }
            class_2586 blockEntity = this.blockEntitySearchIterator.next();
            class_2338 blockPos = blockEntity.method_11016();
            if (!(blockEntity instanceof class_1263)) continue;
            class_1263 inventory = (class_1263)blockEntity;
            if (inventory instanceof class_2624) {
                class_2624 lockableContainer = (class_2624)inventory;
                class_25612 = lockableContainer.method_5477();
            } else {
                class_25612 = this.world.method_8320(blockPos).method_26204().method_9518();
            }
            class_2561 containerName = class_25612;
            this.count(inventory, blockPos, containerName);
        }
        this.findState = FindState.ENTITY;
    }

    private void searchFromEntity() {
        class_238 box = this.blockEntities.toBox();
        if (this.entitySearchIterator == null) {
            this.entitySearchIterator = this.world.method_18467(class_1297.class, box).iterator();
        }
        block9: while (this.entitySearchIterator.hasNext()) {
            if (this.timeout()) {
                return;
            }
            class_1297 entity = this.entitySearchIterator.next();
            Objects.requireNonNull(entity);
            int n = 0;
            block10: while (true) {
                class_1297 class_12972;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_1542.class, EntityPlayerMPFake.class, class_7265.class, class_1533.class, class_1646.class, class_1492.class, class_7298.class}, (Object)class_12972, n)) {
                    case 0: {
                        class_1542 itemEntity = (class_1542)class_12972;
                        class_2561 drops = TextBuilder.translate("carpet.commands.finder.item.drops", new Object[0]);
                        this.count((class_1263)new class_1277(new class_1799[]{itemEntity.method_6983()}), itemEntity.method_24515(), drops);
                        break block10;
                    }
                    case 1: {
                        EntityPlayerMPFake fakePlayer = (EntityPlayerMPFake)class_12972;
                        class_7265 inventory = fakePlayer.method_31548();
                        this.count((class_1263)inventory, fakePlayer.method_24515(), fakePlayer.method_5477());
                        break block10;
                    }
                    case 2: {
                        class_7265 inventory = (class_7265)class_12972;
                        this.count((class_1263)inventory, entity.method_24515(), entity.method_5477());
                        break block10;
                    }
                    case 3: {
                        class_1533 itemFrame = (class_1533)class_12972;
                        class_1799 itemStack = itemFrame.method_6940();
                        if (itemStack == null) continue block9;
                        Object inventory = new ImmutableInventory(itemStack);
                        this.count((class_1263)inventory, itemFrame.method_24515(), itemFrame.method_5477());
                        break block10;
                    }
                    case 4: {
                        class_1646 villager = (class_1646)class_12972;
                        if (!CarpetOrgAdditionSettings.openVillagerInventory.get().booleanValue()) {
                            n = 5;
                            continue block10;
                        }
                        Object inventory = villager.method_35199();
                        this.count((class_1263)inventory, villager.method_24515(), villager.method_5477());
                        break block10;
                    }
                    case 5: {
                        class_1492 donkey = (class_1492)class_12972;
                        if (!donkey.method_6703()) {
                            n = 6;
                            continue block10;
                        }
                        ArrayList<class_1799> list = new ArrayList<class_1799>();
                        AbstractHorseEntityAccessor accessor = (AbstractHorseEntityAccessor)donkey;
                        class_1277 inventory = accessor.getDonkeyInventory();
                        for (int i = 1; i < inventory.method_5439(); ++i) {
                            list.add(inventory.method_5438(i));
                        }
                        this.count(new ImmutableInventory(list), donkey.method_24515(), donkey.method_5477());
                        break block10;
                    }
                    case 6: {
                        class_7298 allay = (class_7298)class_12972;
                        ImmutableInventory inventory = new ImmutableInventory(allay.method_6047());
                        this.count(inventory, allay.method_24515(), allay.method_5477());
                        break block10;
                    }
                }
                break;
            }
        }
        this.findState = FindState.SORT;
    }

    private void count(class_1263 inventory, class_2338 blockPos, class_2561 containerName) {
        ItemStackStatistics statistics = new ItemStackStatistics(this.predicate);
        statistics.statistics(inventory);
        if (statistics.getSum() == 0) {
            return;
        }
        this.count += statistics.getSum();
        if (statistics.hasNestingItem()) {
            this.shulkerBox = true;
        }
        this.results.add(new Result(blockPos, containerName, statistics));
        if (this.results.size() > 30000) {
            Runnable function = () -> MessageUtils.sendErrorMessage(this.source, "carpet.commands.finder.item.too_much_container", this.predicate.toText());
            throw new TaskExecutionException(function);
        }
    }

    private void sort() {
        if (this.results.isEmpty()) {
            MessageUtils.sendMessage(this.source, "carpet.commands.finder.item.find.not_item", this.predicate.toText());
            this.findState = FindState.END;
            return;
        }
        this.results.sort((o1, o2) -> o2.statistics().getSum() - o1.statistics().getSum());
        this.findState = FindState.FEEDBACK;
    }

    private void feedback() {
        class_2561 itemCount;
        Optional<class_1792> optional = this.predicate.getConvert();
        if (optional.isPresent()) {
            itemCount = FinderCommand.showCount(optional.get().method_7854(), this.count, this.shulkerBox);
        } else {
            TextBuilder builder = new TextBuilder(this.count);
            if (this.shulkerBox) {
                builder.setItalic();
            }
            itemCount = builder.build();
        }
        int size = this.results.size();
        MessageUtils.sendEmptyMessage(this.source);
        MessageUtils.sendMessage(this.source, "carpet.commands.finder.item.find", size, itemCount, this.predicate.toText());
        this.pagedCollection.addContent(this.results);
        CommandUtils.handlingException(this.pagedCollection::print, this.source);
        this.findState = FindState.END;
    }

    private boolean timeout() {
        return System.currentTimeMillis() - this.startTime > 200L;
    }

    @Override
    public boolean stopped() {
        return this.findState == FindState.END;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.source.method_44023());
    }

    @Override
    public boolean equals(Object obj) {
        if (this.getClass() == obj.getClass()) {
            return Objects.equals(this.source.method_44023(), ((ItemSearchTask)obj).source.method_44023());
        }
        return false;
    }

    @Override
    public String getLogName() {
        return "\u7269\u54c1\u67e5\u627e";
    }

    public static enum FindState {
        BLOCK,
        ENTITY,
        SORT,
        FEEDBACK,
        END;

    }

    public record Result(class_2338 blockPos, class_2561 containerName, ItemStackStatistics statistics) implements Supplier<class_2561>
    {
        @Override
        public class_2561 get() {
            return TextBuilder.translate("carpet.commands.finder.item.each", TextProvider.blockPos(this.blockPos, class_124.field_1060), this.containerName, this.statistics.getCountText());
        }
    }
}

