/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.wheel;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class Counter<E>
implements Iterable<E> {
    private final HashMap<E, Integer> counter = new HashMap();

    public void add(E element) {
        this.add(element, 1);
    }

    public void decrement(E element) {
        this.add(element, -1);
    }

    public void add(E element, int count) {
        Integer i = this.counter.get(element);
        this.counter.put(element, i == null ? count : i + count);
    }

    public void set(E element, int count) {
        this.counter.put(element, count);
    }

    public int getCount(E element) {
        Integer i = this.counter.get(element);
        return i == null ? 0 : i;
    }

    public int size() {
        return this.counter.size();
    }

    public boolean isEmpty() {
        return this.counter.isEmpty();
    }

    public Stream<Map.Entry<E, Integer>> stream() {
        return this.counter.entrySet().stream();
    }

    public Set<E> keySet() {
        return this.counter.keySet();
    }

    public void trim() {
        this.counter.entrySet().removeIf(entry -> (Integer)entry.getValue() == 0);
    }

    public E getMostOrDefault(E value) {
        return (E)this.stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElse(value);
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private final Iterator<Map.Entry<E, Integer>> iterator;
            {
                this.iterator = Counter.this.counter.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public E next() {
                return this.iterator.next().getKey();
            }
        };
    }

    public String toString() {
        return this.counter.toString();
    }

    public static abstract class Wrapper<T> {
        private final T value;

        public Wrapper(T value) {
            this.value = value;
        }

        public final T getValue() {
            return this.value;
        }

        public final boolean equals(Object obj) {
            if (obj instanceof Wrapper) {
                Wrapper wrapper = (Wrapper)obj;
                return this.valueEquals(this.value, wrapper.value);
            }
            return false;
        }

        public final int hashCode() {
            return this.valueHashCode(this.value);
        }

        public abstract boolean valueEquals(T var1, Object var2);

        public abstract int valueHashCode(T var1);

        public String toString() {
            return this.value.toString();
        }
    }
}

