/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.wheel;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.authlib.GameProfile;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.util.IOUtils;
import org.carpetorgaddition.wheel.LazyValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public class GameProfileCache {
    private static final LazyValue<File> CONFIG = new LazyValue<File>(IOUtils.configFile("profile.json"), GameProfileCache::init);
    private static final Table TABLE = new Table();
    private static final ReentrantReadWriteLock LOCK = new ReentrantReadWriteLock();
    private static boolean changed = false;
    public static final String MOJANG_API = "https://api.minecraftservices.com/minecraft/profile/lookup/%s";

    private GameProfileCache() {
    }

    public static Optional<String> get(UUID uuid) {
        try {
            LOCK.readLock().lock();
            Optional<String> optional = TABLE.get(uuid);
            return optional;
        }
        finally {
            LOCK.readLock().unlock();
        }
    }

    public static Optional<GameProfile> getGameProfile(UUID uuid) {
        Optional<String> optional = GameProfileCache.get(uuid);
        return optional.map(name -> new GameProfile(uuid, name));
    }

    public static Optional<GameProfile> getGameProfile(@NotNull String name) {
        try {
            LOCK.readLock().lock();
            Optional<Map.Entry<UUID, String>> optional = TABLE.get(name);
            Optional<GameProfile> optional2 = optional.map(value -> new GameProfile((UUID)value.getKey(), (String)value.getValue()));
            return optional2;
        }
        finally {
            LOCK.readLock().unlock();
        }
    }

    public static void put(GameProfile gameProfile) {
        GameProfileCache.put(gameProfile.getId(), gameProfile.getName());
    }

    public static void put(UUID uuid, String name) {
        try {
            LOCK.writeLock().lock();
            TABLE.put(uuid, name);
            changed = true;
        }
        finally {
            LOCK.writeLock().unlock();
        }
    }

    private static void mergeUsercache() {
        try {
            JsonArray array = IOUtils.loadJson(IOUtils.USERCACHE_JSON, JsonArray.class);
            Set set = array.asList().stream().map(JsonElement::getAsJsonObject).map(json -> Map.entry(json.get("name").getAsString(), json.get("uuid").getAsString())).collect(Collectors.toSet());
            for (Map.Entry entry : set) {
                String name = (String)entry.getKey();
                UUID uuid = UUID.fromString((String)entry.getValue());
                GameProfileCache.put(uuid, name);
            }
        }
        catch (IOException | RuntimeException e) {
            CarpetOrgAddition.LOGGER.warn("Unable to merge usercahce.json into profile.json", (Throwable)e);
        }
    }

    private static void init(File config) {
        File file;
        if (!config.isFile() && (file = IOUtils.configFile("uuid_name_mapping.txt")).isFile()) {
            try {
                BufferedReader reader;
                try (BufferedReader bufferedReader = reader = IOUtils.toReader(file);){
                    GameProfileCache.migration(reader);
                    changed = true;
                }
                GameProfileCache.save();
                IOUtils.deprecatedFile(file);
                return;
            }
            catch (IOException e) {
                CarpetOrgAddition.LOGGER.error("Unable to migrate uuid_name_mapping.txt to profile.json", (Throwable)e);
            }
        }
        if (config.isFile()) {
            try {
                GameProfileCache.load();
            }
            catch (JsonParseException | IOException | NullPointerException e) {
                CarpetOrgAddition.LOGGER.error("Unable to read the mapping table between player UUID and name from the file", e);
            }
        }
        GameProfileCache.mergeUsercache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void migration(BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            UUID uuid;
            String[] split = line.split("=");
            if (split.length != 2) continue;
            try {
                uuid = UUID.fromString(split[0].strip());
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            String name = split[1].strip();
            if (name.isEmpty()) continue;
            try {
                LOCK.writeLock().lock();
                TABLE.put(uuid, name);
            }
            finally {
                LOCK.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load() throws IOException {
        JsonObject json = IOUtils.loadJson(CONFIG.get());
        JsonArray array = json.getAsJsonArray("usercache");
        for (JsonElement element : array) {
            String name;
            UUID uuid;
            try {
                JsonObject entry = element.getAsJsonObject();
                uuid = UUID.fromString(entry.get("uuid").getAsString());
                name = entry.get("name").getAsString();
            }
            catch (RuntimeException e) {
                continue;
            }
            try {
                LOCK.writeLock().lock();
                TABLE.put(uuid, name);
            }
            finally {
                LOCK.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save() {
        if (changed) {
            JsonObject json = new JsonObject();
            json.addProperty("data_version", (Number)2);
            JsonArray array = new JsonArray();
            try {
                LOCK.readLock().lock();
                Set<Map.Entry<UUID, String>> entries = TABLE.entrySet();
                for (Map.Entry<UUID, String> entry : entries) {
                    JsonObject profile = new JsonObject();
                    profile.addProperty("uuid", entry.getKey().toString());
                    profile.addProperty("name", entry.getValue());
                    array.add((JsonElement)profile);
                }
            }
            finally {
                LOCK.readLock().unlock();
            }
            json.addProperty("count", (Number)array.size());
            json.add("usercache", (JsonElement)array);
            try {
                IOUtils.write(CONFIG.get(), json);
                changed = false;
            }
            catch (IOException e) {
                CarpetOrgAddition.LOGGER.error("Unable to write the mapping table between player UUID and name to the file", (Throwable)e);
            }
        }
    }

    public static class Table {
        private final HashMap<String, HashSet<String>> usernames = new HashMap();
        private final BiMap<UUID, String> map = HashBiMap.create();

        @VisibleForTesting
        public Optional<Map.Entry<UUID, String>> get(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Null as a parameter");
            }
            Set set = this.usernames.get(name.toLowerCase(Locale.ROOT));
            if (set == null || set.isEmpty()) {
                return Optional.empty();
            }
            String actualName = set.stream().min(this.createComparator(name)).orElseThrow();
            UUID uuid = (UUID)this.map.inverse().get((Object)actualName);
            if (uuid == null) {
                return Optional.empty();
            }
            return Optional.of(Map.entry(uuid, actualName));
        }

        @VisibleForTesting
        public Optional<String> get(UUID uuid) {
            return Optional.ofNullable((String)this.map.get((Object)uuid));
        }

        @VisibleForTesting
        public void put(UUID uuid, String name) {
            String lowerCase = name.toLowerCase(Locale.ROOT);
            Set set = this.usernames.get(lowerCase);
            if (set == null) {
                HashSet<String> names = new HashSet<String>();
                names.add(name);
                this.usernames.put(lowerCase, names);
            } else {
                set.add(name);
            }
            this.map.forcePut((Object)uuid, (Object)name);
        }

        private Comparator<String> createComparator(String name) {
            return (o1, o2) -> {
                if (o1.equals(o2)) {
                    return 0;
                }
                if (o1.equalsIgnoreCase((String)o2)) {
                    for (int i = 0; i < name.length(); ++i) {
                        if (o1.charAt(i) == o2.charAt(i)) continue;
                        if (o1.charAt(i) == name.charAt(i)) {
                            return -1;
                        }
                        return 1;
                    }
                }
                throw new IllegalArgumentException();
            };
        }

        private void remove(String name) {
            String lowerCase = name.toLowerCase(Locale.ROOT);
            Set set = this.usernames.get(lowerCase);
            if (set == null) {
                return;
            }
            if (set.remove(name)) {
                if (set.isEmpty()) {
                    this.usernames.remove(lowerCase);
                }
                this.map.inverse().remove((Object)name);
            }
        }

        private void remove(UUID uuid) {
            String name = (String)this.map.get((Object)uuid);
            if (name == null) {
                return;
            }
            this.remove(name);
        }

        private Set<Map.Entry<UUID, String>> entrySet() {
            return this.map.entrySet();
        }
    }
}

