/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.client.command.argument;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1887;
import net.minecraft.class_1928;
import net.minecraft.class_1934;
import net.minecraft.class_1959;
import net.minecraft.class_2172;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_746;
import net.minecraft.class_7696;
import net.minecraft.class_7699;
import net.minecraft.class_7701;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.carpetorgaddition.client.util.ClientCommandUtils;
import org.carpetorgaddition.client.util.ClientUtils;
import org.carpetorgaddition.util.CommandUtils;
import org.carpetorgaddition.util.EnchantmentUtils;
import org.carpetorgaddition.wheel.TextBuilder;

public abstract class ClientObjectArgumentType<T>
implements ArgumentType<List<T>> {
    private static final List<String> PATTERNS = Arrays.stream(MatchPattern.values()).map(MatchPattern::toString).toList();
    private final boolean patternMatching;

    private ClientObjectArgumentType() {
        this(false);
    }

    private ClientObjectArgumentType(boolean patternMatching) {
        this.patternMatching = patternMatching;
    }

    public static List<?> getType(CommandContext<FabricClientCommandSource> context, String name) {
        return (List)context.getArgument(name, List.class);
    }

    public List<T> parse(StringReader reader) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        String name = ClientCommandUtils.readWord(reader);
        MatchPattern pattern = this.patternMatching ? this.readParameters(reader) : MatchPattern.EQUAL;
        ArrayList<T> list = new ArrayList<T>();
        if (!name.isEmpty()) {
            for (T t : this.getRegistry().toList()) {
                if (!pattern.match(name.toLowerCase(Locale.ROOT), this.objectToString(t).toLowerCase(Locale.ROOT))) continue;
                list.add(t);
            }
        }
        if (list.isEmpty()) {
            reader.setCursor(cursor);
            throw CommandUtils.createException("carpet.client.commands.dictionary.not_matched", new Object[0]);
        }
        if (this.patternMatching && list.size() > 40 && pattern != MatchPattern.EQUAL) {
            reader.setCursor(cursor);
            throw CommandUtils.createException("carpet.client.command.string.broad", new Object[0]);
        }
        return list;
    }

    private MatchPattern readParameters(StringReader reader) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        reader.skipWhitespace();
        String mode = reader.readUnquotedString().toLowerCase(Locale.ROOT);
        if (mode.startsWith("-")) {
            return switch (mode) {
                case "-equal" -> MatchPattern.EQUAL;
                case "-contain" -> MatchPattern.CONTAIN;
                case "-regex" -> MatchPattern.REGEX;
                default -> throw CommandUtils.createException("carpet.client.command.matching_pattern.invalid", new Object[0]);
            };
        }
        reader.setCursor(cursor);
        return MatchPattern.EQUAL;
    }

    protected abstract String objectToString(T var1);

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        if (context.getSource() instanceof class_2172) {
            String[] array = (String[])this.getRegistry().map(this::objectToString).map(s -> s.contains(" ") ? "\"" + s + "\"" : s).toArray(String[]::new);
            String remaining = builder.getRemaining().toLowerCase(Locale.ROOT);
            String[] split = this.splitArguments(remaining);
            if (this.patternMatching && (split.length > 1 || remaining.endsWith(" "))) {
                StringReader reader = new StringReader(builder.getInput());
                if (split.length > 0) {
                    reader.setCursor(builder.getStart() + split[0].length());
                }
                reader.skipWhitespace();
                SuggestionsBuilder offset = builder.createOffset(reader.getCursor());
                for (String pattern : PATTERNS) {
                    if (reader.canRead() && (split.length <= 1 || !pattern.startsWith(split[1].toLowerCase(Locale.ROOT)))) continue;
                    offset.suggest(pattern);
                }
                return offset.buildFuture();
            }
            for (String candidate : array) {
                if (!candidate.toLowerCase(Locale.ROOT).contains(remaining)) continue;
                builder.suggest(candidate);
            }
            return builder.buildFuture();
        }
        return Suggestions.empty();
    }

    private String[] splitArguments(String remaining) {
        ArrayList<String> list = new ArrayList<String>();
        StringReader reader = new StringReader(remaining);
        while (reader.canRead()) {
            int cursor = reader.getCursor();
            try {
                ClientCommandUtils.readWord(reader);
                list.add(remaining.substring(cursor, reader.getCursor()));
                reader.skipWhitespace();
            }
            catch (CommandSyntaxException e) {
                break;
            }
        }
        return (String[])list.toArray(String[]::new);
    }

    protected abstract Stream<T> getRegistry();

    public static enum MatchPattern {
        EQUAL,
        CONTAIN,
        REGEX;


        private boolean match(String arguments, String str) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Objects.equals(str, arguments);
                case 1 -> str.contains(arguments);
                case 2 -> str.matches(arguments);
            };
        }

        public String toString() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "-equal";
                case 1 -> "-contain";
                case 2 -> "-regex";
            };
        }
    }

    public static class ClientGameRuleArgumentType
    extends ClientObjectArgumentType<class_1928.class_4313<?>> {
        @Override
        protected String objectToString(class_1928.class_4313<?> key) {
            return TextBuilder.translate(key.method_27334(), new Object[0]).getString();
        }

        @Override
        protected Stream<class_1928.class_4313<?>> getRegistry() {
            final ArrayList list = new ArrayList();
            new class_1928(class_7699.method_45398((class_7696)class_7701.field_52556)).method_20744(new class_1928.class_4311(){

                public <T extends class_1928.class_4315<T>> void method_20762(class_1928.class_4313<T> key, class_1928.class_4314<T> type) {
                    list.add(key);
                }
            });
            return list.stream();
        }
    }

    public static class ClientGameModeArgumentType
    extends ClientObjectArgumentType<class_1934> {
        @Override
        protected String objectToString(class_1934 gameMode) {
            return gameMode.method_8383().getString();
        }

        @Override
        protected Stream<class_1934> getRegistry() {
            return Stream.of(class_1934.values());
        }
    }

    public static class ClientBiomeArgumentType
    extends ClientObjectArgumentType<class_1959> {
        @Override
        protected String objectToString(class_1959 biome) {
            class_2378 biomes = ClientUtils.getPlayer().field_3944.method_29091().method_30530(class_7924.field_41236);
            return TextBuilder.translate(Objects.requireNonNull(biomes.method_10221((Object)biome)).method_42093("biome"), new Object[0]).getString();
        }

        @Override
        protected Stream<class_1959> getRegistry() {
            class_746 player = ClientUtils.getPlayer();
            return player.field_3944.method_29091().method_30530(class_7924.field_41236).method_10220();
        }
    }

    public static class ClientStatusEffectArgumentType
    extends ClientObjectArgumentType<class_1291> {
        @Override
        protected String objectToString(class_1291 statusEffect) {
            return statusEffect.method_5560().getString();
        }

        @Override
        protected Stream<class_1291> getRegistry() {
            class_746 player = ClientUtils.getPlayer();
            return player.field_3944.method_29091().method_30530(class_7924.field_41208).method_10220();
        }
    }

    public static class ClientEnchantmentArgumentType
    extends ClientObjectArgumentType<class_1887> {
        @Override
        protected String objectToString(class_1887 enchantment) {
            return EnchantmentUtils.getName(enchantment).getString();
        }

        @Override
        protected Stream<class_1887> getRegistry() {
            class_2378 registry = ClientUtils.getPlayer().field_3944.method_29091().method_30530(class_7924.field_41265);
            return registry.method_10220();
        }
    }

    public static class ClientEntityArgumentType
    extends ClientObjectArgumentType<class_1299<?>> {
        @Override
        protected String objectToString(class_1299<?> entityType) {
            return entityType.method_5897().getString();
        }

        @Override
        protected Stream<class_1299<?>> getRegistry() {
            class_746 player = ClientUtils.getPlayer();
            return player.field_3944.method_29091().method_30530(class_7924.field_41266).method_10220();
        }
    }

    public static class ClientBlockArgumentType
    extends ClientObjectArgumentType<class_2248> {
        public ClientBlockArgumentType(boolean patternMatching) {
            super(patternMatching);
        }

        @Override
        protected String objectToString(class_2248 block) {
            return block.method_9518().getString();
        }

        @Override
        protected Stream<class_2248> getRegistry() {
            return class_7923.field_41175.method_10220();
        }
    }

    public static class ClientItemArgumentType
    extends ClientObjectArgumentType<class_1792> {
        public ClientItemArgumentType(boolean patternMatching) {
            super(patternMatching);
        }

        @Override
        protected String objectToString(class_1792 item) {
            return item.method_63680().getString();
        }

        @Override
        protected Stream<class_1792> getRegistry() {
            return class_7923.field_41178.method_10220();
        }
    }
}

