/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.task.search;

import java.util.ArrayList;
import net.minecraft.class_124;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3988;
import org.carpetorgaddition.command.FinderCommand;
import org.carpetorgaddition.periodic.task.search.AbstractTradeSearchTask;
import org.carpetorgaddition.util.MathUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.wheel.TextBuilder;
import org.carpetorgaddition.wheel.predicate.ItemStackPredicate;
import org.carpetorgaddition.wheel.provider.TextProvider;
import org.carpetorgaddition.wheel.traverser.BlockPosTraverser;

public class TradeItemSearchTask
extends AbstractTradeSearchTask {
    private final ItemStackPredicate predicate;
    private final class_2561 treadName;

    public TradeItemSearchTask(class_1937 world, BlockPosTraverser blockPosTraverser, class_2338 sourcePos, ItemStackPredicate predicate, class_2168 source) {
        super(world, blockPosTraverser, sourcePos, source);
        this.predicate = predicate;
        this.treadName = predicate.toText();
    }

    @Override
    protected void searchVillager(class_3988 merchant) {
        class_1916 offers = merchant.method_8264();
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int index = 0; index < offers.size(); ++index) {
            if (!this.predicate.test(((class_1914)offers.get(index)).method_8250())) continue;
            list.add(index + 1);
            ++this.tradeCount;
        }
        if (list.isEmpty()) {
            return;
        }
        this.results.add(this.getResult(merchant, list));
        ++this.villagerCount;
    }

    private AbstractTradeSearchTask.Result getResult(final class_3988 merchant, final ArrayList<Integer> list) {
        return new AbstractTradeSearchTask.Result(){

            @Override
            public int compare(AbstractTradeSearchTask.Result o1, AbstractTradeSearchTask.Result o2) {
                return MathUtils.compareBlockPos(TradeItemSearchTask.this.sourcePos, o1.villagerPos(), o2.villagerPos());
            }

            @Override
            public class_2561 get() {
                class_2338 blockPos = merchant.method_24515();
                class_2561 villagerName = merchant.method_5477();
                return TextBuilder.translate("carpet.commands.finder.trade.item.each", TextProvider.blockPos(blockPos, class_124.field_1060), villagerName, AbstractTradeSearchTask.getIndexArray(list));
            }

            @Override
            public class_2338 villagerPos() {
                return merchant.method_24515();
            }
        };
    }

    @Override
    protected void notFound() {
        MessageUtils.sendMessage(this.source, "carpet.commands.finder.trade.item.not_trade", this.getTradeName(), FinderCommand.VILLAGER);
    }

    @Override
    protected class_2561 getTradeName() {
        return this.treadName;
    }

    @Override
    protected String getTradeResultKey() {
        return "carpet.commands.finder.trade.item.result";
    }
}

