/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.wheel.provider;

import carpet.patches.EntityPlayerMPFake;
import com.mojang.brigadier.arguments.StringArgumentType;
import java.util.StringJoiner;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import org.carpetorgaddition.client.command.AbstractClientCommand;
import org.carpetorgaddition.client.command.ClientCommandRegister;
import org.carpetorgaddition.client.command.HighlightCommand;
import org.carpetorgaddition.command.AbstractCommand;
import org.carpetorgaddition.command.AbstractServerCommand;
import org.carpetorgaddition.command.CommandRegister;
import org.carpetorgaddition.command.MailCommand;
import org.carpetorgaddition.command.NavigatorCommand;
import org.carpetorgaddition.command.OrangeCommand;
import org.carpetorgaddition.command.PlayerManagerCommand;
import org.carpetorgaddition.util.FetcherUtils;
import org.jetbrains.annotations.Nullable;

public class CommandProvider {
    private CommandProvider() {
    }

    public static String receiveExpress(int id, boolean force) {
        StringJoiner joiner = new StringJoiner(" ", "/", "");
        joiner.add(CommandProvider.getCommandName(MailCommand.class)).add("receive").add(String.valueOf(id));
        if (force) {
            joiner.add("true");
        }
        return joiner.toString();
    }

    public static String cancelExpress(int id, boolean force) {
        StringJoiner joiner = new StringJoiner(" ", "/", "");
        joiner.add(CommandProvider.getCommandName(MailCommand.class)).add("cancel").add(String.valueOf(id));
        if (force) {
            joiner.add("true");
        }
        return joiner.toString();
    }

    public static String interceptExpress(int id, boolean force) {
        StringJoiner joiner = new StringJoiner(" ", "/", "");
        joiner.add(CommandProvider.getCommandName(MailCommand.class)).add("intercept").add(String.valueOf(id));
        if (force) {
            joiner.add("true");
        }
        return joiner.toString();
    }

    public static String receiveAllExpress() {
        return "/%s receive".formatted(CommandProvider.getCommandName(MailCommand.class));
    }

    public static String cancelAllExpress() {
        return "/%s cancel".formatted(CommandProvider.getCommandName(MailCommand.class));
    }

    public static String navigateToUuidEntity(UUID uuid) {
        return "/%s uuid \"%s\"".formatted(CommandProvider.getCommandName(NavigatorCommand.class), uuid.toString());
    }

    public static String playerManagerSpawn(String playerName) {
        return "/%s spawn %s".formatted(CommandProvider.getCommandName(PlayerManagerCommand.class), playerName);
    }

    public static String playerManagerResave(String playerName) {
        return "/%s modify resave %s".formatted(CommandProvider.getCommandName(PlayerManagerCommand.class), playerName);
    }

    public static String setupSafeAfkPermanentlyChange(EntityPlayerMPFake player, float threshold) {
        String commandName = CommandProvider.getCommandName(PlayerManagerCommand.class);
        String playerName = FetcherUtils.getPlayerName((class_1657)player);
        return "/%s safeafk set %s %s true".formatted(commandName, playerName, Float.valueOf(threshold));
    }

    public static String cancelSafeAfkPermanentlyChange(EntityPlayerMPFake player) {
        String commandName = CommandProvider.getCommandName(PlayerManagerCommand.class);
        String playerName = FetcherUtils.getPlayerName((class_1657)player);
        return "/%s safeafk set %s -1 true".formatted(commandName, playerName);
    }

    public static String listGroupPlayer(String group, @Nullable String filter) {
        StringJoiner joiner = new StringJoiner(" ", "/", "");
        joiner.add(CommandProvider.getCommandName(PlayerManagerCommand.class));
        joiner.add("group list group");
        joiner.add(StringArgumentType.escapeIfRequired((String)group));
        if (filter != null) {
            joiner.add(StringArgumentType.escapeIfRequired((String)filter));
        }
        return joiner.toString();
    }

    public static String listUngroupedPlayer(@Nullable String filter) {
        StringJoiner joiner = new StringJoiner(" ", "/", "");
        joiner.add(CommandProvider.getCommandName(PlayerManagerCommand.class));
        joiner.add("group list ungrouped");
        if (filter != null) {
            joiner.add(StringArgumentType.escapeIfRequired((String)filter));
        }
        return joiner.toString();
    }

    public static String listAllPlayer(@Nullable String filter) {
        StringJoiner joiner = new StringJoiner(" ", "/", "");
        joiner.add(CommandProvider.getCommandName(PlayerManagerCommand.class));
        joiner.add("group list all");
        if (filter != null) {
            joiner.add(StringArgumentType.escapeIfRequired((String)filter));
        }
        return joiner.toString();
    }

    public static String spawnFakePlayer(String playerName) {
        return "/player %s spawn".formatted(playerName);
    }

    public static String killFakePlayer(String playerName) {
        return "/player %s kill".formatted(playerName);
    }

    public static String highlightWaypoint(class_2338 blockPos) {
        String name = CommandProvider.getClientCommandName(HighlightCommand.class, "highlight");
        return "/%s %s %s %s".formatted(name, blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
    }

    public static String highlightWaypointByOmmc(class_2338 blockPos) {
        return "/highlightWaypoint %s %s %s".formatted(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
    }

    public static String queryPlayerName(UUID uuid) {
        return "/%s textclickevent queryPlayerName %s".formatted(CommandProvider.getCommandName(OrangeCommand.class), uuid.toString());
    }

    public static String stopNavigate() {
        return "%s stop".formatted(CommandProvider.getCommandName(NavigatorCommand.class));
    }

    public static String drawParticleLine(double x1, double y1, double z1, double x2, double y2, double z2) {
        return "particleLine %s %s %s %s %s %s".formatted(x1, y1, z1, x2, y2, z2);
    }

    public static String openPlayerInventory(class_1657 player) {
        return CommandProvider.openPlayerInventory(FetcherUtils.getPlayerName(player));
    }

    public static String openPlayerInventory(String name) {
        return "/player %s inventory".formatted(name);
    }

    public static String openPlayerEnderChest(class_1657 player) {
        return CommandProvider.openPlayerEnderChest(FetcherUtils.getPlayerName(player));
    }

    public static String openPlayerEnderChest(String name) {
        return "/player %s enderChest".formatted(name);
    }

    public static String openPlayerInventory(UUID uuid) {
        return "/%s textclickevent openInventory %s inventory".formatted(CommandProvider.getCommandName(OrangeCommand.class), uuid.toString());
    }

    public static String openPlayerEnderChest(UUID uuid) {
        return "/%s textclickevent openInventory %s enderChest".formatted(CommandProvider.getCommandName(OrangeCommand.class), uuid.toString());
    }

    public static String pageTurning(int id, int number) {
        return "/%s textclickevent pageturning %s %s".formatted(CommandProvider.getCommandName(OrangeCommand.class), id, number);
    }

    public static String setCarpetRule(String rule, String value) {
        return "/carpet %s %s".formatted(rule, value);
    }

    public static String openPlayerCraftGui(EntityPlayerMPFake fakePlayer) {
        return "/playerAction %s craft gui".formatted(FetcherUtils.getPlayerName((class_1657)fakePlayer));
    }

    public static String openPlayerStonecuttingGui(EntityPlayerMPFake fakePlayer) {
        return "/playerAction %s stonecutting gui".formatted(FetcherUtils.getPlayerName((class_1657)fakePlayer));
    }

    private static <T extends AbstractServerCommand> String getCommandName(Class<T> clazz) {
        return ((AbstractCommand)CommandRegister.getCommandInstance(clazz)).getAvailableName();
    }

    private static <T extends AbstractClientCommand> String getClientCommandName(Class<T> clazz, String other) {
        T instance = ClientCommandRegister.getCommandInstance(clazz);
        if (instance == null) {
            return other;
        }
        return ((AbstractCommand)instance).getAvailableName();
    }
}

