/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.wheel.traverser;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Iterator;
import net.minecraft.class_2338;
import org.carpetorgaddition.util.MathUtils;
import org.carpetorgaddition.wheel.traverser.BlockPosTraverser;
import org.jetbrains.annotations.NotNull;

public class CylinderBlockPosTraverser
extends BlockPosTraverser {
    private final class_2338 center;
    private final int radius;
    private int size = -1;
    private static final Int2ObjectMap<Integer> SIZE_CACHE = new Int2ObjectArrayMap();

    public CylinderBlockPosTraverser(class_2338 center, int radius, int height) {
        super(center.method_10263() - radius, center.method_10264(), center.method_10260() - radius, center.method_10263() + radius, center.method_10264() + height - 1, center.method_10260() + radius);
        this.center = center;
        this.radius = radius;
    }

    @Override
    public boolean contains(class_2338 blockPos) {
        return super.contains(blockPos) && MathUtils.getCalculateBlockIntegerDistance(this.center, blockPos) <= this.radius;
    }

    @Override
    public int size() {
        if (this.size == -1) {
            if (super.size() == 0) {
                this.size = 0;
            } else {
                Integer cache = (Integer)SIZE_CACHE.get(this.radius);
                if (cache == null) {
                    BlockPosTraverser traverser = new BlockPosTraverser(this.minX, this.minY, this.minZ, this.maxX, this.minY, this.maxZ);
                    int size = 0;
                    for (class_2338 blockPos : traverser) {
                        if (!this.contains(blockPos)) continue;
                        ++size;
                    }
                    SIZE_CACHE.put(this.radius, (Object)size);
                    this.size = size * this.height();
                } else {
                    this.size = cache * this.height();
                }
            }
        }
        return this.size;
    }

    @Override
    public class_2338 randomBlockPos() {
        class_2338 blockPos;
        while (!this.contains(blockPos = super.randomBlockPos())) {
        }
        return blockPos;
    }

    public class_2338 getCenter() {
        return this.center;
    }

    public int getRadius() {
        return this.radius;
    }

    public int getHeight() {
        return this.height();
    }

    @Override
    @NotNull
    public Iterator<class_2338> iterator() {
        return new Iterator<class_2338>(){
            private final Iterator<class_2338> iterator;
            private class_2338 next;
            {
                this.iterator = CylinderBlockPosTraverser.super.iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    while (this.iterator.hasNext()) {
                        class_2338 next = this.iterator.next();
                        if (!CylinderBlockPosTraverser.this.contains(next)) continue;
                        this.next = next;
                        return true;
                    }
                    return false;
                }
                return true;
            }

            @Override
            public class_2338 next() {
                class_2338 result = this.next;
                this.next = null;
                return result;
            }
        };
    }
}

