/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.fakeplayer;

import carpet.fakes.ServerPlayerInterface;
import carpet.helpers.EntityPlayerActionPack;
import carpet.patches.EntityPlayerMPFake;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_2561;
import org.carpetorgaddition.mixin.accessor.carpet.EntityPlayerActionPackAccessor;
import org.carpetorgaddition.wheel.TextBuilder;
import org.carpetorgaddition.wheel.provider.TextProvider;

public class EntityPlayerActionPackSerial {
    private final Map<EntityPlayerActionPack.ActionType, EntityPlayerActionPack.Action> actionMap;
    public static final EntityPlayerActionPackSerial NO_ACTION = new EntityPlayerActionPackSerial();

    private EntityPlayerActionPackSerial() {
        this.actionMap = new EnumMap<EntityPlayerActionPack.ActionType, EntityPlayerActionPack.Action>(EntityPlayerActionPack.ActionType.class);
    }

    public EntityPlayerActionPackSerial(EntityPlayerActionPack actionPack) {
        this.actionMap = ((EntityPlayerActionPackAccessor)actionPack).getActions();
    }

    public EntityPlayerActionPackSerial(JsonObject json) {
        int interval;
        JsonObject attack;
        this.actionMap = new EnumMap<EntityPlayerActionPack.ActionType, EntityPlayerActionPack.Action>(EntityPlayerActionPack.ActionType.class);
        if (json.has("attack")) {
            attack = json.get("attack").getAsJsonObject();
            if (attack.get("continuous").getAsBoolean()) {
                this.actionMap.put(EntityPlayerActionPack.ActionType.ATTACK, EntityPlayerActionPack.Action.continuous());
            } else {
                interval = attack.get("interval").getAsInt();
                this.actionMap.put(EntityPlayerActionPack.ActionType.ATTACK, EntityPlayerActionPack.Action.interval((int)interval));
            }
        }
        if (json.has("use")) {
            attack = json.get("use").getAsJsonObject();
            if (attack.get("continuous").getAsBoolean()) {
                this.actionMap.put(EntityPlayerActionPack.ActionType.USE, EntityPlayerActionPack.Action.continuous());
            } else {
                interval = attack.get("interval").getAsInt();
                this.actionMap.put(EntityPlayerActionPack.ActionType.USE, EntityPlayerActionPack.Action.interval((int)interval));
            }
        }
    }

    public void startAction(EntityPlayerMPFake fakePlayer) {
        if (this == NO_ACTION) {
            return;
        }
        EntityPlayerActionPack action = ((ServerPlayerInterface)fakePlayer).getActionPack();
        for (Map.Entry<EntityPlayerActionPack.ActionType, EntityPlayerActionPack.Action> entry : this.actionMap.entrySet()) {
            action.start(entry.getKey(), entry.getValue());
        }
    }

    public boolean hasAction() {
        return this == NO_ACTION || !this.actionMap.isEmpty();
    }

    public class_2561 toText() {
        EntityPlayerActionPack.Action use;
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        EntityPlayerActionPack.Action attack = this.actionMap.get(EntityPlayerActionPack.ActionType.ATTACK);
        if (attack != null) {
            list.add(TextBuilder.translate("carpet.commands.playerManager.info.left_click", new Object[0]));
            if (((EntityPlayerActionPackAccessor.ActionAccessor)attack).isContinuous()) {
                list.add(TextBuilder.combineAll(TextProvider.INDENT_SYMBOL, TextBuilder.translate("carpet.commands.playerManager.info.continuous", new Object[0])));
            } else {
                list.add(TextBuilder.combineAll(TextProvider.INDENT_SYMBOL, TextBuilder.translate("carpet.commands.playerManager.info.interval", attack.interval)));
            }
        }
        if ((use = this.actionMap.get(EntityPlayerActionPack.ActionType.USE)) != null) {
            list.add(TextBuilder.translate("carpet.commands.playerManager.info.right_click", new Object[0]));
            if (((EntityPlayerActionPackAccessor.ActionAccessor)use).isContinuous()) {
                list.add(TextBuilder.combineAll(TextProvider.INDENT_SYMBOL, TextBuilder.translate("carpet.commands.playerManager.info.continuous", new Object[0])));
            } else {
                list.add(TextBuilder.combineAll(TextProvider.INDENT_SYMBOL, TextBuilder.translate("carpet.commands.playerManager.info.interval", use.interval)));
            }
        }
        return TextBuilder.joinList(list);
    }

    public JsonObject toJson() {
        EntityPlayerActionPack.Action use;
        JsonObject json = new JsonObject();
        EntityPlayerActionPack.Action attack = this.actionMap.get(EntityPlayerActionPack.ActionType.ATTACK);
        if (attack != null && !attack.done) {
            JsonObject attackJson = new JsonObject();
            attackJson.addProperty("interval", (Number)attack.interval);
            attackJson.addProperty("continuous", Boolean.valueOf(((EntityPlayerActionPackAccessor.ActionAccessor)attack).isContinuous()));
            json.add("attack", (JsonElement)attackJson);
        }
        if ((use = this.actionMap.get(EntityPlayerActionPack.ActionType.USE)) != null && !use.done) {
            JsonObject useJson = new JsonObject();
            useJson.addProperty("interval", (Number)use.interval);
            useJson.addProperty("continuous", Boolean.valueOf(((EntityPlayerActionPackAccessor.ActionAccessor)use).isContinuous()));
            json.add("use", (JsonElement)useJson);
        }
        return json;
    }
}

