/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.wheel;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.authlib.GameProfile;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.util.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public class GameProfileCache {
    private static final Table TABLE = new Table();
    private static final ReentrantReadWriteLock LOCK = new ReentrantReadWriteLock();
    private static final File CONFIG = IOUtils.configFile("profile.json");
    private static boolean changed = false;
    public static final String MOJANG_API = "https://api.minecraftservices.com/minecraft/profile/lookup/%s";

    private GameProfileCache() {
    }

    public static Optional<String> get(UUID uuid) {
        try {
            LOCK.readLock().lock();
            Optional<String> optional = TABLE.get(uuid);
            return optional;
        }
        finally {
            LOCK.readLock().unlock();
        }
    }

    public static Optional<GameProfile> getGameProfile(UUID uuid) {
        Optional<String> optional = GameProfileCache.get(uuid);
        return optional.map(name -> new GameProfile(uuid, name));
    }

    public static Optional<GameProfile> getGameProfile(@NotNull String name) {
        try {
            LOCK.readLock().lock();
            Optional<UUID> optional = TABLE.get(name);
            Optional<GameProfile> optional2 = optional.map(value -> new GameProfile(value, name));
            return optional2;
        }
        finally {
            LOCK.readLock().unlock();
        }
    }

    public static void put(GameProfile gameProfile) {
        GameProfileCache.put(gameProfile.getId(), gameProfile.getName());
    }

    public static void put(UUID uuid, String name) {
        try {
            LOCK.writeLock().lock();
            TABLE.put(uuid, name);
            changed = true;
        }
        finally {
            LOCK.writeLock().unlock();
        }
    }

    private static void mergeUsercache() {
        try {
            JsonArray array = IOUtils.loadJson(IOUtils.USERCACHE_JSON, JsonArray.class);
            Set set = array.asList().stream().map(JsonElement::getAsJsonObject).map(json -> Map.entry(json.get("name").getAsString(), json.get("uuid").getAsString())).collect(Collectors.toSet());
            for (Map.Entry entry : set) {
                String name = (String)entry.getKey();
                UUID uuid = UUID.fromString((String)entry.getValue());
                GameProfileCache.put(uuid, name);
            }
        }
        catch (IOException | RuntimeException e) {
            CarpetOrgAddition.LOGGER.warn("Unable to merge usercahce.json into profile.json", (Throwable)e);
        }
    }

    public static void init() {
        File file;
        if (!CONFIG.isFile() && (file = IOUtils.configFile("uuid_name_mapping.txt")).isFile()) {
            try {
                BufferedReader reader;
                try (BufferedReader bufferedReader = reader = IOUtils.toReader(file);){
                    GameProfileCache.migration(reader);
                    changed = true;
                }
                GameProfileCache.save();
                IOUtils.deprecatedFile(file);
                return;
            }
            catch (IOException e) {
                CarpetOrgAddition.LOGGER.error("Unable to migrate uuid_name_mapping.txt to profile.json", (Throwable)e);
            }
        }
        try {
            GameProfileCache.load();
        }
        catch (JsonParseException | IOException | NullPointerException e) {
            CarpetOrgAddition.LOGGER.error("Unable to read the mapping table between player UUID and name from the file", e);
        }
        GameProfileCache.mergeUsercache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void migration(BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            UUID uuid;
            String[] split = line.split("=");
            if (split.length != 2) continue;
            try {
                uuid = UUID.fromString(split[0].strip());
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            String name = split[1].strip();
            if (name.isEmpty()) continue;
            try {
                LOCK.writeLock().lock();
                TABLE.put(uuid, name);
            }
            finally {
                LOCK.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load() throws IOException {
        JsonObject json = IOUtils.loadJson(CONFIG);
        JsonArray array = json.getAsJsonArray("usercache");
        for (JsonElement element : array) {
            String name;
            UUID uuid;
            try {
                JsonObject entry = element.getAsJsonObject();
                uuid = UUID.fromString(entry.get("uuid").getAsString());
                name = entry.get("name").getAsString();
            }
            catch (RuntimeException e) {
                continue;
            }
            try {
                LOCK.writeLock().lock();
                TABLE.put(uuid, name);
            }
            finally {
                LOCK.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save() {
        if (changed) {
            JsonObject json = new JsonObject();
            json.addProperty("data_version", (Number)2);
            JsonArray array = new JsonArray();
            try {
                LOCK.readLock().lock();
                Set<Map.Entry<UUID, String>> entries = TABLE.entrySet();
                for (Map.Entry<UUID, String> entry : entries) {
                    JsonObject profile = new JsonObject();
                    profile.addProperty("uuid", entry.getKey().toString());
                    profile.addProperty("name", entry.getValue());
                    array.add((JsonElement)profile);
                }
            }
            finally {
                LOCK.readLock().unlock();
            }
            json.addProperty("count", (Number)array.size());
            json.add("usercache", (JsonElement)array);
            try {
                IOUtils.write(CONFIG, json);
                changed = false;
            }
            catch (IOException e) {
                CarpetOrgAddition.LOGGER.error("Unable to write the mapping table between player UUID and name to the file", (Throwable)e);
            }
        }
    }

    public static class Table {
        private final HashMap<String, HashSet<String>> usernames = new HashMap();
        private final HashMap<UUID, String> uuidToName = new HashMap();
        private final HashMap<String, UUID> nameToUuid = new HashMap();

        @VisibleForTesting
        public Optional<UUID> get(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Null as a parameter");
            }
            HashSet<String> set = this.usernames.get(name.toLowerCase(Locale.ROOT));
            if (set == null || set.isEmpty()) {
                return Optional.empty();
            }
            for (String playerName : set) {
                if (!name.equals(playerName)) continue;
                return Optional.of(this.nameToUuid.get(playerName));
            }
            return Optional.of(this.nameToUuid.get(set.iterator().next()));
        }

        @VisibleForTesting
        public Optional<String> get(UUID uuid) {
            return Optional.ofNullable(this.uuidToName.get(uuid));
        }

        @VisibleForTesting
        public void put(UUID uuid, String name) {
            String lowerCase = name.toLowerCase(Locale.ROOT);
            HashSet<String> set = this.usernames.get(lowerCase);
            if (set == null) {
                HashSet<String> names = new HashSet<String>();
                names.add(name);
                this.usernames.put(lowerCase, names);
            } else {
                set.add(name);
            }
            this.nameToUuid.put(name, uuid);
            this.uuidToName.put(uuid, name);
        }

        @VisibleForTesting
        public void remove(String name) {
            String lowerCase = name.toLowerCase(Locale.ROOT);
            HashSet<String> set = this.usernames.get(lowerCase);
            if (set == null) {
                return;
            }
            if (set.remove(name)) {
                if (set.isEmpty()) {
                    this.usernames.remove(lowerCase);
                }
                UUID uuid = this.nameToUuid.get(name);
                this.nameToUuid.remove(name);
                this.uuidToName.remove(uuid);
            }
        }

        @VisibleForTesting
        public void remove(UUID uuid) {
            String name = this.uuidToName.get(uuid);
            if (name == null) {
                return;
            }
            this.remove(name);
        }

        private Set<Map.Entry<UUID, String>> entrySet() {
            return this.uuidToName.entrySet();
        }
    }
}

