/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.task.search;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3988;
import org.carpetorgaddition.command.FinderCommand;
import org.carpetorgaddition.exception.TaskExecutionException;
import org.carpetorgaddition.periodic.task.ServerTask;
import org.carpetorgaddition.util.CommandUtils;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.wheel.page.PageManager;
import org.carpetorgaddition.wheel.page.PagedCollection;
import org.carpetorgaddition.wheel.traverser.BlockPosTraverser;

public abstract class AbstractTradeSearchTask
extends ServerTask {
    protected final class_1937 world;
    protected final BlockPosTraverser blockPosTraverser;
    protected final class_2338 sourcePos;
    protected Iterator<class_3988> iterator;
    private final PagedCollection pagedCollection;
    private FindState findState;
    protected final ArrayList<Result> results = new ArrayList();
    protected int villagerCount;
    protected int tradeCount;

    public AbstractTradeSearchTask(class_1937 world, BlockPosTraverser blockPosTraverser, class_2338 sourcePos, class_2168 source) {
        super(source);
        this.world = world;
        this.blockPosTraverser = blockPosTraverser;
        this.sourcePos = sourcePos;
        this.findState = FindState.SEARCH;
        PageManager pageManager = FetcherUtils.getPageManager(source.method_9211());
        this.pagedCollection = pageManager.newPagedCollection(this.source);
    }

    @Override
    public void tick() {
        this.checkTimeout();
        block7: while (this.isTimeRemaining()) {
            try {
                switch (this.findState.ordinal()) {
                    case 0: {
                        this.searchVillager();
                        continue block7;
                    }
                    case 1: {
                        this.sort();
                        continue block7;
                    }
                    case 2: {
                        this.feedback();
                        continue block7;
                    }
                }
                return;
            }
            catch (TaskExecutionException e) {
                e.disposal();
                this.findState = FindState.END;
                return;
            }
        }
    }

    private void searchVillager() {
        if (this.iterator == null) {
            this.iterator = this.world.method_18467(class_3988.class, this.blockPosTraverser.toBox()).iterator();
        }
        while (this.iterator.hasNext()) {
            if (this.isTimeExpired()) {
                return;
            }
            class_3988 merchant = this.iterator.next();
            this.searchVillager(merchant);
        }
        if (this.results.isEmpty()) {
            this.finish();
            return;
        }
        this.findState = FindState.SORT;
    }

    protected abstract void searchVillager(class_3988 var1);

    protected abstract void notFound();

    protected abstract class_2561 getTradeName();

    private void sort() {
        this.results.sort((o1, o2) -> o1.compare(o1, o2));
        this.findState = FindState.FEEDBACK;
    }

    private void feedback() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(this.villagerCount);
        list.add((Integer)this.getTradeName());
        list.add((Integer)FinderCommand.VILLAGER);
        list.add(this.tradeCount);
        String key = this.getTradeResultKey();
        MessageUtils.sendEmptyMessage(this.source);
        MessageUtils.sendMessage(this.source, key, (Object[])list.toArray(Object[]::new));
        this.pagedCollection.addContent(this.results);
        CommandUtils.handlingException(this.pagedCollection::print, this.source);
        this.findState = FindState.END;
    }

    protected abstract String getTradeResultKey();

    @Override
    public boolean stopped() {
        return this.findState == FindState.END;
    }

    private void finish() {
        this.notFound();
        this.findState = FindState.END;
    }

    @Override
    public long getMaxExecutionTime() {
        return 5000L;
    }

    @Override
    protected long getMaxTimeSlice() {
        return 30L;
    }

    protected static String getIndexArray(ArrayList<Integer> list) {
        if (list.size() == 1) {
            return list.getFirst().toString();
        }
        StringJoiner stringJoiner = new StringJoiner(", ", "[", "]");
        for (Integer index : list) {
            stringJoiner.add(index.toString());
        }
        String indexArray = stringJoiner.toString();
        return indexArray;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof AbstractTradeSearchTask) {
            AbstractTradeSearchTask that = (AbstractTradeSearchTask)o;
            return Objects.equals(this.source, that.source);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.source.method_44023());
    }

    @Override
    public String getLogName() {
        return "\u4ea4\u6613\u67e5\u627e";
    }

    public static enum FindState {
        SEARCH,
        SORT,
        FEEDBACK,
        END;

    }

    public static interface Result
    extends Comparator<Result>,
    Supplier<class_2561> {
        public class_2338 villagerPos();
    }
}

