/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.rule;

import carpet.CarpetServer;
import carpet.api.settings.CarpetRule;
import carpet.patches.EntityPlayerMPFake;
import carpet.utils.Translations;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1281;
import net.minecraft.class_1282;
import net.minecraft.class_1283;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_8103;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.mixin.accessor.DamageTrackerAccessor;
import org.carpetorgaddition.rule.value.FakePlayerKeepInventoryCondition;
import org.carpetorgaddition.wheel.TextBuilder;
import org.jetbrains.annotations.Nullable;

public class RuleUtils {
    public static final double MAX_DISTANCE = 256.0;
    public static final int MAX_BEACON_RANGE = 1024;
    public static final int MIN_CRAFT_COUNT = 1;
    public static final Supplier<Boolean> hopperCountersUnlimitedSpeed = RuleUtils.getCarpetRule("hopperCountersUnlimitedSpeed");
    public static final Supplier<Boolean> hopperNoItemCost = RuleUtils.getCarpetRule("hopperNoItemCost");

    public static boolean canUpdateSuppression(@Nullable String blockName) {
        if ("false".equalsIgnoreCase(CarpetOrgAdditionSettings.CCEUpdateSuppression.get())) {
            return false;
        }
        if (blockName == null) {
            return false;
        }
        if ("true".equalsIgnoreCase(CarpetOrgAdditionSettings.CCEUpdateSuppression.get())) {
            return "\u66f4\u65b0\u6291\u5236\u5668".equals(blockName) || "updateSuppression".equalsIgnoreCase(blockName);
        }
        return Objects.equals(CarpetOrgAdditionSettings.CCEUpdateSuppression.get().toLowerCase(), blockName.toLowerCase());
    }

    public static boolean isDefaultDistance() {
        return CarpetOrgAdditionSettings.maxBlockPlaceDistance.get() == -1.0;
    }

    public static double getPlayerMaxInteractionDistance() {
        double distance = CarpetOrgAdditionSettings.maxBlockPlaceDistance.get();
        if (distance < 0.0) {
            return 6.0;
        }
        return Math.min(distance, 256.0);
    }

    public static <T> T shulkerBoxStackableWrap(Supplier<T> supplier) {
        boolean changed = CarpetOrgAdditionSettings.shulkerBoxStackCountChanged.get();
        try {
            CarpetOrgAdditionSettings.shulkerBoxStackCountChanged.set(false);
            T t = supplier.get();
            return t;
        }
        finally {
            CarpetOrgAdditionSettings.shulkerBoxStackCountChanged.set(changed);
        }
    }

    private static Supplier<Boolean> getCarpetRule(String rule) {
        if (CarpetOrgAddition.CARPET_TIS_ADDITION) {
            CarpetRule carpetRule = CarpetServer.settingsManager.getCarpetRule(rule);
            if (carpetRule == null) {
                return () -> false;
            }
            return () -> {
                Boolean value;
                Object patt0$temp = carpetRule.value();
                return patt0$temp instanceof Boolean ? (value = (Boolean)patt0$temp) : Boolean.valueOf(false);
            };
        }
        return () -> false;
    }

    public static class_2561 simpleTranslationName(CarpetRule<?> rule) {
        String key = String.format("%s.rule.%s.name", rule.settingsManager().identifier(), rule.name());
        TextBuilder builder = TextBuilder.of(key, new Object[0]);
        if (Translations.hasTranslation((String)key)) {
            return builder.setHover(rule.name(), new Object[0]).build();
        }
        return TextBuilder.create(rule.name());
    }

    public static List<class_2561> ruleExtraInfo(CarpetRule<?> rule) {
        String key = String.format("%s.rule.%s.extra.", rule.settingsManager().identifier(), rule.name());
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (Translations.hasTranslation((String)(key + i))) {
            list.add(Translations.tr((String)(key + i)));
            ++i;
        }
        return list.stream().map(x$0 -> TextBuilder.of(x$0, new Object[0])).map(builder -> builder.setColor(class_124.field_1080)).map(TextBuilder::build).toList();
    }

    public static boolean shouldKeepInventory(EntityPlayerMPFake fakePlayer) {
        return switch (CarpetOrgAdditionSettings.fakePlayerKeepInventoryCondition.get()) {
            default -> throw new MatchException(null, null);
            case FakePlayerKeepInventoryCondition.UNCONDITIONAL -> true;
            case FakePlayerKeepInventoryCondition.KILLED_BY_PLAYER_OR_THE_VOID -> {
                class_1283 damageTracker = fakePlayer.method_6066();
                List<class_1281> records = ((DamageTrackerAccessor)damageTracker).getRecentDamage();
                class_1282 directCause = records.getLast().comp_1535();
                if (directCause.method_5526() instanceof class_3222) {
                    yield true;
                }
                if (directCause.method_5529() instanceof class_3222) {
                    yield true;
                }
                if (fakePlayer.method_6124() instanceof class_3222) {
                    yield true;
                }
                yield directCause.method_48789(class_8103.field_42242);
            }
        };
    }
}

