/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.command;

import carpet.patches.EntityPlayerMPFake;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_7157;
import net.minecraft.class_747;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.command.AbstractServerCommand;
import org.carpetorgaddition.exception.CommandExecuteIOException;
import org.carpetorgaddition.periodic.ServerComponentCoordinator;
import org.carpetorgaddition.periodic.express.Express;
import org.carpetorgaddition.periodic.express.ExpressManager;
import org.carpetorgaddition.util.CommandUtils;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.util.GenericUtils;
import org.carpetorgaddition.util.IOUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.wheel.TextBuilder;
import org.carpetorgaddition.wheel.page.PageManager;
import org.carpetorgaddition.wheel.page.PagedCollection;
import org.carpetorgaddition.wheel.permission.PermissionLevel;
import org.carpetorgaddition.wheel.permission.PermissionManager;
import org.carpetorgaddition.wheel.provider.CommandProvider;
import org.carpetorgaddition.wheel.provider.TextProvider;
import org.carpetorgaddition.wheel.screen.ShipExpressScreenHandler;

public class MailCommand
extends AbstractServerCommand {
    public final Predicate<class_2168> intercept = PermissionManager.register("mail.intercept", PermissionLevel.OPS);

    public MailCommand(CommandDispatcher<class_2168> dispatcher, class_7157 access) {
        super(dispatcher, access);
    }

    @Override
    public void register(String name) {
        this.dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).requires(CommandUtils.canUseCommand(CarpetOrgAdditionSettings.commandMail))).then(class_2170.method_9247((String)"ship").then(class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).executes(this::ship)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"receive").executes(this::receiveAll)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"id", (ArgumentType)IntegerArgumentType.integer((int)1)).suggests(this.receiveSuggests(true)).executes(context -> this.receive((CommandContext<class_2168>)context, false))).then(class_2170.method_9244((String)"force", (ArgumentType)BoolArgumentType.bool()).executes(context -> this.receive((CommandContext<class_2168>)context, BoolArgumentType.getBool((CommandContext)context, (String)"force"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"cancel").executes(this::cancelAll)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"id", (ArgumentType)IntegerArgumentType.integer((int)1)).suggests(this.receiveSuggests(false)).executes(context -> this.cancel((CommandContext<class_2168>)context, false))).then(class_2170.method_9244((String)"force", (ArgumentType)BoolArgumentType.bool()).executes(context -> this.cancel((CommandContext<class_2168>)context, BoolArgumentType.getBool((CommandContext)context, (String)"force"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"intercept").requires(this.intercept)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"id", (ArgumentType)IntegerArgumentType.integer((int)1)).suggests(this.interceptSuggests()).executes(context -> this.intercept((CommandContext<class_2168>)context, false))).then(class_2170.method_9244((String)"force", (ArgumentType)BoolArgumentType.bool()).executes(context -> this.intercept((CommandContext<class_2168>)context, BoolArgumentType.getBool((CommandContext)context, (String)"force"))))))).then(class_2170.method_9247((String)"list").executes(this::list))).then(class_2170.method_9247((String)"multiple").then(class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).executes(this::shipMultipleExpress))));
    }

    private SuggestionProvider<class_2168> receiveSuggests(boolean recipient) {
        return (context, builder) -> {
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            if (player == null) {
                return class_2172.method_9265(List.of(), (SuggestionsBuilder)builder);
            }
            ExpressManager manager = ServerComponentCoordinator.getCoordinator((CommandContext<class_2168>)context).getExpressManager();
            List<String> list = manager.stream().filter(express -> recipient ? express.isRecipient(player) : express.isSender(player)).map(express -> Integer.toString(express.getId())).toList();
            return class_2172.method_9265(list, (SuggestionsBuilder)builder);
        };
    }

    private SuggestionProvider<class_2168> interceptSuggests() {
        return (context, builder) -> {
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            if (player == null) {
                return class_2172.method_9265(List.of(), (SuggestionsBuilder)builder);
            }
            ExpressManager manager = ServerComponentCoordinator.getCoordinator((CommandContext<class_2168>)context).getExpressManager();
            List<String> list = manager.stream().map(express -> Integer.toString(express.getId())).toList();
            return class_2172.method_9265(list, (SuggestionsBuilder)builder);
        };
    }

    private int ship(CommandContext<class_2168> context) throws CommandSyntaxException {
        Express express;
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        class_3222 sourcePlayer = CommandUtils.getSourcePlayer(context);
        GameProfile gameProfile = CommandUtils.getGameProfile(context, "player");
        Optional<class_3222> optional = GenericUtils.getPlayer(server, gameProfile);
        ExpressManager manager = ServerComponentCoordinator.getCoordinator(context).getExpressManager();
        if (optional.isEmpty()) {
            express = new Express(server, sourcePlayer, gameProfile, manager.generateNumber());
        } else {
            class_3222 targetPlayer = optional.get();
            this.checkPlayer(sourcePlayer, targetPlayer);
            express = new Express(server, sourcePlayer, targetPlayer, manager.generateNumber());
        }
        try {
            manager.put(express);
        }
        catch (IOException e) {
            throw CommandExecuteIOException.of(e);
        }
        return 1;
    }

    private int shipMultipleExpress(CommandContext<class_2168> context) throws CommandSyntaxException {
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        class_3222 sourcePlayer = CommandUtils.getSourcePlayer(context);
        GameProfile gameProfile = CommandUtils.getGameProfile(context, "player");
        Optional<class_3222> optional = GenericUtils.getPlayer(server, gameProfile);
        if (optional.isPresent()) {
            this.checkPlayer(sourcePlayer, optional.get());
        }
        class_1277 inventory = new class_1277(27);
        class_747 screen = new class_747((i, inv, player) -> new ShipExpressScreenHandler(i, inv, sourcePlayer, gameProfile, (class_1263)inventory), TextBuilder.translate("carpet.commands.mail.multiple.gui", new Object[0]));
        sourcePlayer.method_17355((class_3908)screen);
        return 1;
    }

    private int receive(CommandContext<class_2168> context, boolean force) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        Express express = this.getExpress(context);
        int dataVersion = express.getNbtDataVersion();
        if (force || dataVersion == -1 || dataVersion == GenericUtils.CURRENT_DATA_VERSION) {
            if (express.isRecipient(player)) {
                try {
                    express.receive();
                }
                catch (IOException e) {
                    throw CommandExecuteIOException.of(e);
                }
                return 1;
            }
            throw CommandUtils.createException("carpet.commands.mail.receive.recipient", new Object[0]);
        }
        class_2561 action = TextBuilder.translate("carpet.commands.mail.action.receive", new Object[0]);
        class_2561 button = TextProvider.clickRun(CommandProvider.receiveExpress(express.getId(), true));
        class_2561 message = this.differentVersions(action, dataVersion, button);
        MessageUtils.sendMessage((class_2168)context.getSource(), message);
        return 0;
    }

    private int receiveAll(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        try {
            return ServerComponentCoordinator.getCoordinator(context).getExpressManager().receiveAll(player);
        }
        catch (IOException e) {
            throw CommandExecuteIOException.of(e);
        }
    }

    private int cancel(CommandContext<class_2168> context, boolean force) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        Express express = this.getExpress(context);
        int dataVersion = express.getNbtDataVersion();
        if (force || dataVersion == -1 || dataVersion == GenericUtils.CURRENT_DATA_VERSION) {
            if (express.isSender(player)) {
                try {
                    express.cancel();
                }
                catch (IOException e) {
                    throw CommandExecuteIOException.of(e);
                }
                return 1;
            }
            throw CommandUtils.createException("carpet.commands.mail.cancel.recipient", new Object[0]);
        }
        class_2561 action = TextBuilder.translate("carpet.commands.mail.action.cancel", new Object[0]);
        class_2561 button = TextProvider.clickRun(CommandProvider.cancelExpress(express.getId(), true));
        class_2561 message = this.differentVersions(action, dataVersion, button);
        MessageUtils.sendMessage((class_2168)context.getSource(), message);
        return 0;
    }

    private int cancelAll(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        try {
            return ServerComponentCoordinator.getCoordinator(context).getExpressManager().cancelAll(player);
        }
        catch (IOException e) {
            throw CommandExecuteIOException.of(e);
        }
    }

    private int intercept(CommandContext<class_2168> context, boolean force) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        Express express = this.getExpress(context);
        int dataVersion = express.getNbtDataVersion();
        if (force || dataVersion == -1 || dataVersion == GenericUtils.CURRENT_DATA_VERSION) {
            try {
                express.intercept(player);
            }
            catch (IOException e) {
                IOUtils.loggerError(e);
            }
            return express.getId();
        }
        class_2561 action = TextBuilder.translate("carpet.commands.mail.action.intercept", new Object[0]);
        class_2561 button = TextProvider.clickRun(CommandProvider.interceptExpress(express.getId(), true));
        class_2561 message = this.differentVersions(action, dataVersion, button);
        MessageUtils.sendMessage((class_2168)context.getSource(), message);
        return 0;
    }

    private class_2561 differentVersions(class_2561 action, int dataVersion, class_2561 button) {
        TextBuilder builder = dataVersion > GenericUtils.CURRENT_DATA_VERSION ? TextBuilder.of("carpet.commands.mail.action.version.new", new Object[0]) : TextBuilder.of("carpet.commands.mail.action.version.old", new Object[0]);
        builder.setHover(TextBuilder.joinList(List.of(TextBuilder.translate("carpet.commands.mail.action.version.expect", GenericUtils.CURRENT_DATA_VERSION), TextBuilder.translate("carpet.commands.mail.action.version.actua", dataVersion))));
        return TextBuilder.translate("carpet.commands.mail.action.version.fail", action, builder.build(), button, action);
    }

    private int list(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        ExpressManager manager = ServerComponentCoordinator.getCoordinator(context).getExpressManager();
        class_2168 source = (class_2168)context.getSource();
        List<Express> list = manager.stream().toList();
        if (list.isEmpty()) {
            MessageUtils.sendMessage(context, "carpet.commands.mail.list.empty", new Object[0]);
            return 0;
        }
        PageManager pageManager = FetcherUtils.getPageManager(source.method_9211());
        PagedCollection collection = pageManager.newPagedCollection(source);
        ArrayList<Supplier<class_2561>> messages = new ArrayList<Supplier<class_2561>>();
        for (Express express : list) {
            messages.add(() -> this.line(player, express));
        }
        collection.addContent(messages);
        MessageUtils.sendEmptyMessage(source);
        collection.print();
        return list.size();
    }

    private class_2561 line(class_3222 player, Express express) {
        TextBuilder builder;
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        if (express.isRecipient(player)) {
            builder = new TextBuilder("[R]");
            builder.setCommand(CommandProvider.receiveExpress(express.getId(), false));
            builder.setColor(class_124.field_1075);
            list.add(TextBuilder.translate("carpet.commands.mail.list.receive", new Object[0]));
            list.add(TextBuilder.empty());
        } else if (express.isSender(player)) {
            builder = new TextBuilder("[C]");
            builder.setCommand(CommandProvider.cancelExpress(express.getId(), false));
            builder.setColor(class_124.field_1075);
            list.add(TextBuilder.translate("carpet.commands.mail.list.sending", new Object[0]));
            list.add(TextBuilder.empty());
        } else if (this.intercept.test(player.method_5671())) {
            builder = new TextBuilder("[I]");
            builder.setCommand(CommandProvider.interceptExpress(express.getId(), false));
            builder.setColor(class_124.field_1075);
            list.add(TextBuilder.translate("carpet.commands.mail.list.intercept", new Object[0]));
            list.add(TextBuilder.empty());
        } else {
            builder = new TextBuilder("[?]");
        }
        list.add(TextBuilder.translate("carpet.commands.mail.list.id", express.getId()));
        list.add(TextBuilder.translate("carpet.commands.mail.list.sender", express.getSender()));
        list.add(TextBuilder.translate("carpet.commands.mail.list.recipient", express.getRecipient()));
        list.add(TextBuilder.translate("carpet.commands.mail.list.item", TextBuilder.translate(express.getExpress().method_7922(), new Object[0]), express.getExpress().method_7947()));
        list.add(TextBuilder.translate("carpet.commands.mail.list.time", express.getTime()));
        builder.setHover(TextBuilder.joinList(list));
        return TextBuilder.translate("carpet.commands.mail.list.each", express.getId(), express.getExpress().method_7954(), express.getSender(), express.getRecipient(), builder.build());
    }

    private Express getExpress(CommandContext<class_2168> context) throws CommandSyntaxException {
        int id;
        ExpressManager manager = ServerComponentCoordinator.getCoordinator(context).getExpressManager();
        Optional<Express> optional = manager.binarySearch(id = IntegerArgumentType.getInteger(context, (String)"id"));
        if (optional.isEmpty()) {
            throw CommandUtils.createException("carpet.commands.mail.receive.non_existent", id);
        }
        return optional.get();
    }

    private void checkPlayer(class_3222 sourcePlayer, class_3222 targetPlayer) throws CommandSyntaxException {
        if (CarpetOrgAddition.isDebugDevelopment()) {
            return;
        }
        if (sourcePlayer == targetPlayer || targetPlayer instanceof EntityPlayerMPFake) {
            throw CommandUtils.createException("carpet.commands.mail.check_player", new Object[0]);
        }
    }

    @Override
    public String getDefaultName() {
        return "mail";
    }
}

