/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.fakeplayer.action;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1792;
import net.minecraft.class_243;
import org.carpetorgaddition.periodic.fakeplayer.action.AbstractPlayerAction;
import org.carpetorgaddition.periodic.fakeplayer.action.BedrockAction;
import org.carpetorgaddition.periodic.fakeplayer.action.CraftingTableCraftAction;
import org.carpetorgaddition.periodic.fakeplayer.action.EmptyTheContainerAction;
import org.carpetorgaddition.periodic.fakeplayer.action.FillTheContainerAction;
import org.carpetorgaddition.periodic.fakeplayer.action.FishingAction;
import org.carpetorgaddition.periodic.fakeplayer.action.InventoryCraftAction;
import org.carpetorgaddition.periodic.fakeplayer.action.ItemCategorizeAction;
import org.carpetorgaddition.periodic.fakeplayer.action.PlantAction;
import org.carpetorgaddition.periodic.fakeplayer.action.RenameAction;
import org.carpetorgaddition.periodic.fakeplayer.action.StonecuttingAction;
import org.carpetorgaddition.periodic.fakeplayer.action.StopAction;
import org.carpetorgaddition.periodic.fakeplayer.action.TradeAction;
import org.carpetorgaddition.util.JsonUtils;
import org.carpetorgaddition.wheel.ItemStackPredicate;

public enum ActionSerializeType {
    STOP(json -> new StopAction(null)),
    CATEGORIZE(json -> {
        String item = json.get("item").getAsString();
        ItemStackPredicate predicate = ItemStackPredicate.parse(item);
        JsonArray thisVecArray = json.get("thisVec").getAsJsonArray();
        class_243 thisVec = new class_243(thisVecArray.get(0).getAsDouble(), thisVecArray.get(1).getAsDouble(), thisVecArray.get(2).getAsDouble());
        JsonArray otherVecArray = json.get("otherVec").getAsJsonArray();
        class_243 otherVec = new class_243(otherVecArray.get(0).getAsDouble(), otherVecArray.get(1).getAsDouble(), otherVecArray.get(2).getAsDouble());
        return new ItemCategorizeAction(null, predicate, thisVec, otherVec);
    }),
    EMPTY_THE_CONTAINER(json -> {
        String item = json.get("item").getAsString();
        ItemStackPredicate predicate = ItemStackPredicate.parse(item);
        return new EmptyTheContainerAction(null, predicate);
    }),
    FILL_THE_CONTAINER(json -> {
        boolean dropOther = !json.has("dropOther") || json.get("dropOther").getAsBoolean();
        String item = json.get("item").getAsString();
        ItemStackPredicate predicate = ItemStackPredicate.parse(item);
        boolean moreContainer = json.has("moreContainer") && json.get("moreContainer").getAsBoolean();
        return new FillTheContainerAction(null, predicate, dropOther, moreContainer);
    }),
    CRAFTING_TABLE_CRAFT(json -> {
        ItemStackPredicate[] predicates = new ItemStackPredicate[9];
        for (int i = 0; i < predicates.length; ++i) {
            String item = json.get(String.valueOf(i)).getAsString();
            predicates[i] = ItemStackPredicate.parse(item);
        }
        return new CraftingTableCraftAction(null, predicates);
    }),
    INVENTORY_CRAFT(json -> {
        ItemStackPredicate[] predicates = new ItemStackPredicate[4];
        for (int i = 0; i < predicates.length; ++i) {
            String item = json.get(String.valueOf(i)).getAsString();
            predicates[i] = ItemStackPredicate.parse(item);
        }
        return new InventoryCraftAction(null, predicates);
    }),
    RENAME(json -> {
        class_1792 item = ItemStackPredicate.stringAsItem(json.get("item").getAsString());
        String newName = json.get("new_name").getAsString();
        return new RenameAction(null, item, newName);
    }),
    STONECUTTING(json -> {
        class_1792 item = ItemStackPredicate.stringAsItem(json.get("item").getAsString());
        int index = json.get("button").getAsInt();
        return new StonecuttingAction(null, item, index);
    }),
    TRADE(json -> {
        int index = json.get("index").getAsInt();
        boolean voidTrade = json.get("void_trade").getAsBoolean();
        return new TradeAction(null, index, voidTrade);
    }),
    FISHING(json -> new FishingAction(null)),
    PLANT(json -> new PlantAction(null)),
    BEDROCK(json -> {
        String regionType = Optional.ofNullable(json.get("region_type")).map(JsonElement::getAsString).orElse("cuboid");
        boolean ai = Optional.ofNullable(json.get("ai")).map(JsonElement::getAsBoolean).orElse(false);
        boolean timedMaterialRecycling = Optional.ofNullable(json.get("timed_material_recycling")).map(JsonElement::getAsBoolean).orElse(false);
        switch (regionType) {
            case "cuboid": {
                JsonArray from = json.getAsJsonArray("from");
                JsonArray to = json.getAsJsonArray("to");
                return new BedrockAction(null, JsonUtils.toBlockPos(from), JsonUtils.toBlockPos(to), ai, timedMaterialRecycling);
            }
            case "cylinder": {
                JsonArray center = json.getAsJsonArray("center");
                int radius = json.get("radius").getAsInt();
                int height = json.get("height").getAsInt();
                return new BedrockAction(null, JsonUtils.toBlockPos(center), radius, height, ai, timedMaterialRecycling);
            }
        }
        return new StopAction(null);
    }),
    GOTO(json -> new StopAction(null));

    private final String serializedName;
    private final Function<JsonObject, AbstractPlayerAction> deserializer;

    private ActionSerializeType(Function<JsonObject, AbstractPlayerAction> deserializer) {
        this.deserializer = deserializer;
        this.serializedName = this.name().toLowerCase(Locale.ROOT);
    }

    public AbstractPlayerAction deserialize(JsonObject json) {
        return this.deserializer.apply(json);
    }

    public String getSerializedName() {
        return this.serializedName;
    }
}

