/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.fakeplayer.action;

import carpet.patches.EntityPlayerMPFake;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2183;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import org.carpetorgaddition.exception.InfiniteLoopException;
import org.carpetorgaddition.periodic.fakeplayer.FakePlayerUtils;
import org.carpetorgaddition.periodic.fakeplayer.action.AbstractPlayerAction;
import org.carpetorgaddition.periodic.fakeplayer.action.ActionSerializeType;
import org.carpetorgaddition.util.InventoryUtils;
import org.carpetorgaddition.wheel.ItemStackPredicate;
import org.carpetorgaddition.wheel.TextBuilder;

public class ItemCategorizeAction
extends AbstractPlayerAction {
    public static final String ITEM = "item";
    public static final String THIS_VEC = "thisVec";
    public static final String OTHER_VEC = "otherVec";
    private final ItemStackPredicate predicate;
    private final class_243 thisVec;
    private final class_243 otherVec;

    public ItemCategorizeAction(EntityPlayerMPFake fakePlayer, ItemStackPredicate predicate, class_243 thisVec, class_243 otherVec) {
        super(fakePlayer);
        this.predicate = predicate;
        this.thisVec = thisVec;
        this.otherVec = otherVec;
    }

    @Override
    protected void tick() {
        class_1661 inventory = this.getFakePlayer().method_31548();
        for (int index = 0; index < inventory.method_5439(); ++index) {
            class_1799 itemStack = inventory.method_5438(index);
            if (itemStack.method_7960()) continue;
            if (this.predicate.test(itemStack)) {
                this.getFakePlayer().method_5702(class_2183.class_2184.field_9851, this.thisVec);
            } else if (InventoryUtils.isShulkerBoxItem(itemStack)) {
                itemStack = this.pickItemFromShulkerBox(inventory, index);
            } else {
                this.getFakePlayer().method_5702(class_2183.class_2184.field_9851, this.otherVec);
            }
            FakePlayerUtils.dropItem(this.getFakePlayer(), itemStack);
        }
    }

    private class_1799 pickItemFromShulkerBox(class_1661 inventory, int index) {
        class_1799 itemStack;
        int loopCount = 0;
        while (true) {
            if (++loopCount > 100) {
                throw new InfiniteLoopException();
            }
            itemStack = inventory.method_5438(index);
            if (InventoryUtils.isEmptyShulkerBox(itemStack)) {
                this.getFakePlayer().method_5702(class_2183.class_2184.field_9851, this.otherVec);
                break;
            }
            if ((itemStack = InventoryUtils.pickItemFromShulkerBox(itemStack, stack -> !stack.method_7960())).method_7960()) {
                itemStack = inventory.method_5438(index);
                this.getFakePlayer().method_5702(class_2183.class_2184.field_9851, this.otherVec);
                break;
            }
            this.getFakePlayer().method_5702(class_2183.class_2184.field_9851, this.predicate.test(itemStack) ? this.thisVec : this.otherVec);
            FakePlayerUtils.dropItem(this.getFakePlayer(), itemStack);
        }
        return itemStack;
    }

    @Override
    public ArrayList<class_2561> info() {
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        class_2561 itemName = this.predicate.toText();
        class_2561 fakeName = this.getFakePlayer().method_5476();
        list.add(TextBuilder.translate("carpet.commands.playerAction.info.sorting.predicate", fakeName, itemName));
        class_2561 thisPos = this.posText(this.thisVec.method_10216(), this.thisVec.method_10214(), this.thisVec.method_10215());
        class_2561 otherPos = this.posText(this.otherVec.method_10216(), this.otherVec.method_10214(), this.otherVec.method_10215());
        list.add(TextBuilder.translate("carpet.commands.playerAction.info.sorting.this", itemName, thisPos));
        list.add(TextBuilder.translate("carpet.commands.playerAction.info.sorting.other", otherPos));
        return list;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty(ITEM, this.predicate.toString());
        JsonArray thisVecJson = new JsonArray();
        thisVecJson.add((Number)this.thisVec.field_1352);
        thisVecJson.add((Number)this.thisVec.field_1351);
        thisVecJson.add((Number)this.thisVec.field_1350);
        json.add(THIS_VEC, (JsonElement)thisVecJson);
        JsonArray otherVecJson = new JsonArray();
        otherVecJson.add((Number)this.otherVec.field_1352);
        otherVecJson.add((Number)this.otherVec.field_1351);
        otherVecJson.add((Number)this.otherVec.field_1350);
        json.add(OTHER_VEC, (JsonElement)otherVecJson);
        return json;
    }

    private class_2561 posText(double x, double y, double z) {
        return TextBuilder.create(String.format("%.2f %.2f %.2f", x, y, z));
    }

    @Override
    public class_2561 getDisplayName() {
        return TextBuilder.translate("carpet.commands.playerAction.action.sorting", new Object[0]);
    }

    @Override
    public ActionSerializeType getActionSerializeType() {
        return ActionSerializeType.CATEGORIZE;
    }
}

