/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.task.schedule;

import carpet.patches.EntityPlayerMPFake;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.periodic.task.schedule.PlayerScheduleTask;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.wheel.TextBuilder;
import org.carpetorgaddition.wheel.provider.TextProvider;
import org.jetbrains.annotations.NotNull;

public class DelayedLogoutTask
extends PlayerScheduleTask {
    private final MinecraftServer server;
    private final EntityPlayerMPFake fakePlayer;
    private long delayed;

    public DelayedLogoutTask(MinecraftServer server, EntityPlayerMPFake fakePlayer, long delayed) {
        this.server = server;
        this.fakePlayer = fakePlayer;
        this.delayed = delayed;
    }

    @Override
    public void tick() {
        if (this.delayed == 0L) {
            if (this.fakePlayer.method_31481()) {
                class_3222 player = this.server.method_3760().method_14602(this.fakePlayer.method_5667());
                if (player instanceof EntityPlayerMPFake) {
                    player.method_5768();
                }
            } else {
                this.fakePlayer.method_5768();
            }
            this.delayed = -1L;
        } else {
            --this.delayed;
        }
    }

    public void setDelayed(long delayed) {
        this.delayed = delayed;
    }

    public EntityPlayerMPFake getFakePlayer() {
        return this.fakePlayer;
    }

    @Override
    public String getPlayerName() {
        return FetcherUtils.getPlayerName((class_1657)this.fakePlayer);
    }

    @Override
    public void onCancel(CommandContext<class_2168> context) {
        this.markRemove();
        MessageUtils.sendMessage(context, "carpet.commands.playerManager.schedule.logout.cancel", this.fakePlayer.method_5476(), this.getDisplayTime());
    }

    @NotNull
    private class_2561 getDisplayTime() {
        TextBuilder builder = new TextBuilder(TextProvider.tickToTime(this.delayed));
        builder.setHover(TextProvider.tickToRealTime(this.delayed));
        return builder.build();
    }

    @Override
    public void sendEachMessage(class_2168 source) {
        MessageUtils.sendMessage(source, "carpet.commands.playerManager.schedule.logout", this.fakePlayer.method_5476(), this.getDisplayTime());
    }

    @Override
    public boolean stopped() {
        return this.delayed < 0L;
    }

    @Override
    public String getLogName() {
        return this.getPlayerName() + "\u5ef6\u8fdf\u4e0b\u7ebf";
    }
}

