/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.util;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.util.GenericUtils;
import org.carpetorgaddition.wheel.TextBuilder;

public class MessageUtils {
    private MessageUtils() {
    }

    @Deprecated(forRemoval=true)
    public static void broadcastMessage(class_3222 player, class_2561 message) {
        MinecraftServer server = FetcherUtils.getServer(player);
        class_3324 playerManager = server.method_3760();
        MessageUtils.broadcastMessage(playerManager, message);
    }

    @Deprecated(forRemoval=true)
    public static void broadcastMessage(class_2168 source, class_2561 message) {
        class_3324 playerManager = source.method_9211().method_3760();
        MessageUtils.broadcastMessage(playerManager, message);
    }

    public static void broadcastMessage(MinecraftServer server, class_2561 message) {
        MessageUtils.broadcastMessage(server.method_3760(), message);
    }

    public static void broadcastMessage(MinecraftServer server, String key, Object ... args) {
        MessageUtils.broadcastMessage(server.method_3760(), TextBuilder.translate(key, args));
    }

    public static void broadcastMessage(class_3324 playerManager, class_2561 message) {
        playerManager.method_43514(message, false);
    }

    public static void broadcastErrorMessage(MinecraftServer server, Throwable e, String key, Object ... obj) {
        String error = GenericUtils.getExceptionString(e);
        TextBuilder builder = TextBuilder.of(key, obj);
        builder.setStringHover(error);
        builder.setColor(class_124.field_1061);
        MessageUtils.broadcastMessage(server, builder.build());
    }

    public static void sendMessage(class_3222 player, class_2561 message) {
        player.method_43496(message);
        MessageUtils.writeLog(FetcherUtils.getPlayerName((class_1657)player), message.getString());
    }

    public static void sendMessage(class_2168 source, class_2561 message) {
        source.method_45068(message);
        MessageUtils.writeLog(source.method_9214(), message.getString());
    }

    public static void sendMessage(CommandContext<class_2168> context, String key, Object ... obj) {
        MessageUtils.sendMessage((class_2168)context.getSource(), key, obj);
    }

    public static void sendMessage(class_2168 source, String key, Object ... obj) {
        MessageUtils.sendMessage(source, TextBuilder.translate(key, obj));
    }

    public static void sendMessage(class_3222 player, String key, Object ... obj) {
        MessageUtils.sendMessage(player, TextBuilder.translate(key, obj));
    }

    private static void writeLog(String name, String message) {
        CarpetOrgAddition.LOGGER.info("[{} <- {}] {}", new Object[]{name, CarpetOrgAddition.MOD_NAME, message});
    }

    public static void sendErrorMessage(CommandContext<class_2168> context, String key, Object ... obj) {
        MessageUtils.sendErrorMessage((class_2168)context.getSource(), key, obj);
    }

    public static void sendErrorMessage(class_2168 source, String key, Object ... obj) {
        TextBuilder builder = TextBuilder.of(key, obj);
        builder.setColor(class_124.field_1061);
        MessageUtils.sendMessage(source, builder.build());
    }

    public static void sendErrorMessage(class_2168 source, class_2561 message) {
        TextBuilder builder = new TextBuilder(message);
        builder.setColor(class_124.field_1061);
        MessageUtils.sendMessage(source, builder.build());
    }

    public static void sendErrorMessage(class_2168 source, Throwable e, String key, Object ... obj) {
        String error = GenericUtils.getExceptionString(e);
        TextBuilder builder = TextBuilder.of(key, obj);
        builder.setStringHover(error);
        builder.setColor(class_124.field_1061);
        MessageUtils.sendMessage(source, builder.build());
    }

    public static void sendVanillaErrorMessage(class_2168 source, CommandSyntaxException e) {
        source.method_9213(TextBuilder.create(e.getRawMessage()));
    }

    public static void sendMessageToHud(class_1657 player, class_2561 message) {
        player.method_7353(message, true);
    }

    public static void sendListMessage(class_2168 source, ArrayList<? extends class_2561> list) {
        for (class_2561 class_25612 : list) {
            MessageUtils.sendMessage(source, class_25612);
        }
    }

    public static void sendEmptyMessage(class_3222 player) {
        MessageUtils.sendMessage(player, (class_2561)class_2561.method_43473());
    }

    public static void sendEmptyMessage(class_2168 source) {
        MessageUtils.sendEmptyMessage(source.method_44023());
    }

    public static void sendEmptyMessage(CommandContext<class_2168> context) {
        MessageUtils.sendEmptyMessage((class_2168)context.getSource());
    }
}

