/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.fakeplayer;

import carpet.patches.EntityPlayerMPFake;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Supplier;
import net.minecraft.class_10;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.carpetorgaddition.periodic.fakeplayer.FakePlayerPathfinder;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.util.MathUtils;
import org.jetbrains.annotations.NotNull;

public class AStarPathfinder
implements FakePlayerPathfinder {
    private final Supplier<EntityPlayerMPFake> supplier;
    private final Supplier<Optional<class_2338>> target;
    private final List<class_243> nodes = new ArrayList<class_243>();

    public AStarPathfinder(Supplier<EntityPlayerMPFake> supplier, Supplier<Optional<class_2338>> target) {
        this.supplier = supplier;
        this.target = target;
    }

    @Override
    public void tick() {
        this.pathfinding();
    }

    @Override
    public double length() {
        return this.nodes.size();
    }

    @Override
    public void pathfinding() {
        EntityPlayerMPFake fakePlayer = this.getFakePlayer();
        Optional<class_2338> optional = this.target.get();
        if (optional.isEmpty()) {
            return;
        }
        class_2338 startPos = fakePlayer.method_24515();
        class_2338 targetPos = optional.get();
        TreeSet<SearchNode> opens = new TreeSet<SearchNode>();
        HashSet<class_2338> clones = new HashSet<class_2338>();
        HashMap<class_2338, SearchNode> openCaches = new HashMap<class_2338, SearchNode>();
        SearchNode node = new SearchNode(null, startPos, 0, this.estimatedCost(startPos, targetPos));
        opens.add(node);
        openCaches.put(startPos, node);
        this.nodes.clear();
        this.pathfinding(opens, openCaches, clones, targetPos);
    }

    private void pathfinding(TreeSet<SearchNode> opens, HashMap<class_2338, SearchNode> openCaches, HashSet<class_2338> clones, class_2338 target) {
        while (!opens.isEmpty()) {
            SearchNode first = (SearchNode)opens.getFirst();
            if (first.gCost > 100000) {
                return;
            }
            if (first.blockPos.equals((Object)target)) {
                this.fillNodes(first);
                return;
            }
            opens.remove(first);
            openCaches.remove(first.blockPos);
            clones.add(first.blockPos);
            class_3218 world = FetcherUtils.getWorld((class_3222)this.getFakePlayer());
            this.addSearchNode((class_1937)world, first, target, opens, openCaches, clones);
        }
        return;
    }

    private void addSearchNode(class_1937 world, SearchNode current, class_2338 target, TreeSet<SearchNode> opens, HashMap<class_2338, SearchNode> openCaches, HashSet<class_2338> clones) {
        class_2338 center = current.blockPos;
        for (class_2338 blockPos : this.around(center)) {
            if (clones.contains(blockPos)) continue;
            Relationship relationship = this.relationship(center, blockPos);
            SearchNode node = new SearchNode(current, blockPos, current.gCost + relationship.getCost(), this.estimatedCost(blockPos, target));
            if (!this.isValidBlockPos(world, blockPos)) continue;
            SearchNode existing = openCaches.get(blockPos);
            if (existing == null) {
                opens.add(node);
                openCaches.put(node.blockPos, node);
                continue;
            }
            if (node.gCost >= existing.gCost) continue;
            opens.remove(existing);
            opens.add(node);
            openCaches.put(node.blockPos, node);
        }
    }

    private boolean isValidBlockPos(class_1937 world, class_2338 blockPos) {
        if (world.method_8320(blockPos.method_10074()).method_26206((class_1922)world, blockPos, class_2350.field_11036)) {
            for (int i : List.of(Integer.valueOf(0), Integer.valueOf(1))) {
                class_2680 up = world.method_8320(blockPos.method_10086(i));
                if (up.method_26171(class_10.field_50)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private int estimatedCost(class_2338 startPos, class_2338 targetPos) {
        return MathUtils.calculateManhattanDistance(startPos, targetPos) * 10;
    }

    private List<class_2338> around(class_2338 blockPos) {
        ArrayList<class_2338> list = new ArrayList<class_2338>();
        for (int i : List.of(Integer.valueOf(-1), Integer.valueOf(0), Integer.valueOf(1))) {
            list.add(blockPos.method_10069(1, i, -1));
            list.add(blockPos.method_10069(1, i, 0));
            list.add(blockPos.method_10069(1, i, 1));
            list.add(blockPos.method_10069(0, i, 1));
            list.add(blockPos.method_10069(-1, i, 1));
            list.add(blockPos.method_10069(-1, i, 0));
            list.add(blockPos.method_10069(-1, i, -1));
            list.add(blockPos.method_10069(0, i, -1));
        }
        return list;
    }

    private Relationship relationship(class_2338 center, class_2338 around) {
        int distance = MathUtils.calculateHorizontalManhattanDistance(center, around);
        if (center.method_10264() > around.method_10264()) {
            if (distance == 1) {
                return Relationship.SIDE_DOWN;
            }
            return Relationship.DIAGONALLY_BELOW;
        }
        if (center.method_10264() < around.method_10264()) {
            if (distance == 1) {
                return Relationship.SIDE_TOP;
            }
            return Relationship.DIAGONALLY_ABOVE;
        }
        if (distance == 1) {
            return Relationship.ADJACENT;
        }
        return Relationship.DIAGONAL;
    }

    private void fillNodes(SearchNode end) {
        SearchNode node;
        while ((node = end.parent) != null) {
            end = node;
            this.nodes.add(node.blockPos.method_61082());
        }
    }

    @Override
    public class_243 getCurrentNode() {
        return this.nodes.getFirst();
    }

    @Override
    public boolean arrivedAtAnyNode() {
        return false;
    }

    @Override
    public boolean backToBeforeNode() {
        return false;
    }

    @Override
    public boolean isFinished() {
        return false;
    }

    @Override
    public List<class_243> getRenderNodes() {
        return this.nodes;
    }

    @Override
    public int getSyncEntityId() {
        return this.getFakePlayer().method_5628();
    }

    @Override
    public void pause(int time) {
    }

    @Override
    public void stop() {
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onStop() {
    }

    @Override
    public boolean isInvalid() {
        return false;
    }

    @Override
    public boolean isInaccessible() {
        return false;
    }

    private EntityPlayerMPFake getFakePlayer() {
        return this.supplier.get();
    }

    public static class SearchNode
    implements Comparable<SearchNode> {
        private final SearchNode parent;
        private final class_2338 blockPos;
        private final int gCost;
        private final int hCost;
        private final int fCost;

        public SearchNode(SearchNode parent, class_2338 blockPos, int gCost, int hCost) {
            this.parent = parent;
            this.blockPos = blockPos;
            this.gCost = gCost;
            this.hCost = hCost;
            this.fCost = gCost + hCost;
        }

        @Override
        public int compareTo(@NotNull SearchNode o) {
            int fCompare = Integer.compare(this.fCost, o.fCost);
            if (fCompare != 0) {
                return fCompare;
            }
            int gCompare = Integer.compare(this.gCost, o.gCost);
            if (gCompare != 0) {
                return gCompare;
            }
            return this.blockPos.method_10265((class_2382)o.blockPos);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SearchNode other = (SearchNode)obj;
                return this.blockPos.equals((Object)other.blockPos);
            }
            return false;
        }

        public int hashCode() {
            return this.blockPos.hashCode();
        }
    }

    public static enum Relationship {
        ADJACENT(10),
        DIAGONAL(12),
        SIDE_TOP(15),
        SIDE_DOWN(15),
        DIAGONALLY_ABOVE(20),
        DIAGONALLY_BELOW(20);

        private final int cost;

        private Relationship(int cost) {
            this.cost = cost;
        }

        public int getCost() {
            return this.cost;
        }
    }
}

