/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.fakeplayer;

import com.google.gson.JsonParseException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.periodic.fakeplayer.FakePlayerSerializer;
import org.carpetorgaddition.wheel.WorldFormat;

public class PlayerSerializationManager {
    public static final String PLAYER_DATA = "player_data";
    public static final String SCRIPT_ACTION = "script_action";
    private final WorldFormat worldFormat;
    private final HashSet<FakePlayerSerializer> serializers = new HashSet();
    private boolean initialize = false;

    public PlayerSerializationManager(MinecraftServer server) {
        this.worldFormat = new WorldFormat(server, PLAYER_DATA, new String[0]);
    }

    private void initializeIfNeeded() {
        if (this.initialize) {
            return;
        }
        this.init();
        this.initialize = true;
    }

    public void reload() {
        this.serializers.clear();
        this.init();
    }

    private void init() {
        try {
            List<File> list = this.worldFormat.toImmutableFileList(WorldFormat.JSON_EXTENSIONS);
            for (File file : list) {
                try {
                    this.serializers.add(new FakePlayerSerializer(file));
                }
                catch (JsonParseException | IOException | NullPointerException e) {
                    CarpetOrgAddition.LOGGER.warn("Failed to load player data successfully", e);
                }
            }
        }
        catch (RuntimeException e) {
            CarpetOrgAddition.LOGGER.warn("Unexpected error encountered while loading player data", (Throwable)e);
        }
    }

    public List<FakePlayerSerializer> list() {
        this.initializeIfNeeded();
        return this.serializers.stream().sorted(FakePlayerSerializer::compareTo).toList();
    }

    public HashMap<String, HashSet<FakePlayerSerializer>> listGroup(Predicate<FakePlayerSerializer> predicate) {
        HashMap<String, HashSet<FakePlayerSerializer>> map = new HashMap<String, HashSet<FakePlayerSerializer>>();
        List<FakePlayerSerializer> list = this.serializers.stream().filter(predicate).toList();
        for (FakePlayerSerializer serializer : list) {
            for (String group : serializer.getGroups()) {
                HashSet<FakePlayerSerializer> set = map.get(group);
                if (set == null) {
                    HashSet<FakePlayerSerializer> value = new HashSet<FakePlayerSerializer>();
                    value.add(serializer);
                    map.put(group, value);
                    continue;
                }
                set.add(serializer);
            }
        }
        return map;
    }

    public void add(FakePlayerSerializer serializer) {
        this.initializeIfNeeded();
        this.serializers.remove(serializer);
        this.serializers.add(serializer);
        serializer.save();
    }

    public Optional<FakePlayerSerializer> get(String name) {
        this.initializeIfNeeded();
        if (name.endsWith(".json")) {
            throw new IllegalArgumentException();
        }
        for (FakePlayerSerializer serializer : this.serializers) {
            if (!Objects.equals(serializer.getFakePlayerName(), name)) continue;
            return Optional.of(serializer);
        }
        return Optional.empty();
    }

    public int size() {
        return this.serializers.size();
    }

    public void onServerSave() {
        for (FakePlayerSerializer serializer : this.serializers) {
            if (!serializer.isChanged()) continue;
            serializer.save();
        }
    }

    public boolean remove(FakePlayerSerializer serializer) {
        this.initializeIfNeeded();
        boolean remove = this.serializers.remove(serializer);
        return remove && serializer.remove();
    }
}

