/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.task.search;

import carpet.CarpetSettings;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1730;
import net.minecraft.class_1792;
import net.minecraft.class_2168;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2512;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.class_7225;
import net.minecraft.class_9078;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.command.FinderCommand;
import org.carpetorgaddition.exception.FileOperationException;
import org.carpetorgaddition.periodic.ServerComponentCoordinator;
import org.carpetorgaddition.periodic.task.ServerTask;
import org.carpetorgaddition.rule.value.OpenPlayerInventory;
import org.carpetorgaddition.util.CommandUtils;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.util.GenericUtils;
import org.carpetorgaddition.util.IOUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.wheel.GameProfileCache;
import org.carpetorgaddition.wheel.ItemStackStatistics;
import org.carpetorgaddition.wheel.TextBuilder;
import org.carpetorgaddition.wheel.WorldFormat;
import org.carpetorgaddition.wheel.inventory.FabricPlayerAccessManager;
import org.carpetorgaddition.wheel.inventory.FabricPlayerAccessor;
import org.carpetorgaddition.wheel.inventory.ImmutableInventory;
import org.carpetorgaddition.wheel.inventory.OfflinePlayerInventory;
import org.carpetorgaddition.wheel.inventory.SimulatePlayerInventory;
import org.carpetorgaddition.wheel.page.PageManager;
import org.carpetorgaddition.wheel.page.PagedCollection;
import org.carpetorgaddition.wheel.predicate.ItemStackPredicate;
import org.carpetorgaddition.wheel.provider.CommandProvider;
import org.carpetorgaddition.wheel.provider.TextProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OfflinePlayerSearchTask
extends ServerTask {
    private static final Set<UUID> CORRUPTED_PLAYER_DATAS = ConcurrentHashMap.newKeySet();
    private static final Set<UUID> BACKED_UP_FILES = ConcurrentHashMap.newKeySet();
    public static final Set<UUID> INVALID_PLAYER_DATAS = ConcurrentHashMap.newKeySet();
    public static final ThreadLocal<UUID> CURRENT_UUID = new ThreadLocal();
    public static final String UNKNOWN = "[Unknown]";
    private static final DateTimeFormatter FORMATTER = class_9078.method_55786();
    private final AtomicInteger taskCount = new AtomicInteger();
    private final AtomicInteger itemCount = new AtomicInteger();
    private final AtomicBoolean shulkerBox = new AtomicBoolean(false);
    private final WorldFormat worldFormat;
    private final FabricPlayerAccessManager accessManager;
    private int total = 0;
    protected final class_3222 player;
    private final MinecraftServer server;
    private final File[] files;
    private final ItemStackPredicate predicate;
    private State taksState = State.START;
    private final List<Result> results = Collections.synchronizedList(new ArrayList());
    private volatile WorldFormat backupFileDirectory;
    private final Object backupInitLock = new Object();
    private final PagedCollection pagedCollection;

    public OfflinePlayerSearchTask(class_2168 source, ItemStackPredicate predicate, class_3222 player) {
        super(source);
        this.predicate = predicate;
        this.player = player;
        this.server = FetcherUtils.getServer(this.player);
        this.files = this.server.method_27050(class_5218.field_24182).toFile().listFiles();
        if (this.files == null) {
            throw new IllegalStateException("Unable to read \"playerdata\" folder");
        }
        this.worldFormat = new WorldFormat(this.server, "backups", "playerdata");
        PageManager manager = FetcherUtils.getPageManager(this.server);
        this.pagedCollection = manager.newPagedCollection(this.source);
        this.accessManager = ServerComponentCoordinator.getCoordinator(this.server).getAccessManager();
    }

    @Override
    protected void tick() {
        switch (this.taksState.ordinal()) {
            case 0: {
                this.start();
                this.taksState = State.RUNTIME;
                break;
            }
            case 1: {
                if (this.taskCount.get() != 0) break;
                this.taksState = State.FEEDBACK;
                break;
            }
            case 2: {
                this.sendFeedback();
                this.taksState = State.STOP;
                break;
            }
        }
    }

    private void start() {
        for (File file : this.files) {
            UUID uuid;
            if (!file.getName().endsWith(".dat")) continue;
            try {
                uuid = UUID.fromString(file.getName().split("\\.")[0]);
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            this.submit(file, uuid);
            ++this.total;
        }
    }

    private void submit(File unsafe, UUID uuid) {
        this.taskCount.getAndIncrement();
        this.submit(() -> {
            try {
                if (INVALID_PLAYER_DATAS.contains(uuid)) {
                    return;
                }
                if (this.server.method_3806()) {
                    class_2487 nbt = this.readNbt(unsafe, uuid);
                    if (nbt == null) {
                        return;
                    }
                    this.searchItem(uuid, nbt);
                }
            }
            catch (IOException | RuntimeException e) {
                CarpetOrgAddition.LOGGER.error("Unable to read player data from file for file {}", (Object)unsafe.getName(), (Object)e);
                OfflinePlayerSearchTask.addCorruptedPlayerUUID(uuid);
            }
            finally {
                this.taskCount.getAndDecrement();
            }
        });
    }

    @Nullable
    private class_2487 readNbt(File unsafe, UUID uuid) throws IOException {
        class_2487 nbt = class_2507.method_30613((Path)unsafe.toPath(), (class_2505)class_2505.method_53898());
        int version = class_2512.method_48309((class_2487)nbt, (int)-1);
        if (this.isCorruptedPlayerData(uuid) || version < GenericUtils.getNbtDataVersion()) {
            if (this.server.method_3806() && this.backupAndUpdate(unsafe, uuid)) {
                return class_2507.method_30613((Path)unsafe.toPath(), (class_2505)class_2505.method_53898());
            }
            return null;
        }
        return nbt;
    }

    private boolean isCorruptedPlayerData(UUID uuid) {
        return CORRUPTED_PLAYER_DATAS.contains(uuid);
    }

    public static void addCorruptedPlayerUUID(UUID uuid) {
        if (CORRUPTED_PLAYER_DATAS.add(uuid)) {
            CarpetOrgAddition.LOGGER.warn("Unable to read player data from file for UUID {}", (Object)uuid.toString());
        }
    }

    public static void removeCorruptedPlayerUUID(UUID uuid) {
        CORRUPTED_PLAYER_DATAS.remove(uuid);
    }

    public static void clear() {
        CORRUPTED_PLAYER_DATAS.clear();
        BACKED_UP_FILES.clear();
        INVALID_PLAYER_DATAS.clear();
    }

    private boolean backupAndUpdate(File unsafe, UUID uuid) {
        Optional<GameProfile> optional = OfflinePlayerInventory.getGameProfile(uuid, this.server);
        if (optional.isEmpty()) {
            return false;
        }
        GameProfile gameProfile = optional.get();
        try {
            this.backup(unsafe, uuid);
        }
        catch (RuntimeException e) {
            CarpetOrgAddition.LOGGER.warn("Player data has expired: {}", (Object)uuid.toString(), (Object)e);
            INVALID_PLAYER_DATAS.add(uuid);
            return false;
        }
        FabricPlayerAccessor accessor = this.accessManager.getOrCreateBlocking(gameProfile);
        OfflinePlayerInventory inventory = new OfflinePlayerInventory(accessor);
        inventory.setShowLog(false);
        inventory.method_5435((class_1657)this.player);
        inventory.method_5432((class_1657)this.player);
        return true;
    }

    private void backup(File file, UUID uuid) {
        if (this.shouldBackup(file, uuid)) {
            File backup = this.getBackupFileDirectory().file(file.getName());
            File parent = backup.getParentFile();
            if (!parent.isDirectory() && !parent.mkdirs()) {
                throw new FileOperationException();
            }
            IOUtils.copyFile(file, backup);
            BACKED_UP_FILES.add(uuid);
            OfflinePlayerSearchTask.removeCorruptedPlayerUUID(uuid);
            return;
        }
        throw new IllegalStateException();
    }

    private boolean shouldBackup(File file, UUID uuid) {
        if (BACKED_UP_FILES.contains(uuid)) {
            return false;
        }
        List<String> list = this.worldFormat.toImmutableFileList().stream().filter(File::isDirectory).map(File::getName).filter(this::parseDirectoryName).sorted().toList();
        if (list.isEmpty()) {
            return true;
        }
        File directory = this.worldFormat.directory(list.getLast());
        if (IOUtils.containsIdenticalFile(directory, file)) {
            BACKED_UP_FILES.add(uuid);
            return false;
        }
        return true;
    }

    private boolean parseDirectoryName(String name) {
        String end = "_" + GenericUtils.CURRENT_DATA_VERSION;
        if (name.endsWith(end)) {
            String dateTimeFormat = name.substring(0, name.length() - end.length());
            try {
                FORMATTER.parse(dateTimeFormat);
                return true;
            }
            catch (DateTimeParseException e) {
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchItem(UUID uuid, @NotNull class_2487 nbt) {
        GameProfileCache cache = GameProfileCache.getInstance();
        Optional<GameProfile> optional = cache.getGameProfile(uuid);
        boolean unknownPlayer = false;
        if (optional.isEmpty()) {
            optional = Optional.of(new GameProfile(uuid, UNKNOWN));
            unknownPlayer = true;
        }
        GameProfile gameProfile = optional.get();
        if (this.server.method_3760().method_14566(gameProfile.getName()) != null) {
            return;
        }
        try {
            CURRENT_UUID.set(uuid);
            this.statistics(this.getInventory(nbt), gameProfile, unknownPlayer, false);
            this.statistics(this.getEnderChest(nbt), gameProfile, unknownPlayer, true);
        }
        finally {
            CURRENT_UUID.remove();
        }
    }

    private void statistics(class_1263 inventory, GameProfile gameProfile, boolean unknownPlayer, boolean isEnderChest) {
        ItemStackStatistics statistics = new ItemStackStatistics(this.predicate);
        statistics.statistics(inventory);
        if (statistics.getSum() == 0) {
            return;
        }
        this.itemCount.addAndGet(statistics.getSum());
        if (statistics.hasNestingItem()) {
            this.shulkerBox.set(true);
        }
        Result result = new Result(gameProfile, statistics, unknownPlayer, isEnderChest);
        this.results.add(result);
    }

    private class_1263 getInventory(class_2487 nbt) {
        return SimulatePlayerInventory.of(nbt, this.server);
    }

    protected class_1263 getEnderChest(class_2487 nbt) {
        class_1730 inventory = new class_1730();
        if (nbt.method_10545("EnderItems")) {
            inventory.method_7659((class_2499)nbt.method_10554("EnderItems").orElseThrow(), (class_7225.class_7874)this.player.method_56673());
            return inventory;
        }
        return ImmutableInventory.EMPTY;
    }

    private void sendFeedback() {
        if (this.results.isEmpty()) {
            MessageUtils.sendMessage(this.source, "carpet.commands.finder.item.offline_player.not_found", this.predicate.toText());
            return;
        }
        int resultCount = this.results.size();
        this.results.sort((o1, o2) -> o2.statistics().getSum() - o1.statistics().getSum());
        this.pagedCollection.addContent(this.results);
        class_2561 itemCount = this.getItemCount();
        class_2561 numberOfPeople = this.getNumberOfPeople(resultCount);
        class_2561 message = this.getFirstFeedback(numberOfPeople, itemCount);
        TextBuilder builder = new TextBuilder(message);
        builder.setHover("carpet.commands.finder.item.offline_player.prompt", new Object[0]);
        MessageUtils.sendEmptyMessage(this.source);
        MessageUtils.sendMessage(this.source, builder.build());
        CommandUtils.handlingException(this.pagedCollection::print, this.source);
    }

    private class_2561 getFirstFeedback(class_2561 numberOfPeople, class_2561 itemCount) {
        return TextBuilder.translate("carpet.commands.finder.item.offline_player", numberOfPeople, itemCount, this.predicate.toText());
    }

    private class_2561 getItemCount() {
        Optional<class_1792> optional = this.predicate.getConvert();
        if (optional.isPresent()) {
            return FinderCommand.showCount(optional.get().method_7854(), this.itemCount.get(), this.shulkerBox.get());
        }
        TextBuilder builder = new TextBuilder(this.itemCount);
        return this.shulkerBox.get() ? builder.setItalic().build() : builder.build();
    }

    private class_2561 getNumberOfPeople(int resultCount) {
        ArrayList<class_2561> peopleHover = new ArrayList<class_2561>();
        peopleHover.add(TextBuilder.translate("carpet.commands.finder.item.offline_player.total", this.total));
        peopleHover.add(TextBuilder.translate("carpet.commands.finder.item.offline_player.found", resultCount));
        TextBuilder builder = new TextBuilder(resultCount);
        builder.setHover(TextBuilder.joinList(peopleHover));
        return builder.build();
    }

    private class_2561 getContainerName(boolean isEnderChest) {
        if (isEnderChest) {
            return TextBuilder.of("carpet.commands.finder.item.offline_player.container.enderchest", new Object[0]).setColor(class_124.field_1064).build();
        }
        return TextBuilder.of("carpet.commands.finder.item.offline_player.container.inventory", new Object[0]).setColor(class_124.field_1054).build();
    }

    @Override
    protected boolean stopped() {
        return this.taksState == State.STOP;
    }

    @Override
    public String getLogName() {
        return "\u4ece\u79bb\u7ebf\u73a9\u5bb6\u7269\u54c1\u680f\u5bfb\u627e\u7269\u54c1";
    }

    @Override
    public boolean equals(Object o) {
        return this == o || this.getClass() == o.getClass();
    }

    @Override
    public int hashCode() {
        return 1;
    }

    @Nullable
    private class_2561 openInventoryButton(GameProfile gameProfile) {
        if (this.canOpenOfflinePlayerInventory(this.source)) {
            String command = CommandProvider.openPlayerInventory(gameProfile.getId());
            TextBuilder builder = new TextBuilder("[O]");
            builder.setCommand(command);
            builder.setHover("carpet.commands.finder.item.offline_player.open.inventory", new Object[0]);
            builder.setColor(class_124.field_1080);
            return builder.build();
        }
        return null;
    }

    @Nullable
    private class_2561 openEnderChestButton(GameProfile gameProfile) {
        if (this.canOpenOfflinePlayerInventory(this.source)) {
            String command = CommandProvider.openPlayerEnderChest(gameProfile.getId());
            class_2561 clickLogin = TextBuilder.translate("carpet.commands.finder.item.offline_player.open.ender_chest", new Object[0]);
            TextBuilder builder = new TextBuilder("[O]");
            builder.setColor(class_124.field_1080);
            builder.setHover(clickLogin);
            builder.setCommand(command);
            return builder.build();
        }
        return null;
    }

    private boolean canOpenOfflinePlayerInventory(class_2168 source) {
        return CommandUtils.canUseCommand(source, CarpetSettings.commandPlayer) && OpenPlayerInventory.isEnable(source) && CarpetOrgAdditionSettings.playerCommandOpenPlayerInventoryOption.get().canOpenOfflinePlayer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorldFormat getBackupFileDirectory() {
        if (this.backupFileDirectory == null) {
            Object object = this.backupInitLock;
            synchronized (object) {
                String time = LocalDateTime.now().format(FORMATTER) + "_" + GenericUtils.getNbtDataVersion();
                this.backupFileDirectory = this.worldFormat.resolve(time);
            }
        }
        return this.backupFileDirectory;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        CarpetOrgAddition.LOGGER.warn("Encountered an unexpected error while querying offline player items", e);
    }

    public static enum State {
        START,
        RUNTIME,
        FEEDBACK,
        STOP;

    }

    public class Result
    implements Supplier<class_2561> {
        private final GameProfile gameProfile;
        private final ItemStackStatistics statistics;
        private final boolean isUnknown;
        private final boolean isEnderChest;

        private Result(GameProfile gameProfile, ItemStackStatistics statistics, boolean isUnknown, boolean isEnderChest) {
            this.gameProfile = gameProfile;
            this.statistics = statistics;
            this.isUnknown = isUnknown;
            this.isEnderChest = isEnderChest;
        }

        @Override
        public class_2561 get() {
            String name = this.gameProfile.getName();
            String uuid = this.gameProfile().getId().toString();
            class_2561 hover = TextBuilder.combineAll("UUID: %s\n".formatted(uuid), TextProvider.COPY_CLICK);
            class_2561 count = this.statistics().getCountText();
            TextBuilder builder = this.getDisplayPlayerName(name, uuid, hover, count, this.isEnderChest);
            return builder.build();
        }

        private TextBuilder getDisplayPlayerName(String name, String uuid, class_2561 hover, class_2561 count, boolean isEnderChest) {
            boolean unknown = this.isUnknown();
            TextBuilder builder = new TextBuilder((String)(unknown ? name : "[" + name + "]"));
            if (unknown) {
                builder.setStrikethrough().setCopyToClipboard(uuid, false).append(this.createSearchButton());
            } else {
                builder.append(this.createLoginButton()).setCopyToClipboard(name, false);
            }
            class_2561 button = isEnderChest ? OfflinePlayerSearchTask.this.openEnderChestButton(this.gameProfile()) : OfflinePlayerSearchTask.this.openInventoryButton(this.gameProfile());
            builder.append(button).setHover(hover).setColor(class_124.field_1080);
            class_2561 container = OfflinePlayerSearchTask.this.getContainerName(isEnderChest);
            return TextBuilder.of("carpet.commands.finder.item.offline_player.each", builder.build(), container, count);
        }

        private class_2561 createLoginButton() {
            if (CommandUtils.canUseCommand(OfflinePlayerSearchTask.this.source, CarpetSettings.commandPlayer)) {
                String command = CommandProvider.spawnFakePlayer(this.gameProfile().getName());
                TextBuilder builder = new TextBuilder(" [\u2191]");
                builder.setCommand(command);
                builder.setHover("carpet.command.text.click.login", new Object[0]);
                return builder.build();
            }
            return TextBuilder.empty();
        }

        private TextBuilder createSearchButton() {
            ArrayList<class_2561> list = new ArrayList<class_2561>();
            list.add(TextBuilder.translate("carpet.commands.finder.item.offline_player.query.name", new Object[0]));
            list.add(TextBuilder.of("carpet.commands.finder.item.offline_player.query.non_authentic", new Object[0]).setColor(class_124.field_1061).build());
            TextBuilder button = new TextBuilder(" [\ud83d\udd0d]");
            button.setCommand(CommandProvider.queryPlayerName(this.gameProfile().getId()));
            button.setHover(TextBuilder.joinList(list));
            return button;
        }

        public GameProfile gameProfile() {
            return this.gameProfile;
        }

        public ItemStackStatistics statistics() {
            return this.statistics;
        }

        public boolean isUnknown() {
            return this.isUnknown;
        }
    }
}

