/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.util;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_5244;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9636;
import net.minecraft.class_9701;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.wheel.TextBuilder;

public class EnchantmentUtils {
    public static boolean hasEnchantment(class_1937 world, class_5321<class_1887> key, class_1799 itemStack) {
        Optional optional = world.method_30349().method_46759(class_7924.field_41265);
        if (optional.isEmpty()) {
            return false;
        }
        class_1887 enchantment = (class_1887)((class_2378)optional.get()).method_29107(key);
        return EnchantmentUtils.getLevel(world, enchantment, itemStack) > 0;
    }

    public static boolean isSpecified(class_1937 world, class_5321<class_1887> key, class_1887 enchantment) {
        Optional optional = world.method_30349().method_46759(class_7924.field_41265);
        if (optional.isEmpty()) {
            return false;
        }
        class_1887 value = (class_1887)((class_2378)optional.get()).method_29107(key);
        return value != null && value.equals((Object)enchantment);
    }

    public static boolean isProtectionEnchantment(class_5321<class_1887> key) {
        return key == class_1893.field_9111 || key == class_1893.field_9107 || key == class_1893.field_9095 || key == class_1893.field_9096;
    }

    public static boolean isDamageEnchantment(class_5321<class_1887> key) {
        return key == class_1893.field_9118 || key == class_1893.field_9123 || key == class_1893.field_9112 || key == class_1893.field_9106 || key == class_1893.field_50157 || key == class_1893.field_50158;
    }

    public static int getLevel(class_1937 world, class_1887 enchantment, class_1799 itemStack) {
        class_5455 registryManager = world.method_30349();
        return EnchantmentUtils.getLevel(enchantment, itemStack, registryManager);
    }

    public static int getLevel(MinecraftServer server, class_1887 enchantment, class_1799 itemStack) {
        class_5455.class_6890 registryManager = server.method_30611();
        return EnchantmentUtils.getLevel(enchantment, itemStack, (class_5455)registryManager);
    }

    private static int getLevel(class_1887 enchantment, class_1799 itemStack, class_5455 registryManager) {
        Optional optional = registryManager.method_46759(class_7924.field_41265);
        if (optional.isEmpty()) {
            return 0;
        }
        class_6880 entry = ((class_2378)optional.get()).method_47983((Object)enchantment);
        if (itemStack.method_31574(class_1802.field_8598)) {
            class_9304 component = (class_9304)itemStack.method_58695(class_9334.field_49643, (Object)class_9304.field_49385);
            return component.method_57536(entry);
        }
        return class_1890.method_8225((class_6880)entry, (class_1799)itemStack);
    }

    public static class_2561 getName(class_1887 enchantment) {
        TextBuilder builder = new TextBuilder(enchantment.comp_2686());
        class_6880 entry = class_6880.method_40223((Object)enchantment);
        class_124 color = entry.method_40220(class_9636.field_51551) ? class_124.field_1061 : class_124.field_1080;
        builder.setColor(color);
        return builder.build();
    }

    public static class_2561 getName(class_1887 enchantment, int level) {
        class_2561 mutableText = EnchantmentUtils.getName(enchantment);
        if (level != 1 || enchantment.method_8183() != 1) {
            mutableText = TextBuilder.combineAll(mutableText, class_5244.field_41874, TextBuilder.translate("enchantment.level." + level, new Object[0]));
        }
        return mutableText;
    }

    public static boolean canRepairWithXp(class_1799 itemStack) {
        class_9304 component = (class_9304)itemStack.method_58695(class_9334.field_49633, (Object)class_9304.field_49385);
        for (Object2IntMap.Entry entry : component.method_57539()) {
            class_6880 registryEntry = (class_6880)entry.getKey();
            if (!((class_1887)registryEntry.comp_349()).comp_2689().method_57832(class_9701.field_51652)) continue;
            return true;
        }
        return false;
    }
}

