/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.util;

import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1263;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2480;
import net.minecraft.class_9279;
import net.minecraft.class_9288;
import net.minecraft.class_9334;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.wheel.ContainerDeepCopy;
import org.carpetorgaddition.wheel.Counter;
import org.carpetorgaddition.wheel.inventory.ContainerComponentInventory;
import org.carpetorgaddition.wheel.inventory.ImmutableInventory;
import org.jetbrains.annotations.CheckReturnValue;
import org.jetbrains.annotations.Contract;

public class InventoryUtils {
    private static final boolean GCA_LOADED = FabricLoader.getInstance().isModLoaded("gca");

    private InventoryUtils() {
    }

    @CheckReturnValue
    public static class_1799 pickItemFromShulkerBox(class_1799 shulkerBox, Predicate<class_1799> predicate) {
        if (InventoryUtils.isOperableSulkerBox(shulkerBox)) {
            InventoryUtils.deepCopyContainer(shulkerBox);
            ContainerComponentInventory inventory = new ContainerComponentInventory(shulkerBox);
            return inventory.pinkStack(predicate);
        }
        return class_1799.field_8037;
    }

    @CheckReturnValue
    public static class_1799 pickItemFromShulkerBox(class_1799 shulkerBox, Predicate<class_1799> predicate, int count) {
        if (count <= 0) {
            return class_1799.field_8037;
        }
        if (InventoryUtils.isOperableSulkerBox(shulkerBox)) {
            InventoryUtils.deepCopyContainer(shulkerBox);
            ContainerComponentInventory inventory = new ContainerComponentInventory(shulkerBox);
            return inventory.pinkStack(predicate, count);
        }
        return class_1799.field_8037;
    }

    @CheckReturnValue
    public static class_1799 addItemToShulkerBox(class_1799 container, class_1799 itemStack) {
        if (container.method_7960() || itemStack.method_7960()) {
            return class_1799.field_8037;
        }
        if (InventoryUtils.isOperableSulkerBox(container) && itemStack.method_7909().method_31568()) {
            ContainerComponentInventory inventory = new ContainerComponentInventory(container);
            return inventory.method_5491(itemStack);
        }
        return itemStack;
    }

    public static int shulkerCanInsertItemCount(class_1799 container, class_1799 itemStack) {
        class_9288 component = (class_9288)container.method_58694(class_9334.field_49622);
        if (component == null || component == class_9288.field_49334) {
            return itemStack.method_7914() * 27;
        }
        List list = component.method_59712().toList();
        int count = 0;
        for (class_1799 stack : list) {
            if (stack.method_7947() == stack.method_7914() || !class_1799.method_31577((class_1799)stack, (class_1799)itemStack)) continue;
            count += stack.method_7914() - stack.method_7947();
        }
        int emptySlotCount = 27 - list.size();
        return count += emptySlotCount * itemStack.method_7914();
    }

    @Contract(pure=true)
    public static class_1799 getFirstItemStack(class_1799 container) {
        if (InventoryUtils.isOperableSulkerBox(container)) {
            class_9288 component = (class_9288)container.method_58694(class_9334.field_49622);
            if (component == null || component == class_9288.field_49334) {
                return class_1799.field_8037;
            }
            Iterator iterator = component.method_59712().iterator();
            return iterator.hasNext() ? (class_1799)iterator.next() : class_1799.field_8037;
        }
        return class_1799.field_8037;
    }

    public static boolean isEmptyShulkerBox(class_1799 shulkerBox) {
        if (shulkerBox.method_7947() != 1) {
            return true;
        }
        class_9288 component = (class_9288)shulkerBox.method_58694(class_9334.field_49622);
        if (component == null || component == class_9288.field_49334) {
            return true;
        }
        return !component.method_59714().iterator().hasNext();
    }

    public static boolean contains(class_1799 shulkerBox, Predicate<class_1799> predicate) {
        if (InventoryUtils.isOperableSulkerBox(shulkerBox)) {
            ContainerComponentInventory inventory = new ContainerComponentInventory(shulkerBox);
            Iterator iterator = inventory.iterator();
            while (iterator.hasNext()) {
                class_1799 itemStack = (class_1799)iterator.next();
                if (!predicate.test(itemStack)) continue;
                return true;
            }
        }
        return false;
    }

    public static ImmutableInventory getInventory(class_1799 shulkerBox) {
        if (InventoryUtils.isEmptyShulkerBox(shulkerBox)) {
            return ImmutableInventory.EMPTY;
        }
        class_9288 component = (class_9288)shulkerBox.method_58694(class_9334.field_49622);
        return new ImmutableInventory(component.method_59712().toList());
    }

    public static void deepCopyContainer(class_1799 shulkerBox) {
        class_9288 component = (class_9288)shulkerBox.method_58694(class_9334.field_49622);
        if (component == null || component == class_9288.field_49334) {
            return;
        }
        class_9288 copy = ((ContainerDeepCopy)component).carpet_Org_Addition$copy();
        shulkerBox.method_57379(class_9334.field_49622, (Object)copy);
    }

    public static boolean isShulkerBoxItem(class_1799 shulkerBox) {
        if (shulkerBox.method_31574(class_1802.field_8545)) {
            return true;
        }
        class_1792 class_17922 = shulkerBox.method_7909();
        if (class_17922 instanceof class_1747) {
            class_1747 blockItem = (class_1747)class_17922;
            return blockItem.method_7711() instanceof class_2480;
        }
        return false;
    }

    public static void assertEmptyStack(class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return;
        }
        throw new IllegalStateException();
    }

    public static void assertEmptyStack(class_1799 itemStack, Supplier<String> message) {
        if (itemStack.method_7960()) {
            return;
        }
        throw new IllegalStateException(message.get());
    }

    public static boolean isItemStackFull(class_1799 itemStack) {
        return itemStack.method_7946() && itemStack.method_7914() <= itemStack.method_7947();
    }

    public static boolean canMergeTo(class_1799 stack, class_1799 target) {
        if (InventoryUtils.isItemStackFull(target)) {
            return false;
        }
        return InventoryUtils.canMerge(stack, target);
    }

    public static boolean canMerge(class_1799 stack, class_1799 otherStack) {
        return class_1799.method_31577((class_1799)stack, (class_1799)otherStack);
    }

    public static void mergeStack(class_1799 sacrifice, class_1799 retain) {
        if (InventoryUtils.canMerge(sacrifice, retain)) {
            if (InventoryUtils.isItemStackFull(retain)) {
                return;
            }
        } else {
            throw new IllegalArgumentException("Attempting to merge two items that are not completely identical");
        }
        int shortage = Math.min(retain.method_7914() - retain.method_7947(), sacrifice.method_7947());
        retain.method_7933(shortage);
        sacrifice.method_7934(shortage);
    }

    public static int compare(class_1799 left, class_1799 right) {
        if (InventoryUtils.canMerge(left, right)) {
            return -Integer.compare(left.method_7947(), right.method_7947());
        }
        if (left.method_7960()) {
            return 1;
        }
        if (right.method_7960()) {
            return -1;
        }
        if (left.method_31574(right.method_7909())) {
            if (InventoryUtils.isShulkerBoxItem(left)) {
                return new ContainerComponentInventory(left).compareTo(new ContainerComponentInventory(right));
            }
            int compareComponent = Integer.compare(left.method_57353().method_57835(), right.method_57353().method_57835());
            if (compareComponent != 0) {
                return compareComponent;
            }
            int compareCount = -Integer.compare(left.method_7947(), right.method_7947());
            if (compareCount != 0) {
                return compareComponent;
            }
            return Integer.compare(class_1799.method_57355((class_1799)left), class_1799.method_57355((class_1799)right));
        }
        if (InventoryUtils.isShulkerBoxItem(left) && !InventoryUtils.isShulkerBoxItem(right)) {
            return 1;
        }
        if (!InventoryUtils.isShulkerBoxItem(left) && InventoryUtils.isShulkerBoxItem(right)) {
            return -1;
        }
        return InventoryUtils.compare(left.method_7909(), right.method_7909());
    }

    public static int compare(class_1792 left, class_1792 right) {
        return InventoryUtils.getRegistryId(left).compareTo(InventoryUtils.getRegistryId(right));
    }

    public static class_1799 findMostAbundantStack(class_1263 inventory, Predicate<class_1799> predicate) {
        Counter<ItemStackWrapper> counter = new Counter<ItemStackWrapper>();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 itemStack = inventory.method_5438(i);
            if (itemStack.method_7960() || !predicate.test(itemStack)) continue;
            counter.add(new ItemStackWrapper(itemStack), itemStack.method_7947());
        }
        return ((class_1799)((Counter.Wrapper)counter.getMostOrDefault(ItemStackWrapper.EMPTY)).getValue()).method_7972();
    }

    public static boolean canAcceptAsSingleItemType(class_1799 shulker, class_1799 target, boolean acceptEmptyShulker) {
        class_9288 component = (class_9288)shulker.method_58694(class_9334.field_49622);
        if (component == null || component == class_9288.field_49334) {
            return acceptEmptyShulker;
        }
        return component.method_59712().allMatch(itemStack -> InventoryUtils.canMerge(itemStack, target));
    }

    public static boolean isJunkBox(class_1799 shulker) {
        class_9288 component = (class_9288)shulker.method_58694(class_9334.field_49622);
        if (component == null || component == class_9288.field_49334) {
            return false;
        }
        List list = component.method_59712().toList();
        if (list.size() < 2) {
            return false;
        }
        class_1799 first = (class_1799)list.getFirst();
        for (int i = 1; i < list.size(); ++i) {
            if (InventoryUtils.canMerge(first, (class_1799)list.get(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isOperableSulkerBox(class_1799 shulker) {
        return InventoryUtils.isShulkerBoxItem(shulker) && shulker.method_7947() == 1;
    }

    public static int count(class_1263 inventory, Predicate<class_1799> predicate) {
        int count = 0;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 itemStack = inventory.method_5438(i);
            if (!predicate.test(itemStack)) continue;
            count += itemStack.method_7947();
        }
        return count;
    }

    public static String getRegistryId(class_1792 item) {
        return item.toString();
    }

    public static boolean isFoodItem(class_1799 itemStack) {
        return itemStack.method_57826(class_9334.field_50075);
    }

    public static boolean isToolItem(class_1799 itemStack) {
        return itemStack.method_57826(class_9334.field_50077);
    }

    public static boolean isGcaItem(class_1799 itemStack) {
        if (GCA_LOADED || CarpetOrgAddition.isDebugDevelopment()) {
            class_9279 component = (class_9279)itemStack.method_58694(class_9334.field_49628);
            if (component == null) {
                return false;
            }
            return component.method_57461().method_10580("GcaClear") != null;
        }
        return false;
    }

    public static class ItemStackWrapper
    extends Counter.Wrapper<class_1799> {
        private static final ItemStackWrapper EMPTY = new ItemStackWrapper(class_1799.field_8037);

        public ItemStackWrapper(class_1799 value) {
            super(value);
        }

        @Override
        public boolean valueEquals(class_1799 value1, Object value2) {
            if (value1.getClass() == value2.getClass()) {
                return InventoryUtils.canMerge(value1, (class_1799)value2);
            }
            return false;
        }

        @Override
        public int valueHashCode(class_1799 value) {
            return class_1799.method_57355((class_1799)value);
        }
    }
}

