/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.command;

import carpet.patches.EntityPlayerMPFake;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Locale;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2181;
import net.minecraft.class_2186;
import net.minecraft.class_2277;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.command.AbstractServerCommand;
import org.carpetorgaddition.util.CommandUtils;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.util.IOUtils;
import org.carpetorgaddition.util.MathUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.util.WorldUtils;
import org.carpetorgaddition.wheel.WorldFormat;

public class SpectatorCommand
extends AbstractServerCommand {
    private static final String SPECTATOR = "spectator";

    public SpectatorCommand(CommandDispatcher<class_2168> dispatcher, class_7157 access) {
        super(dispatcher, access);
    }

    @Override
    public void register(String name) {
        this.dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).requires(CommandUtils.canUseCommand(CarpetOrgAdditionSettings.commandSpectator))).executes(context -> this.setGameMode((CommandContext<class_2168>)context, false))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> this.setGameMode((CommandContext<class_2168>)context, true)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"teleport").then(class_2170.method_9247((String)"dimension").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).executes(this::tpToDimension)).then(class_2170.method_9244((String)"location", (ArgumentType)class_2277.method_9737()).executes(this::tpToDimensionLocation))))).then(class_2170.method_9247((String)"entity").then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).executes(this::tpToEntity)))));
    }

    private int setGameMode(CommandContext<class_2168> context, boolean isFakePlayer) throws CommandSyntaxException {
        class_1934 gameMode;
        EntityPlayerMPFake player;
        Object object = player = isFakePlayer ? CommandUtils.getArgumentFakePlayer(context) : CommandUtils.getSourcePlayer(context);
        if (player.method_7325()) {
            gameMode = class_1934.field_9215;
            if (!isFakePlayer) {
                this.loadPlayerPos(FetcherUtils.getServer((class_3222)player), (class_3222)player);
            }
        } else {
            gameMode = class_1934.field_9219;
            if (isFakePlayer) {
                player.method_45166(0.0, 0.2, 0.0);
            } else {
                this.savePlayerPos(FetcherUtils.getServer((class_3222)player), (class_3222)player);
            }
        }
        player.method_7336(gameMode);
        class_2561 text = gameMode.method_8383();
        player.method_7353((class_2561)class_2561.method_43469((String)"commands.gamemode.success.self", (Object[])new Object[]{text}), true);
        return gameMode == class_1934.field_9215 ? 1 : 0;
    }

    private int tpToDimension(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        this.requireSpectator(player);
        class_3218 dimension = class_2181.method_9289(context, (String)"dimension");
        if (player.method_51469().method_27983() == class_1937.field_25179 && dimension.method_27983() == class_1937.field_25180) {
            WorldUtils.teleport((class_1297)player, dimension, player.method_23317() / 8.0, player.method_23318(), player.method_23321() / 8.0, player.method_36454(), player.method_36455());
        } else if (player.method_51469().method_27983() == class_1937.field_25180 && dimension.method_27983() == class_1937.field_25179) {
            WorldUtils.teleport((class_1297)player, dimension, player.method_23317() * 8.0, player.method_23318(), player.method_23321() * 8.0, player.method_36454(), player.method_36455());
        } else {
            WorldUtils.teleport((class_1297)player, dimension, player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455());
        }
        MessageUtils.sendMessage(context, "carpet.commands.spectator.teleport.success.dimension", player.method_5476(), WorldUtils.getDimensionId((class_1937)dimension));
        return 1;
    }

    private int tpToDimensionLocation(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        this.requireSpectator(player);
        class_3218 dimension = class_2181.method_9289(context, (String)"dimension");
        class_243 location = class_2277.method_9736(context, (String)"location");
        WorldUtils.teleport((class_1297)player, dimension, location.method_10216(), location.method_10214(), location.method_10215(), player.method_36454(), player.method_36455());
        MessageUtils.sendMessage(context, "commands.teleport.success.location.single", player.method_5476(), this.formatFloat(location.method_10216()), this.formatFloat(location.method_10214()), this.formatFloat(location.method_10215()));
        return 1;
    }

    private int tpToEntity(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = CommandUtils.getSourcePlayer(context);
        this.requireSpectator(player);
        class_1297 entity = class_2186.method_9313(context, (String)"entity");
        WorldUtils.teleport((class_1297)player, (class_3218)FetcherUtils.getWorld(entity), entity.method_23317(), entity.method_23318(), entity.method_23321(), entity.method_36454(), entity.method_36455());
        MessageUtils.sendMessage(context, "commands.teleport.success.entity.single", player.method_5476(), entity.method_5476());
        return 1;
    }

    private void requireSpectator(class_3222 player) throws CommandSyntaxException {
        if (player.method_7325()) {
            return;
        }
        throw CommandUtils.createException("carpet.commands.spectator.teleport.fail", class_1934.field_9219.method_8383());
    }

    private void savePlayerPos(MinecraftServer server, class_3222 player) {
        WorldFormat worldFormat = new WorldFormat(server, SPECTATOR, new String[0]);
        JsonObject json = new JsonObject();
        json.addProperty("x", MathUtils.numberToTwoDecimalString(player.method_23317()));
        json.addProperty("y", MathUtils.numberToTwoDecimalString(player.method_23318()));
        json.addProperty("z", MathUtils.numberToTwoDecimalString(player.method_23321()));
        json.addProperty("yaw", MathUtils.numberToTwoDecimalString(player.method_36454()));
        json.addProperty("pitch", MathUtils.numberToTwoDecimalString(player.method_36455()));
        json.addProperty("dimension", WorldUtils.getDimensionId((class_1937)FetcherUtils.getWorld(player)));
        File file = worldFormat.file(player.method_5845() + ".json");
        try {
            IOUtils.write(file, json);
        }
        catch (IOException e) {
            CarpetOrgAddition.LOGGER.warn("Unable to write the location information of {} to the file normally", (Object)FetcherUtils.getPlayerName((class_1657)player), (Object)e);
        }
    }

    public void loadPlayerPos(MinecraftServer server, class_3222 player) {
        WorldFormat worldFormat = new WorldFormat(server, SPECTATOR, new String[0]);
        File file = worldFormat.file(player.method_5845() + ".json");
        try {
            BufferedReader reader;
            try (BufferedReader bufferedReader = reader = IOUtils.toReader(file);){
                Gson gson = new Gson();
                JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                double x = json.get("x").getAsDouble();
                double y = json.get("y").getAsDouble();
                double z = json.get("z").getAsDouble();
                float yaw = json.get("yaw").getAsFloat();
                float pitch = json.get("pitch").getAsFloat();
                String dimension = json.get("dimension").getAsString();
                class_3218 world = WorldUtils.getWorld(server, dimension);
                WorldUtils.teleport((class_1297)player, world, x, y, z, yaw, pitch);
            }
        }
        catch (IOException | NullPointerException e) {
            CarpetOrgAddition.LOGGER.warn("Unable to read the location information of {} normally", (Object)FetcherUtils.getPlayerName((class_1657)player));
        }
    }

    private String formatFloat(double d) {
        return String.format(Locale.ROOT, "%f", d);
    }

    @Override
    public String getDefaultName() {
        return SPECTATOR;
    }
}

