/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.rule;

import carpet.api.settings.CarpetRule;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.carpetorgaddition.rule.CustomRuleControl;

public class RuleContext<T> {
    private final Class<T> type;
    private final Collection<String> categories;
    private final Collection<String> suggestions;
    private final boolean isRemove;
    private final boolean isHidden;
    private final CustomRuleControl<?> control;
    private final T value;
    private final String name;
    private final Supplier<CarpetRule<T>> ruleSupplier;
    private final List<Supplier<Boolean>> conditions;
    private volatile CarpetRule<T> rule;

    public RuleContext(Class<T> type, T value, String name, Supplier<CarpetRule<T>> ruleSupplier, List<Supplier<Boolean>> conditions, Collection<String> categories, Collection<String> suggestions, boolean isRemove, boolean isHidden, CustomRuleControl<?> control) {
        this.name = name;
        this.ruleSupplier = ruleSupplier;
        this.value = value;
        this.conditions = conditions;
        this.type = type;
        this.categories = categories;
        this.suggestions = suggestions;
        this.isRemove = isRemove;
        this.isHidden = isHidden;
        this.control = control;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CarpetRule<T> rule() {
        if (this.rule == null) {
            RuleContext ruleContext = this;
            synchronized (ruleContext) {
                if (this.rule == null) {
                    this.rule = this.ruleSupplier.get();
                }
            }
        }
        return this.rule;
    }

    public T value() {
        return this.value;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean isRemove() {
        return this.isRemove;
    }

    public CustomRuleControl<?> getCustomRuleControl() {
        return this.control;
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getType() {
        return this.type;
    }

    public Collection<String> getSuggestions() {
        return this.suggestions;
    }

    public Collection<String> getCategories() {
        return this.categories;
    }

    public boolean shouldRegister() {
        return this.conditions.stream().allMatch(Supplier::get);
    }
}

