/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.wheel;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_9276;
import net.minecraft.class_9288;
import net.minecraft.class_9334;
import org.carpetorgaddition.wheel.Counter;
import org.carpetorgaddition.wheel.TextBuilder;

public class ItemStackStatistics {
    private int sum;
    private final Predicate<class_1799> predicate;
    private final Counter<class_1792> counter = new Counter();
    private final HashSet<class_1792> nestingItem = new HashSet();

    public ItemStackStatistics(Predicate<class_1799> predicate) {
        this.predicate = predicate;
    }

    public void statistics(class_1263 inventory) {
        this.statistics(inventory, false);
    }

    public void statistics(class_1263 inventory, boolean isNestingInventory) {
        for (int i = 0; i < inventory.method_5439(); ++i) {
            this.tally(inventory.method_5438(i), isNestingInventory);
        }
    }

    public void statistics(Iterable<class_1799> iterable, boolean isNestingInventory, int multiple) {
        iterable.forEach(itemStack -> this.tally((class_1799)itemStack, isNestingInventory, multiple));
    }

    private void statistics(class_1799 itemStack) {
        int count = itemStack.method_7947();
        class_9288 container = (class_9288)itemStack.method_58694(class_9334.field_49622);
        if (container != null) {
            this.statistics(container.method_59714(), true, count);
            return;
        }
        class_9276 bundleContents = (class_9276)itemStack.method_58694(class_9334.field_49650);
        if (bundleContents != null) {
            this.statistics(bundleContents.method_57421(), true, count);
        }
    }

    private void tally(class_1799 itemStack, boolean nesting) {
        this.tally(itemStack, nesting, 1);
    }

    private void tally(class_1799 itemStack, boolean nesting, int multiple) {
        if (this.predicate.test(itemStack)) {
            class_1792 item = itemStack.method_7909();
            int count = itemStack.method_7947();
            this.counter.add(item, count * multiple);
            this.sum += count * multiple;
            if (nesting) {
                this.nestingItem.add(item);
            }
        }
        this.statistics(itemStack);
    }

    public int getSum() {
        return this.sum;
    }

    public boolean hasNestingItem() {
        return !this.nestingItem.isEmpty();
    }

    public class_2561 getCountText() {
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        for (class_1792 item : this.counter) {
            class_2561 itemCount = this.itemCount(this.counter.getCount(item), item.method_7882());
            if (this.nestingItem.contains(item)) {
                TextBuilder builder = TextBuilder.fromCombined(item.method_63680(), " ", itemCount);
                builder.setItalic();
                list.add(builder.build());
                continue;
            }
            list.add(TextBuilder.combineAll(item.method_63680(), " ", itemCount));
        }
        class_2561 text = TextBuilder.create(this.getSum());
        TextBuilder builder = new TextBuilder(text);
        builder.setHover(TextBuilder.joinList(list));
        return this.nestingItem.isEmpty() ? builder.build() : builder.setItalic().build();
    }

    private class_2561 itemCount(int count, int maxCount) {
        int group = count / maxCount;
        int remainder = count % maxCount;
        if (group == 0) {
            return TextBuilder.translate("carpet.command.item.remainder", remainder);
        }
        if (remainder == 0) {
            return TextBuilder.translate("carpet.command.item.group", group);
        }
        return TextBuilder.translate("carpet.command.item.count", group, remainder);
    }
}

