/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.wheel.inventory;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_9288;
import net.minecraft.class_9334;
import org.carpetorgaddition.util.InventoryUtils;
import org.carpetorgaddition.wheel.predicate.ItemStackPredicate;
import org.jetbrains.annotations.CheckReturnValue;
import org.jetbrains.annotations.NotNull;

public class ContainerComponentInventory
extends class_1277
implements Comparable<ContainerComponentInventory> {
    private final class_1799 itemStack;
    public static final int CONTAINER_SIZE = 27;

    public ContainerComponentInventory(class_1799 itemStack) {
        super(27);
        InventoryUtils.deepCopyContainer(itemStack);
        this.itemStack = itemStack;
        class_9288 component = (class_9288)this.itemStack.method_58694(class_9334.field_49622);
        if (component != null) {
            component.method_57492(this.method_54454());
        }
    }

    public void method_5431() {
        super.method_5431();
        class_2371 stacks = this.method_54454();
        this.itemStack.method_57379(class_9334.field_49622, (Object)class_9288.method_57493((List)stacks));
    }

    public boolean method_5443(class_1657 player) {
        if (this.itemStack.method_7960()) {
            return false;
        }
        return this.itemStack.method_7947() == 1 && super.method_5443(player);
    }

    @CheckReturnValue
    public class_1799 pinkStack(Predicate<class_1799> predicate) {
        for (int i = 0; i < this.method_5439(); ++i) {
            class_1799 stack = this.method_5438(i);
            if (!predicate.test(stack)) continue;
            class_1799 result = stack.method_7972();
            this.method_5447(i, class_1799.field_8037);
            return result;
        }
        return class_1799.field_8037;
    }

    @CheckReturnValue
    public class_1799 pinkStack(Predicate<class_1799> predicate, int count) {
        for (int i = 0; i < this.method_5439(); ++i) {
            class_1799 stack = this.method_5438(i);
            if (!predicate.test(stack)) continue;
            return this.method_5434(i, count);
        }
        return class_1799.field_8037;
    }

    public int count(Predicate<class_1799> predicate) {
        int count = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            class_1799 stack = (class_1799)iterator.next();
            if (stack.method_7960() || !predicate.test(stack)) continue;
            count += stack.method_7947();
        }
        return count;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerComponentInventory inventory = (ContainerComponentInventory)o;
        return InventoryUtils.canMerge(this.itemStack, inventory.itemStack);
    }

    public int hashCode() {
        return class_1799.method_57355((class_1799)this.itemStack);
    }

    public String toString() {
        if (this.method_5442()) {
            return "{Size: %s[]}".formatted(this.method_5439());
        }
        StringJoiner joiner = new StringJoiner(", ", "{Size: %s[".formatted(this.method_5439()), "]}");
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            class_1799 itemStack = (class_1799)iterator.next();
            if (itemStack.method_7960()) continue;
            joiner.add(itemStack.method_7909().toString() + "*" + itemStack.method_7947());
        }
        return joiner.toString();
    }

    @Override
    public int compareTo(@NotNull ContainerComponentInventory o) {
        if (this.equals(o)) {
            return 0;
        }
        boolean thisIsEmpty = this.method_5442();
        boolean otherIsEmpty = o.method_5442();
        if (thisIsEmpty && otherIsEmpty) {
            return 0;
        }
        if (thisIsEmpty) {
            return 1;
        }
        if (otherIsEmpty) {
            return -1;
        }
        Optional<class_1792> thisOptional = this.singleItemType();
        Optional<class_1792> otherOptional = o.singleItemType();
        if (thisOptional.isEmpty() && otherOptional.isEmpty()) {
            int compareToCount = this.compareToCount(o);
            if (compareToCount != 0) {
                return compareToCount;
            }
            return Integer.compare(this.hashCode(), o.hashCode());
        }
        if (thisOptional.isEmpty()) {
            return 1;
        }
        if (otherOptional.isEmpty()) {
            return -1;
        }
        int compareId = InventoryUtils.compare(thisOptional.get(), otherOptional.get());
        if (compareId != 0) {
            return compareId;
        }
        int compareCount = this.compareToCount(o);
        if (compareCount != 0) {
            return compareCount;
        }
        return Integer.compare(this.hashCode(), o.hashCode());
    }

    private int compareToCount(@NotNull ContainerComponentInventory o) {
        int thisCount = InventoryUtils.count((class_1263)this, ItemStackPredicate.WILDCARD);
        int otherCount = InventoryUtils.count((class_1263)o, ItemStackPredicate.WILDCARD);
        return -Integer.compare(thisCount, otherCount);
    }

    private Optional<class_1792> singleItemType() {
        class_1792 item = null;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            class_1799 stack = (class_1799)iterator.next();
            if (stack.method_7960()) continue;
            if (item == null) {
                item = stack.method_7909();
            }
            if (item == stack.method_7909()) continue;
            return Optional.empty();
        }
        return Optional.ofNullable(item);
    }
}

