/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.wheel.inventory;

import com.mojang.authlib.GameProfile;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.minecraft.class_1661;
import net.minecraft.class_1730;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5321;
import net.minecraft.class_8942;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.mixin.accessor.PlayerManagerAccessor;
import org.carpetorgaddition.wheel.inventory.FabricPlayerAccessManager;

public class FabricPlayerAccessor {
    private final FakePlayer fabricPlayer;
    private final MinecraftServer server;
    private final FabricPlayerAccessManager accessManager;
    private final Set<class_3222> viewers = new HashSet<class_3222>();
    private final GameProfile gameProfile;

    public FabricPlayerAccessor(MinecraftServer server, GameProfile gameProfile, FabricPlayerAccessManager accessManager) {
        this.server = server;
        this.fabricPlayer = FakePlayer.get((class_3218)server.method_30002(), (GameProfile)gameProfile);
        this.gameProfile = gameProfile;
        this.initFakePlayer(server);
        this.accessManager = accessManager;
        this.accessManager.addViewers(gameProfile, this.viewers);
    }

    private void initFakePlayer(MinecraftServer server) {
        class_8942.class_11340 logging;
        try (class_8942.class_11340 class_113402 = logging = new class_8942.class_11340(CarpetOrgAddition.LOGGER);){
            Optional optional = server.method_3760().method_14600((class_3222)this.fabricPlayer, (class_8942)logging);
            class_5321 registryKey = optional.flatMap(nbt -> nbt.method_71426("Dimension", class_1937.field_25178)).orElse(class_1937.field_25179);
            class_3218 world = server.method_3847(registryKey);
            if (world != null) {
                this.fabricPlayer.method_51468(world);
            }
        }
    }

    public class_1661 getInventory() {
        return this.fabricPlayer.method_31548();
    }

    public class_1730 getEnderChest() {
        return this.fabricPlayer.method_7274();
    }

    public void onOpen(class_3222 player) {
        this.viewers.add(player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose(class_3222 player) {
        this.viewers.remove(player);
        if (this.viewers.isEmpty()) {
            try {
                class_3324 playerManager = this.server.method_3760();
                PlayerManagerAccessor accessor = (PlayerManagerAccessor)playerManager;
                accessor.savePlayerEntityData((class_3222)this.fabricPlayer);
            }
            catch (RuntimeException e) {
                CarpetOrgAddition.LOGGER.error("Failed to save player data for {}", (Object)this.gameProfile.getName(), (Object)e);
            }
            finally {
                this.accessManager.removeAccessor(this.gameProfile);
                this.accessManager.removeViewer(this.gameProfile);
            }
        }
    }

    public GameProfile getGameProfile() {
        return this.gameProfile;
    }
}

