/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.wheel.provider;

import java.time.LocalDateTime;
import java.util.ArrayList;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.util.WorldUtils;
import org.carpetorgaddition.wheel.TextBuilder;
import org.carpetorgaddition.wheel.provider.CommandProvider;
import org.jetbrains.annotations.Nullable;

public class TextProvider {
    public static final class_2561 NEW_LINE = TextBuilder.create("\n");
    @Deprecated(forRemoval=true)
    public static final class_2561 INDENT_SYMBOL = TextBuilder.create("    ");
    public static final class_2561 OVERWORLD = TextBuilder.translate("carpet.command.dimension.overworld", new Object[0]);
    public static final class_2561 THE_NETHER = TextBuilder.translate("carpet.command.dimension.the_nether", new Object[0]);
    public static final class_2561 THE_END = TextBuilder.translate("carpet.command.dimension.the_end", new Object[0]);
    public static final class_2561 TRUE = TextBuilder.translate("carpet.command.boolean.true", new Object[0]);
    public static final class_2561 FALSE = TextBuilder.translate("carpet.command.boolean.false", new Object[0]);
    public static final class_2561 CLICK_HERE = TextBuilder.translate("carpet.command.text.click.here", new Object[0]);
    public static final class_2561 ITEM = TextBuilder.translate("carpet.command.item.item", new Object[0]);
    public static final class_2561 COPY_CLICK = class_2561.method_43471((String)"chat.copy.click");
    public static final class_2561 SELF = TextBuilder.translate("carpet.command.text.self", new Object[0]);

    private TextProvider() {
    }

    public static class_2561 getBoolean(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static class_2561 blockPos(class_2338 blockPos) {
        return TextProvider.blockPos(blockPos, class_124.field_1060);
    }

    public static class_2561 blockPos(class_2338 blockPos, @Nullable class_124 color) {
        TextBuilder builder = new TextBuilder(TextProvider.simpleBlockPos(blockPos));
        builder.setCopyToClipboard(WorldUtils.toPosString(blockPos));
        switch (CarpetOrgAdditionSettings.canHighlightBlockPos.get()) {
            case OMMC: {
                builder.append(new TextBuilder(" [H]").setCommand(CommandProvider.highlightWaypointByOmmc(blockPos)).setHover("ommc.highlight_waypoint.tooltip", new Object[0]));
                break;
            }
            case DEFAULT: {
                builder.append(new TextBuilder(" [H]").setCommand(CommandProvider.highlightWaypoint(blockPos)).setHover("carpet.client.commands.highlight", new Object[0]));
                break;
            }
        }
        builder.setColor(color);
        return builder.build();
    }

    public static class_2561 simpleBlockPos(class_2338 blockPos) {
        return class_2564.method_10885((class_2561)class_2561.method_43469((String)"chat.coordinates", (Object[])new Object[]{blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()}));
    }

    public static class_2561 dimensionBlockPos(class_1937 world, class_2338 blockPos) {
        return TextBuilder.translate("carpet.command.block_pos.dimension", TextProvider.dimension(world), TextProvider.simpleBlockPos(blockPos));
    }

    public static class_2561 clickInput(String command) {
        return TextBuilder.translate("carpet.command.text.click.input", command);
    }

    public static class_2561 clickRun(String command) {
        TextBuilder builder = new TextBuilder(CLICK_HERE);
        builder.setCommand(command);
        builder.setHover("carpet.command.text.click.run", command);
        builder.setColor(class_124.field_1075);
        return builder.build();
    }

    public static class_2561 itemCount(int count, int maxCount) {
        int group = count / maxCount;
        int remainder = count % maxCount;
        TextBuilder builder = new TextBuilder(count);
        if (group == 0) {
            builder.setHover("carpet.command.item.remainder", remainder);
        } else if (remainder == 0) {
            builder.setHover("carpet.command.item.group", group);
        } else {
            builder.setHover("carpet.command.item.count", group, remainder);
        }
        return builder.build();
    }

    public static class_2561 inventory(class_2561 base, class_1263 inventory) {
        TextBuilder builder = new TextBuilder(base);
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 itemStack = inventory.method_5438(i);
            if (itemStack.method_7960()) continue;
            list.add(TextBuilder.combineAll(itemStack.method_7964(), "*", String.valueOf(itemStack.method_7947())));
        }
        return builder.setHover(TextBuilder.joinList(list)).build();
    }

    public static class_2561 tickToTime(long tick) {
        if (tick < 20L) {
            return TextBuilder.translate("carpet.command.time.tick", tick);
        }
        if (tick < 1200L) {
            return TextBuilder.translate("carpet.command.time.second", tick / 20L);
        }
        if (tick < 72000L && (tick % 1200L == 0L || tick / 20L % 60L == 0L)) {
            return TextBuilder.translate("carpet.command.time.minute", tick / 1200L);
        }
        if (tick < 72000L) {
            return TextBuilder.translate("carpet.command.time.minute_second", tick / 1200L, tick / 20L % 60L);
        }
        if (tick % 72000L == 0L || tick / 20L / 60L % 60L == 0L) {
            return TextBuilder.translate("carpet.command.time.hour", tick / 72000L);
        }
        return TextBuilder.translate("carpet.command.time.hour_minute", tick / 72000L, tick / 20L / 60L % 60L);
    }

    public static class_2561 tickToRealTime(long offset) {
        LocalDateTime time = LocalDateTime.now().plusSeconds(offset / 20L);
        return TextBuilder.translate("carpet.command.time.format", time.getYear(), time.getMonth().ordinal() + 1, time.getDayOfMonth(), time.getHour(), time.getMinute(), time.getSecond());
    }

    public static class_2561 dimension(class_1937 world) {
        String dimension;
        return switch (dimension = WorldUtils.getDimensionId(world)) {
            case "minecraft:overworld" -> OVERWORLD;
            case "minecraft:the_nether" -> THE_NETHER;
            case "minecraft:the_end" -> THE_END;
            default -> TextBuilder.create(dimension);
        };
    }

    public static class_2561 dimension(String dimension) {
        return switch (dimension) {
            case "minecraft:overworld", "overworld" -> OVERWORLD;
            case "minecraft:the_nether", "the_nether" -> THE_NETHER;
            case "minecraft:the_end", "the_end" -> THE_END;
            default -> TextBuilder.create(dimension);
        };
    }
}

