/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.wheel.screen;

import carpet.patches.EntityPlayerMPFake;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1733;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.util.MathUtils;
import org.carpetorgaddition.wheel.inventory.ContainerComponentInventory;
import org.carpetorgaddition.wheel.screen.UnavailableSlotSyncInterface;

public class QuickShulkerScreenHandler
extends class_1733
implements UnavailableSlotSyncInterface {
    private final int shulkerSlotIndex;
    private final ContainerComponentInventory inventory;
    private final class_3222 player;
    private final Predicate<class_1657> predicate;
    private final class_1799 shulkerBox;

    public QuickShulkerScreenHandler(int syncId, class_1661 playerInventory, ContainerComponentInventory inventory, class_3222 player, Predicate<class_1657> predicate, class_1799 shulkerBox) {
        super(syncId, playerInventory, (class_1263)inventory);
        this.inventory = inventory;
        this.player = player;
        this.predicate = predicate;
        this.shulkerBox = shulkerBox;
        if (this.canUseQuickShulker()) {
            for (class_1735 slot : this.field_7761) {
                if (slot.method_7677() != shulkerBox) continue;
                this.shulkerSlotIndex = slot.field_7874;
                return;
            }
        } else {
            throw new IllegalStateException("Quick shulker box not enabled");
        }
        this.shulkerSlotIndex = -1;
    }

    public void method_7593(int slotIndex, int button, class_1713 actionType, class_1657 player) {
        if (MathUtils.isInRange(this.from(), this.to(), slotIndex)) {
            class_1799 cursorStack;
            if (button == 1 && (cursorStack = this.method_34255()).method_7909().method_31568()) {
                class_1799 remaining = this.inventory.method_5491(cursorStack);
                this.method_34254(remaining);
            }
            return;
        }
        super.method_7593(slotIndex, button, actionType, player);
    }

    public boolean method_7597(class_1657 player) {
        if (this.shulkerBox.method_7960()) {
            return false;
        }
        return this.canUseQuickShulker() && this.shulkerBox.method_7947() == 1 && this.predicate.test(player) && super.method_7597(player);
    }

    private boolean canUseQuickShulker() {
        return CarpetOrgAdditionSettings.quickShulker.get() != false || this.player instanceof EntityPlayerMPFake;
    }

    public void method_7609(class_1263 inventory) {
        super.method_7609(inventory);
    }

    @Override
    public int from() {
        return this.shulkerSlotIndex == -1 ? 0 : this.shulkerSlotIndex;
    }

    @Override
    public int to() {
        return this.shulkerSlotIndex;
    }

    public class_1799 getShulkerBox() {
        return this.shulkerBox;
    }
}

