/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.fakeplayer;

import carpet.fakes.ServerPlayerInterface;
import carpet.helpers.EntityPlayerActionPack;
import carpet.patches.EntityPlayerMPFake;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_13;
import net.minecraft.class_1308;
import net.minecraft.class_14;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1950;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.minecraft.class_8;
import net.minecraft.class_9;
import org.carpetorgaddition.periodic.fakeplayer.FakePlayerPathfinder;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.util.MathUtils;
import org.jetbrains.annotations.NotNull;

public class GeneralPathfinder
implements FakePlayerPathfinder {
    private final Supplier<EntityPlayerMPFake> fakePlayerSupplier;
    private final Supplier<Optional<class_2338>> target;
    private final ArrayList<class_243> nodes = new ArrayList();
    private int currentIndex;
    private int directTravelTime = 0;
    private int updateTime;
    private int sneakTime;
    private int pauseTime;
    private boolean noRoad = false;
    private class_2338 previous;
    private int retryCount;
    private static final int FOLLOW_RANGE = 48;

    public GeneralPathfinder(Supplier<@NotNull EntityPlayerMPFake> fakePlayerSupplier, Supplier<Optional<class_2338>> targetSupplier) {
        this.target = targetSupplier;
        this.fakePlayerSupplier = fakePlayerSupplier;
        this.pathfinding();
    }

    @Override
    public void tick() {
        boolean farAway;
        EntityPlayerActionPack actionPack = ((ServerPlayerInterface)this.getFakePlayer()).getActionPack();
        if (this.sneakTime > 0) {
            --this.sneakTime;
        }
        if (this.pauseTime > 0) {
            --this.pauseTime;
        }
        actionPack.setSneaking(this.sneakTime > 0);
        Optional<class_2338> optional = this.target.get();
        if (optional.isEmpty()) {
            if (this.isFinished()) {
                return;
            }
            this.stop();
            return;
        }
        class_2338 blockPos = optional.get();
        if (!Objects.equals(this.previous, blockPos)) {
            this.pathfinding();
            this.setValid();
        }
        this.previous = blockPos;
        class_243 pos = FetcherUtils.getFootPos((class_1297)this.getFakePlayer());
        --this.directTravelTime;
        if (this.updateTime > 0) {
            --this.updateTime;
        }
        boolean bl = farAway = blockPos.method_61082().method_1022(pos) > 1.5;
        if (this.updateTime == 0 && farAway) {
            this.noRoad = false;
            this.pathfinding();
            this.directTravelTime = 2;
        }
        if (this.isFinished()) {
            if (farAway) {
                if (this.noRoad) {
                    return;
                }
                this.pathfinding();
            }
            return;
        }
        class_243 current = this.getCurrentNode();
        boolean onGround = this.getFakePlayer().method_24828();
        if (onGround) {
            if (this.directTravelTime <= 0) {
                this.getFakePlayer().method_5702(class_2183.class_2184.field_9853, current);
            }
        } else if (this.getFakePlayer().method_18798().method_10214() < 0.0) {
            class_2338 offset;
            this.directTravelTime = 1;
            EntityPlayerMPFake fakePlayer = this.getFakePlayer();
            class_2350 direction = fakePlayer.method_5755();
            class_2338 down = fakePlayer.method_24515().method_10074();
            class_3218 world = FetcherUtils.getWorld((class_3222)fakePlayer);
            class_2680 blockState = world.method_8320(down);
            if ((blockState.method_26215() || blockState.method_26206((class_1922)world, down, class_2350.field_11036)) && !world.method_8320(offset = down.method_10093(direction)).method_26206((class_1922)world, offset, class_2350.field_11036)) {
                this.sneakTime = 3;
            }
        }
        if (this.arrivedAtAnyNode()) {
            return;
        }
        if (this.backToBeforeNode()) {
            ++this.retryCount;
        }
        actionPack.setForward(1.0f);
        if (onGround) {
            this.jump(current, pos);
        }
    }

    private void jump(class_243 current, class_243 pos) {
        double horizontal = MathUtils.horizontalDistance(current, pos);
        double vertical = MathUtils.verticalDistance(current, pos);
        if (vertical <= this.getFakePlayer().method_45325(class_5134.field_47761)) {
            return;
        }
        if (current.method_10214() < pos.method_10214()) {
            return;
        }
        if (horizontal < 1.0 && vertical < 1.25) {
            this.getFakePlayer().method_6043();
        }
    }

    @Override
    public double length() {
        if (this.nodes.size() <= 1) {
            return 0.0;
        }
        return this.nodes.getFirst().method_1022(this.nodes.getLast());
    }

    @Override
    public int getSyncEntityId() {
        return this.getFakePlayer().method_5628();
    }

    @Override
    public void pause(int time) {
        this.pauseTime = time;
        EntityPlayerActionPack actionPack = ((ServerPlayerInterface)this.getFakePlayer()).getActionPack();
        actionPack.setForward(0.0f);
    }

    @Override
    public void pathfinding() {
        class_243 pos;
        DummyEntity entity;
        ++this.retryCount;
        this.updateTime = 100;
        this.nodes.clear();
        this.currentIndex = 0;
        Optional<class_2338> optional = this.target.get();
        if (optional.isEmpty()) {
            return;
        }
        EntityPlayerMPFake fakePlayer = this.getFakePlayer();
        class_2338 blockPos = fakePlayer.method_24515();
        class_2338 from = blockPos.method_10069(-48, -48, -48);
        class_2338 to = blockPos.method_10069(48, 48, 48);
        class_14 maker = new class_14();
        class_13 navigator = new class_13((class_8)maker, 768);
        class_3218 world = FetcherUtils.getWorld((class_3222)fakePlayer);
        class_1950 chunkCache = new class_1950((class_1937)world, from, to);
        class_11 path = navigator.method_52(chunkCache, (class_1308)(entity = new DummyEntity((class_1937)world, pos = FetcherUtils.getFootPos((class_1297)fakePlayer))), Set.of(optional.get()), 48.0f, 0, 1.0f);
        if (path == null) {
            return;
        }
        for (int i = 0; i < path.method_38(); ++i) {
            class_9 node = path.method_40(i);
            this.nodes.add(node.method_22879().method_61082());
        }
        this.nodes.set(0, pos);
        this.onStart();
        if (this.length() < 1.0) {
            this.noRoad = true;
        }
    }

    @Override
    public class_243 getCurrentNode() {
        return this.nodes.get(this.currentIndex);
    }

    @Override
    public boolean arrivedAtAnyNode() {
        for (int i = this.currentIndex; i < this.nodes.size(); ++i) {
            class_243 pos;
            class_243 current = this.nodes.get(i);
            if (!(current.method_1022(pos = FetcherUtils.getFootPos((class_1297)this.getFakePlayer())) <= 0.5)) continue;
            if (i > 0) {
                this.setValid();
            }
            this.currentIndex = i + 1;
            if (this.isFinished()) {
                this.onStop();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean backToBeforeNode() {
        if (this.currentIndex <= 1) {
            return false;
        }
        for (int i = 0; i < this.currentIndex; ++i) {
            if (!(this.nodes.get(i).method_1022(FetcherUtils.getFootPos((class_1297)this.getFakePlayer())) < 0.5)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isFinished() {
        return this.currentIndex >= this.nodes.size();
    }

    @Override
    public List<class_243> getRenderNodes() {
        return this.nodes.stream().map(vec3d -> vec3d.method_1031(0.0, 0.1, 0.0)).toList();
    }

    @Override
    public void stop() {
        this.currentIndex = this.nodes.size();
        this.onStop();
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onStop() {
        EntityPlayerActionPack actionPack = ((ServerPlayerInterface)this.getFakePlayer()).getActionPack();
        actionPack.setForward(0.0f);
        actionPack.setSneaking(false);
    }

    @Override
    public boolean isInvalid() {
        if (this.isFinished()) {
            return true;
        }
        Optional<class_2338> optional = this.target.get();
        if (optional.isEmpty()) {
            return true;
        }
        return this.retryCount > 5;
    }

    private void setValid() {
        this.retryCount = 0;
    }

    @Override
    public boolean isInaccessible() {
        Optional<class_2338> optional = this.target.get();
        return optional.map(blockPos -> blockPos.equals((Object)class_2338.method_49638((class_2374)((class_2374)this.nodes.getLast())))).orElse(true) == false;
    }

    private EntityPlayerMPFake getFakePlayer() {
        return this.fakePlayerSupplier.get();
    }

    public static class DummyEntity
    extends class_1308 {
        protected DummyEntity(class_1937 world, class_243 pos) {
            super(class_1299.field_6077, world);
            this.method_33574(pos);
        }
    }
}

