/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.task.batch;

import carpet.patches.EntityPlayerMPFake;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.class_11560;
import net.minecraft.class_11561;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_4844;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.exception.TaskExecutionException;
import org.carpetorgaddition.periodic.task.ServerTask;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.util.GenericUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.wheel.CreateFakePlayerContext;
import org.carpetorgaddition.wheel.TextBuilder;

public class BatchSpawnFakePlayerTask
extends ServerTask {
    public static final ThreadLocal<Boolean> batchSpawnHiddenMessage = ThreadLocal.withInitial(() -> false);
    public static final ThreadLocal<Boolean> internalBatchSpawnHiddenMessage = ThreadLocal.withInitial(() -> false);
    private final Set<class_11560> players = ConcurrentHashMap.newKeySet();
    private final MinecraftServer server;
    private final String prefix;
    private final int start;
    private final int end;
    private final class_3222 player;
    private final CreateFakePlayerContext context;
    private final int count;
    private int prevCount = 0;
    private boolean isPreload = true;
    private Iterator<class_11560> iterator;
    private boolean complete = false;
    private final long startTime;
    private long startSpawnTime = -1L;

    public BatchSpawnFakePlayerTask(MinecraftServer server, class_11561 userCache, class_3222 player, String prefix, int start, int end, Consumer<EntityPlayerMPFake> consumer) {
        this.server = server;
        this.prefix = prefix;
        this.start = start;
        this.end = end;
        int count = end - start + 1;
        this.player = player;
        this.context = new CreateFakePlayerContext(player, consumer);
        class_3324 playerManager = server.method_3760();
        for (int i = start; i <= end; ++i) {
            String username = prefix + i;
            if (playerManager.method_14566(username) != null) {
                --count;
                continue;
            }
            Thread.ofVirtual().start(() -> {
                Optional optional = userCache.method_14515(username);
                class_11560 gameProfile = optional.orElseGet(() -> new class_11560(class_4844.method_43344((String)username), username));
                if (optional.isEmpty()) {
                    userCache.method_14508(gameProfile);
                }
                this.players.add(gameProfile);
            });
        }
        this.count = count;
        this.startTime = FetcherUtils.getWorld(player).method_8510();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tick() {
        int size = this.players.size();
        long time = FetcherUtils.getWorld(this.player).method_8510();
        if (this.isPreload) {
            boolean progress;
            boolean bl = progress = time - this.startTime > 10L;
            if (size < this.count) {
                if (progress && (this.prevCount != size || time % 40L == 0L)) {
                    this.prevCount = size;
                    class_2561 message = TextBuilder.translate("carpet.commands.playerManager.batch.preload", size, this.count);
                    MessageUtils.sendMessageToHud((class_1657)this.player, message);
                }
                return;
            }
            if (progress) {
                class_2561 message = TextBuilder.translate("carpet.commands.playerManager.batch.preload.done", new Object[0]);
                MessageUtils.sendMessageToHud((class_1657)this.player, message);
            }
            this.isPreload = false;
        }
        if (this.startSpawnTime == -1L) {
            this.startSpawnTime = System.currentTimeMillis();
        }
        if (System.currentTimeMillis() - this.startSpawnTime > 5000L) {
            this.timeout();
        }
        try {
            batchSpawnHiddenMessage.set(true);
            if (this.iterator == null) {
                this.iterator = this.players.iterator();
            }
            long l = System.currentTimeMillis();
            while (this.iterator.hasNext()) {
                if (System.currentTimeMillis() - l > 50L) {
                    return;
                }
                class_11560 entry = this.iterator.next();
                GenericUtils.createFakePlayer(entry.comp_4423(), this.server, this.context);
            }
        }
        finally {
            batchSpawnHiddenMessage.set(false);
        }
        if (CarpetOrgAdditionSettings.displayPlayerSummoner.get().booleanValue()) {
            class_2561 summoner = TextBuilder.translate("carpet.commands.playerManager.batch.summoner", this.player.method_5476(), this.prefix + this.start, this.prefix + this.end, this.count);
            MessageUtils.broadcastMessage(this.server, summoner);
        }
        this.complete = true;
    }

    private void timeout() {
        class_2168 source = this.player.method_64396();
        throw new TaskExecutionException(() -> MessageUtils.sendErrorMessage(source, "carpet.command.task.timeout", new Object[0]));
    }

    @Override
    protected boolean stopped() {
        return this.complete;
    }

    @Override
    public String getLogName() {
        return "\u73a9\u5bb6\u6279\u91cf\u751f\u6210";
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && (this == obj || this.getClass() == obj.getClass());
    }

    @Override
    public int hashCode() {
        return 1;
    }
}

