/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.wheel;

import carpet.patches.EntityPlayerMPFake;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.util.MathUtils;
import org.carpetorgaddition.wheel.BlockRegion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockEntityRegion
implements Iterable<class_2586> {
    private final class_1937 world;
    private final BlockRegion blockRegion;
    private final class_2338 from;
    private final class_2338 to;

    public BlockEntityRegion(class_1937 world, class_2338 sourcePos, int range) {
        this.world = world;
        int minX = sourcePos.method_10263() - Math.abs(range);
        int minY = world.method_31607();
        int minZ = sourcePos.method_10260() - Math.abs(range);
        int maxX = sourcePos.method_10263() + Math.abs(range);
        int maxY = world.method_31607() + world.method_31605();
        int maxZ = sourcePos.method_10260() + Math.abs(range);
        this.from = new class_2338(minX, minY, minZ);
        this.to = new class_2338(maxX, maxY, maxZ);
        this.blockRegion = new BlockRegion(this.from, this.to);
    }

    public BlockEntityRegion(class_1937 world, class_2338 from, class_2338 to) {
        this.world = world;
        this.from = MathUtils.toMinBlockPos(from, to);
        this.to = MathUtils.toMaxBlockPos(from, to);
        this.blockRegion = new BlockRegion(from, to);
    }

    public static BlockEntityRegion ofAbove(EntityPlayerMPFake fakePlayer, int range) {
        class_3218 world = FetcherUtils.getWorld((class_3222)fakePlayer);
        class_2338 blockPos = fakePlayer.method_24515();
        return BlockEntityRegion.ofAbove((class_1937)world, blockPos, range);
    }

    public static BlockEntityRegion ofAbove(class_1937 world, class_2338 blockPos, int range) {
        class_2338 from = new class_2338(blockPos.method_10263() - range, blockPos.method_10264(), blockPos.method_10260() - range);
        class_2338 to = new class_2338(blockPos.method_10263() + range, world.method_31607() + world.method_31605(), blockPos.method_10260() + range);
        return new BlockEntityRegion(world, from, to);
    }

    public <T extends class_1297> boolean contains(Class<T> type) {
        return !this.world.method_18467(type, this.toBox()).isEmpty();
    }

    @Override
    @NotNull
    public Iterator<class_2586> iterator() {
        return new Itr();
    }

    public class_238 toBox() {
        return this.blockRegion.toBox();
    }

    private class Itr
    implements Iterator<class_2586> {
        private class_2586 next;
        private Iterator<class_2586> current;
        private boolean alreadyNext = false;
        private final Iterator<class_2818> chunkIterator = this.createChunkIterator();

        private Itr() {
        }

        private Iterator<class_2818> createChunkIterator() {
            class_2818 minChunk = BlockEntityRegion.this.world.method_8500(BlockEntityRegion.this.from);
            class_2818 maxChunk = BlockEntityRegion.this.world.method_8500(BlockEntityRegion.this.to);
            final class_1923 minChunkPos = minChunk.method_12004();
            final class_1923 maxChunkPos = maxChunk.method_12004();
            return new Iterator<class_2818>(){
                private int currentX;
                private int currentZ;
                {
                    this.currentX = minChunkPos.field_9181;
                    this.currentZ = minChunkPos.field_9180;
                }

                @Override
                public boolean hasNext() {
                    return this.currentZ <= maxChunkPos.field_9180;
                }

                @Override
                @Nullable
                public class_2818 next() {
                    if (this.hasNext()) {
                        class_2818 worldChunk;
                        class_2791 chunk = BlockEntityRegion.this.world.method_8402(this.currentX, this.currentZ, class_2806.field_12803, false);
                        ++this.currentX;
                        if (this.currentX > maxChunkPos.field_9181) {
                            this.currentX = minChunkPos.field_9181;
                            ++this.currentZ;
                        }
                        return chunk instanceof class_2818 ? (worldChunk = (class_2818)chunk) : null;
                    }
                    throw new NoSuchElementException();
                }
            };
        }

        @Override
        public boolean hasNext() {
            if (this.alreadyNext) {
                return this.next != null;
            }
            this.alreadyNext = true;
            while (this.current != null || this.chunkIterator.hasNext()) {
                if (this.current == null) {
                    class_2818 worldChunk = this.chunkIterator.next();
                    if (worldChunk == null) continue;
                    this.current = worldChunk.method_12214().values().iterator();
                }
                while (this.current.hasNext()) {
                    class_2586 blockEntity = this.current.next();
                    if (!BlockEntityRegion.this.blockRegion.contains(blockEntity.method_11016())) continue;
                    this.next = blockEntity;
                    return true;
                }
                this.current = null;
            }
            return false;
        }

        @Override
        public class_2586 next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.alreadyNext = false;
            class_2586 blockEntity = this.next;
            this.next = null;
            return blockEntity;
        }
    }
}

