/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.client.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1887;
import net.minecraft.class_1928;
import net.minecraft.class_1934;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_7157;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.carpetorgaddition.client.command.AbstractClientCommand;
import org.carpetorgaddition.client.command.argument.ClientObjectArgumentType;
import org.carpetorgaddition.client.util.ClientMessageUtils;
import org.carpetorgaddition.client.util.ClientUtils;
import org.carpetorgaddition.util.EnchantmentUtils;
import org.carpetorgaddition.wheel.TextBuilder;
import org.carpetorgaddition.wheel.provider.TextProvider;
import org.jetbrains.annotations.NotNull;

public class DictionaryCommand
extends AbstractClientCommand {
    public static final String DEFAULT_COMMAND_NAME = "dictionary";

    public DictionaryCommand(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 access) {
        super(dispatcher, access);
    }

    @Override
    public void register(String name) {
        LiteralArgumentBuilder builder = ClientCommandManager.literal((String)name);
        for (DictionaryType value : DictionaryType.values()) {
            builder.then(ClientCommandManager.literal((String)value.name).then(ClientCommandManager.argument((String)value.name, value.getArgumentType()).executes(context -> this.getId((CommandContext<FabricClientCommandSource>)context, value))));
        }
        this.dispatcher.register(builder);
    }

    private int getId(CommandContext<FabricClientCommandSource> context, DictionaryType type) {
        List<?> list = ClientObjectArgumentType.getType(context, type.name);
        if (list.size() == 1) {
            Object t = list.getFirst();
            String id = type.id(t);
            this.sendFeedback(type.name(t), id);
        } else {
            this.sendFeedback(list.size());
            for (Object t : list) {
                this.sendFeedback(type.id(t));
            }
        }
        return list.size();
    }

    private void sendFeedback(class_2561 text, String id) {
        ClientMessageUtils.sendMessage("carpet.client.commands.dictionary.id", text, this.canCopyId(id));
    }

    private void sendFeedback(int count) {
        ClientMessageUtils.sendMessage("carpet.client.commands.dictionary.multiple.id", count);
    }

    private void sendFeedback(String id) {
        ClientMessageUtils.sendMessage("carpet.client.commands.dictionary.multiple.each", this.canCopyId(id));
    }

    @NotNull
    private class_2561 canCopyId(String id) {
        return new TextBuilder(id).setCopyToClipboard(id).setHover(TextProvider.COPY_CLICK).setColor(class_124.field_1060).build();
    }

    @Override
    public String getDefaultName() {
        return DEFAULT_COMMAND_NAME;
    }

    public static enum DictionaryType {
        ITEM("item"),
        BLOCK("block"),
        ENTITY("entity"),
        ENCHANTMENT("enchant"),
        STATUS_EFFECT("effect"),
        BIOME("biome"),
        GAME_MODE("gamemode"),
        GAME_RULE("gamerule");

        private final String name;

        private DictionaryType(String name) {
            this.name = name;
        }

        private String id(Object obj) {
            class_746 player = ClientUtils.getPlayer();
            class_5455.class_6890 registry = player.field_3944.method_29091();
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> class_7923.field_41178.method_10221((Object)((class_1792)obj)).toString();
                case 1 -> class_7923.field_41175.method_10221((Object)((class_2248)obj)).toString();
                case 2 -> class_7923.field_41177.method_10221((Object)((class_1299)obj)).toString();
                case 3 -> {
                    class_2960 id = registry.method_30530(class_7924.field_41265).method_10221((Object)((class_1887)obj));
                    yield Objects.requireNonNull(id, "Unable to obtain enchantment id").toString();
                }
                case 4 -> {
                    class_2960 id = registry.method_30530(class_7924.field_41208).method_10221((Object)((class_1291)obj));
                    yield Objects.requireNonNull(id, "Unable to obtain status effect id").toString();
                }
                case 5 -> {
                    class_2960 id = registry.method_30530(class_7924.field_41236).method_10221((Object)((class_1959)obj));
                    yield Objects.requireNonNull(id, "Unable to obtain biome id").toString();
                }
                case 6 -> ((class_1934)obj).method_15434();
                case 7 -> ((class_1928.class_4313)obj).method_20771();
            };
        }

        private class_2561 name(Object obj) {
            class_746 player = ClientUtils.getPlayer();
            class_5455.class_6890 registry = player.field_3944.method_29091();
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> ((class_1792)obj).method_63680();
                case 1 -> ((class_2248)obj).method_9518();
                case 2 -> ((class_1299)obj).method_5897();
                case 3 -> EnchantmentUtils.getName((class_1887)obj);
                case 4 -> ((class_1291)obj).method_5560();
                case 5 -> {
                    class_2960 id = Objects.requireNonNull(registry.method_30530(class_7924.field_41236).method_10221((Object)((class_1959)obj)), "Unable to obtain biome id");
                    String key = id.method_42093("biome");
                    yield TextBuilder.translate(key, new Object[0]);
                }
                case 6 -> ((class_1934)obj).method_8383();
                case 7 -> TextBuilder.translate(((class_1928.class_4313)obj).method_27334(), new Object[0]);
            };
        }

        private ArgumentType<?> getArgumentType() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> new ClientObjectArgumentType.ClientItemArgumentType();
                case 1 -> new ClientObjectArgumentType.ClientBlockArgumentType();
                case 2 -> new ClientObjectArgumentType.ClientEntityArgumentType();
                case 3 -> new ClientObjectArgumentType.ClientEnchantmentArgumentType();
                case 4 -> new ClientObjectArgumentType.ClientStatusEffectArgumentType();
                case 5 -> new ClientObjectArgumentType.ClientBiomeArgumentType();
                case 6 -> new ClientObjectArgumentType.ClientGameModeArgumentType();
                case 7 -> new ClientObjectArgumentType.ClientGameRuleArgumentType();
            };
        }
    }
}

