/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.config.AbstractConfig;
import org.carpetorgaddition.config.CustomCommandConfig;
import org.carpetorgaddition.util.IOUtils;

public class GlobalConfigs {
    private static final File CONFIG_FILE = IOUtils.CONFIGURE_DIRECTORY.resolve("carpet-org-addition.json").toFile();
    private static final String ENABLE_HIDDEN_FUNCTION = "enableHiddenFunction";
    private static final HashSet<AbstractConfig<?>> CONFIGURATIONS = new HashSet();
    public static final CustomCommandConfig CUSTOM_COMMAND_NAMES = GlobalConfigs.register(new CustomCommandConfig());
    private static boolean updateRequired = false;

    public static void init() {
        if (CONFIG_FILE.isFile()) {
            return;
        }
        CarpetOrgAddition.LOGGER.info("Initializing configuration file");
        try {
            JsonObject json = new JsonObject();
            json.addProperty("data_version", (Number)2);
            IOUtils.write(CONFIG_FILE, json);
        }
        catch (IOException e) {
            IOUtils.loggerError(e);
        }
    }

    public static boolean isEnableHiddenFunction() {
        try {
            JsonObject json = IOUtils.loadJson(CONFIG_FILE);
            return json.has(ENABLE_HIDDEN_FUNCTION) && json.get(ENABLE_HIDDEN_FUNCTION).getAsBoolean();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void save() {
        try {
            JsonObject json = IOUtils.loadJson(CONFIG_FILE);
            for (AbstractConfig<?> configuration : CONFIGURATIONS) {
                json.add(configuration.getKey(), configuration.getJsonValue());
            }
            IOUtils.write(CONFIG_FILE, json);
        }
        catch (IOException e) {
            CarpetOrgAddition.LOGGER.error("An unexpected error occurred while saving the global configuration file for {}", (Object)CarpetOrgAddition.MOD_NAME, (Object)e);
        }
        updateRequired = false;
    }

    public static void markUpdateRequired() {
        updateRequired = true;
    }

    public static <E extends JsonElement, C extends AbstractConfig<E>> void load(C config) {
        JsonObject json;
        try {
            json = IOUtils.loadJson(CONFIG_FILE);
        }
        catch (IOException e) {
            IOUtils.loggerError(e);
            return;
        }
        JsonElement element = json.get(config.getKey());
        try {
            config.load((JsonElement)element);
        }
        catch (RuntimeException e) {
            IOUtils.backupFile(CONFIG_FILE);
            json.add(config.getKey(), config.getJsonValue());
            GlobalConfigs.markUpdateRequired();
            CarpetOrgAddition.LOGGER.warn("Global config partially corrupted - resetting damaged section", (Throwable)e);
        }
    }

    private static <E extends JsonElement, C extends AbstractConfig<E>> C register(C config) {
        CONFIGURATIONS.add(config);
        GlobalConfigs.load(config);
        if (updateRequired) {
            GlobalConfigs.save();
        }
        return config;
    }
}

