/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.mixin.rule.shulkerboxstackable;

import carpet.CarpetSettings;
import carpet.utils.WoolTool;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.class_1263;
import net.minecraft.class_1542;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2377;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2614;
import net.minecraft.class_2615;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.rule.RuleUtils;
import org.carpetorgaddition.util.InventoryUtils;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2614.class})
public abstract class HopperBlockEntityMixin
extends class_2586 {
    @Shadow
    private class_2350 field_49101;

    public HopperBlockEntityMixin(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Shadow
    private static boolean method_11258(class_1263 inventory, class_2350 direction) {
        return false;
    }

    @Shadow
    @Nullable
    private static class_1263 method_11255(class_1937 world, class_2338 pos, class_2614 blockEntity) {
        return null;
    }

    @Shadow
    public static class_1799 method_11260(@Nullable class_1263 from, class_1263 to, class_1799 stack, @Nullable class_2350 side) {
        throw new AssertionError();
    }

    @Shadow
    @Nullable
    private static class_1263 method_11248(class_1937 world, class_2615 hopper, class_2338 pos, class_2680 state) {
        return null;
    }

    @Shadow
    private static int[] method_17767(class_1263 inventory, class_2350 side) {
        return new int[0];
    }

    @Shadow
    private static boolean method_11261(class_2615 hopper, class_1263 inventory, int slot, class_2350 side) {
        return false;
    }

    @Shadow
    public static List<class_1542> method_11237(class_1937 world, class_2615 hopper) {
        return List.of();
    }

    @Shadow
    public static boolean method_11247(class_1263 inventory, class_1542 itemEntity) {
        return false;
    }

    @Shadow
    private static boolean method_11246(class_1937 world, class_2338 pos, class_2614 blockEntity) {
        return false;
    }

    @Shadow
    protected abstract boolean method_11239();

    @Shadow
    protected abstract boolean method_11256();

    @Shadow
    protected abstract void method_11238(int var1);

    @WrapOperation(method={"serverTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/block/entity/HopperBlockEntity;insertAndExtract(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/block/entity/HopperBlockEntity;Ljava/util/function/BooleanSupplier;)Z")})
    private static boolean insert(class_1937 world, class_2338 pos, class_2680 state, class_2614 blockEntity, BooleanSupplier booleanSupplier, Operation<Boolean> original) {
        if (CarpetOrgAddition.LITHIUM) {
            return (Boolean)original.call(new Object[]{world, pos, state, blockEntity, booleanSupplier});
        }
        return RuleUtils.shulkerBoxStackableWrap(() -> (Boolean)original.call(new Object[]{world, pos, state, blockEntity, booleanSupplier}));
    }

    @WrapOperation(method={"onEntityCollided"}, at={@At(value="INVOKE", target="Lnet/minecraft/block/entity/HopperBlockEntity;insertAndExtract(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/block/entity/HopperBlockEntity;Ljava/util/function/BooleanSupplier;)Z")})
    private static boolean onEntityCollided(class_1937 world, class_2338 pos, class_2680 state, class_2614 blockEntity, BooleanSupplier booleanSupplier, Operation<Boolean> original) {
        if (CarpetOrgAddition.LITHIUM) {
            return (Boolean)original.call(new Object[]{world, pos, state, blockEntity, booleanSupplier});
        }
        return RuleUtils.shulkerBoxStackableWrap(() -> (Boolean)original.call(new Object[]{world, pos, state, blockEntity, booleanSupplier}));
    }

    @WrapOperation(method={"extract(Lnet/minecraft/inventory/Inventory;Lnet/minecraft/entity/ItemEntity;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/block/entity/HopperBlockEntity;transfer(Lnet/minecraft/inventory/Inventory;Lnet/minecraft/inventory/Inventory;Lnet/minecraft/item/ItemStack;Lnet/minecraft/util/math/Direction;)Lnet/minecraft/item/ItemStack;")})
    private static class_1799 extract(class_1263 from, class_1263 to, class_1799 stack, class_2350 side, Operation<class_1799> original, @Local LocalBooleanRef bl) {
        if (CarpetOrgAdditionSettings.shulkerBoxStackCountChanged.get().booleanValue()) {
            return (class_1799)original.call(new Object[]{from, to, stack, side});
        }
        if (CarpetOrgAdditionSettings.shulkerBoxStackable.get().booleanValue() && InventoryUtils.isShulkerBoxItem(stack)) {
            class_1799 split = stack.method_7971(stack.method_7914());
            int count = split.method_7947();
            class_1799 result = (class_1799)original.call(new Object[]{from, to, split.method_7972(), side});
            stack.method_7933(result.method_7947());
            if (count != result.method_7947()) {
                bl.set(true);
            }
            return stack;
        }
        return (class_1799)original.call(new Object[]{from, to, stack, side});
    }

    @Unique
    private static void compatible(Runnable runnable) {
        if (CarpetOrgAdditionSettings.shulkerBoxStackable.get().booleanValue() && CarpetOrgAddition.LITHIUM) {
            boolean changed = CarpetOrgAdditionSettings.shulkerBoxStackCountChanged.get();
            try {
                CarpetOrgAdditionSettings.shulkerBoxStackCountChanged.set(false);
                runnable.run();
            }
            finally {
                CarpetOrgAdditionSettings.shulkerBoxStackCountChanged.set(changed);
            }
        }
    }

    @Inject(method={"insertAndExtract"}, at={@At(value="HEAD")}, cancellable=true)
    private static void insertAndExtract(class_1937 world, class_2338 pos, class_2680 state, class_2614 blockEntity, BooleanSupplier booleanSupplier, CallbackInfoReturnable<Boolean> cir) {
        HopperBlockEntityMixin.compatible(() -> cir.setReturnValue((Object)HopperBlockEntityMixin.tryInsertAndExtract(world, pos, state, blockEntity, booleanSupplier)));
    }

    @Inject(method={"insert"}, at={@At(value="HEAD")}, cancellable=true)
    private static void insert(class_1937 world, class_2338 pos, class_2614 blockEntity, CallbackInfoReturnable<Boolean> cir) {
        HopperBlockEntityMixin.compatible(() -> cir.setReturnValue((Object)HopperBlockEntityMixin.tryInsert(world, pos, blockEntity)));
    }

    @Inject(method={"extract(Lnet/minecraft/world/World;Lnet/minecraft/block/entity/Hopper;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private static void extract(class_1937 world, class_2615 hopper, CallbackInfoReturnable<Boolean> cir) {
        HopperBlockEntityMixin.compatible(() -> cir.setReturnValue((Object)HopperBlockEntityMixin.tryExtract(world, hopper)));
    }

    @Unique
    private static boolean tryInsertAndExtract(class_1937 world, class_2338 pos, class_2680 state, class_2614 blockEntity, BooleanSupplier booleanSupplier) {
        if (world.method_8608()) {
            return false;
        }
        HopperBlockEntityMixin mixin = (HopperBlockEntityMixin)blockEntity;
        if (!mixin.method_11239() && ((Boolean)state.method_11654((class_2769)class_2377.field_11126)).booleanValue()) {
            boolean bl = false;
            if (!blockEntity.method_5442()) {
                bl = HopperBlockEntityMixin.method_11246(world, pos, blockEntity);
            }
            if (!mixin.method_11256()) {
                bl |= booleanSupplier.getAsBoolean();
            }
            if (bl) {
                mixin.method_11238(8);
                HopperBlockEntityMixin.hopperCountersUnlimitedSpeed(world, pos, blockEntity, booleanSupplier);
                HopperBlockEntityMixin.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
                return true;
            }
        }
        return false;
    }

    @Unique
    private static boolean tryInsert(class_1937 world, class_2338 pos, class_2614 blockEntity) {
        class_1263 inventory = HopperBlockEntityMixin.method_11255(world, pos, blockEntity);
        if (inventory == null) {
            return false;
        }
        class_2350 direction = ((HopperBlockEntityMixin)blockEntity).field_49101.method_10153();
        if (HopperBlockEntityMixin.method_11258(inventory, direction)) {
            return false;
        }
        for (int i = 0; i < blockEntity.method_5439(); ++i) {
            class_1799 itemStack = blockEntity.method_5438(i);
            if (itemStack.method_7960()) continue;
            int prevCount = itemStack.method_7947();
            class_1799 itemStack2 = HopperBlockEntityMixin.method_11260((class_1263)blockEntity, inventory, blockEntity.method_5434(i, 1), direction);
            if (itemStack2.method_7960()) {
                inventory.method_5431();
                HopperBlockEntityMixin.hopperNoItemCost(world, pos, blockEntity, i, itemStack, prevCount);
                return true;
            }
            itemStack.method_7939(prevCount);
            if (prevCount != 1) continue;
            blockEntity.method_5447(i, itemStack);
        }
        return false;
    }

    @Unique
    private static void hopperCountersUnlimitedSpeed(class_1937 world, class_2338 blockPos, class_2614 blockEntity, BooleanSupplier supplier) {
        if (CarpetSettings.hopperCounters && RuleUtils.hopperCountersUnlimitedSpeed.get().booleanValue()) {
            class_2350 direction = (class_2350)blockEntity.method_11010().method_11654((class_2769)class_2377.field_11129);
            class_1767 color = WoolTool.getWoolColorAtPosition((class_1937)world, (class_2338)blockPos.method_10093(direction));
            if (color == null) {
                return;
            }
            HopperBlockEntityMixin mixin = (HopperBlockEntityMixin)blockEntity;
            for (int i = 32766; i >= 0; --i) {
                boolean flag = false;
                if (!blockEntity.method_5442()) {
                    flag = HopperBlockEntityMixin.method_11246(world, blockPos, blockEntity);
                }
                if (!mixin.method_11256()) {
                    flag |= supplier.getAsBoolean();
                }
                if (!flag) break;
                if (i != 0) continue;
                CarpetOrgAddition.LOGGER.warn("Hopper at {} exceeded hopperCountersUnlimitedSpeed operation limit {}", (Object)blockEntity, (Object)Short.MAX_VALUE);
            }
            mixin.method_11238(0);
        }
    }

    @Unique
    private static void hopperNoItemCost(class_1937 world, class_2338 blockPos, class_2614 blockEntity, int index, class_1799 itemStack, int prevCount) {
        if (RuleUtils.hopperNoItemCost.get().booleanValue()) {
            class_1767 color = WoolTool.getWoolColorAtPosition((class_1937)world, (class_2338)blockPos.method_10093(class_2350.field_11036));
            if (color == null) {
                return;
            }
            int currentCount = itemStack.method_7947();
            itemStack.method_7939(prevCount);
            class_1799 prevStack = itemStack.method_7972();
            itemStack.method_7939(currentCount);
            blockEntity.method_5447(index, prevStack);
        }
    }

    @Unique
    private static boolean tryExtract(class_1937 world, class_2615 hopper) {
        block3: {
            boolean bl;
            class_2680 blockState;
            class_2338 blockPos;
            block2: {
                int[] var11;
                blockPos = class_2338.method_49637((double)hopper.method_11266(), (double)(hopper.method_11264() + 1.0), (double)hopper.method_11265());
                class_1263 inventory = HopperBlockEntityMixin.method_11248(world, hopper, blockPos, blockState = world.method_8320(blockPos));
                if (inventory == null) break block2;
                class_2350 direction = class_2350.field_11033;
                for (int i : var11 = HopperBlockEntityMixin.method_17767(inventory, direction)) {
                    if (!HopperBlockEntityMixin.method_11261(hopper, inventory, i, direction)) continue;
                    return true;
                }
                break block3;
            }
            boolean bl2 = bl = hopper.method_57081() && blockState.method_26234((class_1922)world, blockPos) && !blockState.method_26164(class_3481.field_49147);
            if (bl) break block3;
            for (class_1542 itemEntity : HopperBlockEntityMixin.method_11237(world, hopper)) {
                if (!HopperBlockEntityMixin.method_11247((class_1263)hopper, itemEntity)) continue;
                return true;
            }
        }
        return false;
    }
}

