/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.fakeplayer.action;

import carpet.patches.EntityPlayerMPFake;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1766;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1829;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2202;
import net.minecraft.class_2211;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_8171;
import net.minecraft.class_8237;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.periodic.fakeplayer.BlockExcavator;
import org.carpetorgaddition.periodic.fakeplayer.FakePlayerUtils;
import org.carpetorgaddition.periodic.fakeplayer.action.AbstractPlayerAction;
import org.carpetorgaddition.periodic.fakeplayer.action.ActionSerializeType;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.wheel.BlockIterator;
import org.carpetorgaddition.wheel.TextBuilder;

public class PlantAction
extends AbstractPlayerAction {
    private class_2338 cropPos;

    public PlantAction(EntityPlayerMPFake fakePlayer) {
        super(fakePlayer);
    }

    @Override
    protected void tick() {
        if (CarpetOrgAddition.ENABLE_HIDDEN_FUNCTION) {
            if (this.cropPos != null && !this.breakBlock(this.cropPos)) {
                return;
            }
            class_1799 cropsItem = this.getFakePlayer().method_6079();
            FarmType farmType = FarmType.getFarmType(cropsItem);
            if (farmType == FarmType.NONE) {
                return;
            }
            double range = this.getFakePlayer().method_55754();
            class_238 box = new class_238(this.getFakePlayer().method_24515()).method_1014(Math.min(range, 10.0));
            BlockIterator area = new BlockIterator(box);
            for (class_2338 blockPos : area) {
                if (!this.getFakePlayer().method_56093(blockPos, 0.0) || this.tryPlanting(blockPos, farmType, cropsItem)) continue;
            }
        }
    }

    private boolean tryPlanting(class_2338 blockPos, FarmType farmType, class_1799 cropsItem) {
        return switch (farmType.ordinal()) {
            case 0 -> this.plantingCrops(cropsItem, blockPos);
            case 1 -> this.plantingBamboo(blockPos);
            default -> true;
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean plantingCrops(class_1799 itemStack, class_2338 blockPos) {
        class_2248 block;
        class_3218 world = FetcherUtils.getWorld((class_3222)this.getFakePlayer());
        if (!world.method_8320(blockPos).method_27852(class_2246.field_10362)) {
            return true;
        }
        class_1723 screenHandler = this.getFakePlayer().field_7498;
        boolean thereAreManySeeds = true;
        if (itemStack.method_7947() <= 1 && !this.getFakePlayer().method_7337()) {
            Predicate<class_1799> predicate = stack -> class_1799.method_31577((class_1799)itemStack, (class_1799)stack);
            thereAreManySeeds = this.replenishment(screenHandler.field_7761.size() - 1, predicate);
        }
        class_2338 upPos = blockPos.method_10084();
        class_2680 blockState = world.method_8320(upPos);
        if (thereAreManySeeds && blockState.method_26215()) {
            this.planting((class_1937)world, itemStack, blockPos, upPos);
        }
        if ((block = blockState.method_26204()) instanceof class_2302) {
            class_2302 cropBlock = (class_2302)block;
            if (cropBlock.method_9825(blockState) && !(cropBlock instanceof class_8171)) {
                return this.breakBlock(upPos);
            }
            this.fertilize((class_1937)world, upPos);
            return true;
        } else if (block instanceof class_8237) {
            class_8237 pitcherCropBlock = (class_8237)block;
            if (!pitcherCropBlock.method_9651((class_4538)world, upPos, blockState)) return this.breakBlock(upPos);
            this.fertilize((class_1937)world, upPos);
            return true;
        } else {
            if (block != class_2246.field_42734) return true;
            return this.breakBlock(upPos);
        }
    }

    private boolean plantingBamboo(class_2338 plantablePos) {
        class_3218 world = FetcherUtils.getWorld((class_3222)this.getFakePlayer());
        if (!world.method_8320(plantablePos).method_26164(class_3481.field_15497) || world.method_8320(plantablePos).method_27852(class_2246.field_10211) || world.method_8320(plantablePos).method_27852(class_2246.field_10108)) {
            return true;
        }
        if (!(world.method_8320(plantablePos.method_10084()).method_26215() || world.method_8320(plantablePos.method_10084()).method_27852(class_2246.field_10211) || world.method_8320(plantablePos.method_10084()).method_27852(class_2246.field_10108))) {
            return true;
        }
        class_2338 bambooPos = plantablePos.method_10084();
        class_2680 blockState = world.method_8320(bambooPos);
        if (blockState.method_26215()) {
            return true;
        }
        class_2248 block = blockState.method_26204();
        if (block instanceof class_2202 && world.method_8320(bambooPos.method_10084()).method_26215()) {
            this.fertilize((class_1937)world, bambooPos);
        } else if (block instanceof class_2211) {
            class_2211 bambooBlock = (class_2211)block;
            if (bambooBlock.method_9651((class_4538)world, bambooPos, blockState)) {
                int airCount = 0;
                boolean hasAir = false;
                for (int height = 2; height <= 16; ++height) {
                    class_2680 tempBlockState = world.method_8320(plantablePos.method_10086(height));
                    if (tempBlockState.method_26215()) {
                        hasAir = true;
                        ++airCount;
                    } else if (!tempBlockState.method_27852(class_2246.field_10211)) break;
                    if (hasAir) {
                        if (airCount >= 3) {
                            this.fertilize((class_1937)world, bambooPos);
                            break;
                        }
                        if (tempBlockState.method_27852(class_2246.field_10211)) break;
                    }
                    if (height != 16) continue;
                    this.fertilize((class_1937)world, bambooPos);
                }
            } else {
                return this.useToolBreakBlock(bambooPos.method_10084());
            }
        }
        return true;
    }

    private void planting(class_1937 world, class_1799 itemStack, class_2338 blockPos, class_2338 lookPos) {
        this.getFakePlayer().method_5702(class_2183.class_2184.field_9851, lookPos.method_46558());
        class_3965 hitResult = new class_3965(blockPos.method_46558(), class_2350.field_11036, lookPos, false);
        this.getFakePlayer().field_13974.method_14262((class_3222)this.getFakePlayer(), world, itemStack, class_1268.field_5810, hitResult);
        this.getFakePlayer().method_23667(class_1268.field_5810, true);
    }

    private void fertilize(class_1937 world, class_2338 upPos) {
        class_1799 itemStack;
        Predicate<class_1799> predicate = stack -> stack.method_31574(class_1802.field_8324);
        if (FakePlayerUtils.replenishment(this.getFakePlayer(), predicate) && ((itemStack = this.getFakePlayer().method_6047()).method_7947() > 1 || this.getFakePlayer().method_7337() || this.replenishment(this.getFakePlayer().method_31548().field_7545 + 36, predicate))) {
            class_243 centerPos = upPos.method_46558();
            this.getFakePlayer().method_5702(class_2183.class_2184.field_9851, centerPos);
            class_3965 hitResult = new class_3965(centerPos, class_2350.field_11033, upPos, true);
            this.getFakePlayer().field_13974.method_14262((class_3222)this.getFakePlayer(), world, itemStack, class_1268.field_5808, hitResult);
            this.getFakePlayer().method_23667(class_1268.field_5808, true);
        }
    }

    private boolean breakBlock(class_2338 pos) {
        BlockExcavator blockExcavator = FetcherUtils.getBlockExcavator(this.getFakePlayer());
        boolean breakBlock = blockExcavator.mining(pos, class_2350.field_11033, !this.getFakePlayer().method_7337());
        this.cropPos = breakBlock ? null : pos;
        return breakBlock;
    }

    private boolean useToolBreakBlock(class_2338 pos) {
        FakePlayerUtils.replenishment(this.getFakePlayer(), itemStack -> itemStack.method_7909() instanceof class_1829 || itemStack.method_7909() instanceof class_1766);
        BlockExcavator blockExcavator = FetcherUtils.getBlockExcavator(this.getFakePlayer());
        boolean breakBlock = blockExcavator.mining(pos, class_2350.field_11033);
        this.cropPos = breakBlock ? null : pos;
        return breakBlock;
    }

    private boolean replenishment(int slotIndex, Predicate<class_1799> predicate) {
        class_1723 screenHandler = this.getFakePlayer().field_7498;
        class_2371 slots = screenHandler.field_7761;
        for (int index = 5; index < slots.size() - 1; ++index) {
            class_1799 itemStack;
            if (index == slotIndex || !predicate.test(itemStack = ((class_1735)slots.get(index)).method_7677())) continue;
            if (itemStack.method_7947() == itemStack.method_7914()) {
                FakePlayerUtils.pickupAndMoveHalfItemStack((class_1703)screenHandler, index, slotIndex, this.getFakePlayer());
            } else {
                FakePlayerUtils.pickupAndMoveItemStack((class_1703)screenHandler, index, slotIndex, this.getFakePlayer());
            }
            return true;
        }
        return false;
    }

    @Override
    public ArrayList<class_2561> info() {
        return Lists.newArrayList((Object[])new class_2561[]{TextBuilder.translate("carpet.commands.playerAction.info.farm", this.getFakePlayer().method_5476())});
    }

    @Override
    public JsonObject toJson() {
        return new JsonObject();
    }

    @Override
    public class_2561 getDisplayName() {
        return TextBuilder.translate("carpet.commands.playerAction.action.farm", new Object[0]);
    }

    @Override
    public ActionSerializeType getActionSerializeType() {
        return ActionSerializeType.PLANT;
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    public static enum FarmType {
        CROPS,
        BAMBOO,
        NONE;


        public static FarmType getFarmType(class_1799 itemStack) {
            if (itemStack.method_7960()) {
                return NONE;
            }
            if (itemStack.method_31574(class_1802.field_8317) || itemStack.method_31574(class_1802.field_8567) || itemStack.method_31574(class_1802.field_8179) || itemStack.method_31574(class_1802.field_8309) || itemStack.method_31574(class_1802.field_42711) || itemStack.method_31574(class_1802.field_43195)) {
                return CROPS;
            }
            if (itemStack.method_31574(class_1802.field_8648)) {
                return BAMBOO;
            }
            return NONE;
        }
    }
}

