/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.util;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;

public class MathUtils {
    private static final Random RANDOM = new Random();
    public static final class_2350[] HORIZONTAL = (class_2350[])Arrays.stream(class_2350.values()).filter(direction -> direction.method_10166().method_10179()).toArray(class_2350[]::new);

    private MathUtils() {
    }

    public static double getBlockSquareDistance(class_2338 fromBlockPos, class_2338 toBlockPos) {
        double x = fromBlockPos.method_10263() - toBlockPos.method_10263();
        double y = fromBlockPos.method_10264() - toBlockPos.method_10264();
        double z = fromBlockPos.method_10260() - toBlockPos.method_10260();
        return x * x + y * y + z * z;
    }

    public static double getBlockDistance(class_2338 fromBlockPos, class_2338 toBlockPos) {
        return Math.sqrt(MathUtils.getBlockSquareDistance(fromBlockPos, toBlockPos));
    }

    public static int getBlockIntegerDistance(class_2338 fromBlockPos, class_2338 toBlockPos) {
        return (int)Math.round(Math.sqrt(MathUtils.getBlockSquareDistance(fromBlockPos, toBlockPos)));
    }

    public static int getCalculateBlockIntegerDistance(class_2338 fromBlockPos, class_2338 toBlockPos) {
        double x = fromBlockPos.method_10263() - toBlockPos.method_10263();
        double z = fromBlockPos.method_10260() - toBlockPos.method_10260();
        return (int)Math.round(Math.sqrt(x * x + z * z));
    }

    public static int calculateManhattanDistance(class_2338 start, class_2338 end) {
        int x = start.method_10263() - end.method_10263();
        int y = start.method_10264() - end.method_10264();
        int z = start.method_10260() - end.method_10260();
        return Math.abs(x) + Math.abs(y) + Math.abs(z);
    }

    public static int calculateHorizontalManhattanDistance(class_2338 start, class_2338 end) {
        int x = start.method_10263() - end.method_10263();
        int z = start.method_10260() - end.method_10260();
        return Math.abs(x) + Math.abs(z);
    }

    public static int compareBlockPos(class_2338 blockPos, class_2338 o1BlockPos, class_2338 o2BlockPos) {
        double distance1 = MathUtils.getBlockSquareDistance(blockPos, o1BlockPos);
        double distance2 = MathUtils.getBlockSquareDistance(blockPos, o2BlockPos);
        return Double.compare(distance1, distance2);
    }

    public static class_2338 getTheNetherPos(double xPos, double yPos, double zPos) {
        return new class_2338((int)Math.round(xPos / 8.0), (int)Math.round(yPos), (int)Math.round(zPos / 8.0));
    }

    public static class_2338 getTheNetherPos(class_1297 entity) {
        return MathUtils.getTheNetherPos(entity.method_23317(), entity.method_23318(), entity.method_23321());
    }

    public static class_2338 getOverworldPos(double xPos, double yPos, double zPos) {
        return new class_2338((int)Math.round(xPos * 8.0), (int)Math.round(yPos), (int)Math.round(zPos * 8.0));
    }

    public static class_2338 getOverworldPos(class_1297 entity) {
        return MathUtils.getOverworldPos(entity.method_23317(), entity.method_23318(), entity.method_23321());
    }

    public static class_2338 toMinBlockPos(class_2338 pos1, class_2338 pos2) {
        return new class_2338(Math.min(pos1.method_10263(), pos2.method_10263()), Math.min(pos1.method_10264(), pos2.method_10264()), Math.min(pos1.method_10260(), pos2.method_10260()));
    }

    public static class_2338 toMaxBlockPos(class_2338 pos1, class_2338 pos2) {
        return new class_2338(Math.max(pos1.method_10263(), pos2.method_10263()), Math.max(pos1.method_10264(), pos2.method_10264()), Math.max(pos1.method_10260(), pos2.method_10260()));
    }

    public static int randomInt(int min, int max) {
        if (max == min) {
            return max;
        }
        if (min > max) {
            int temp = max;
            max = min;
            min = temp;
        }
        return RANDOM.nextInt(max - min + 1) + min;
    }

    public static boolean isInRange(int min, int max, int number) {
        if (min > max) {
            return false;
        }
        return max >= number && number >= min;
    }

    public static double average(double ... args) {
        double sum = 0.0;
        for (double arg : args) {
            sum += arg;
        }
        return sum / (double)args.length;
    }

    public static String numberToTwoDecimalString(double number) {
        return String.format("%.2f", number);
    }

    public static double approach(double start, double target, double factor) {
        return start + (target - start) * factor;
    }

    public static int approach(int start, int target) {
        if (start == target) {
            return start;
        }
        return start > target ? start - 1 : start + 1;
    }

    public static double horizontalDistance(class_243 a, class_243 b) {
        double x = a.field_1352 - b.field_1352;
        double y = a.field_1350 - b.field_1350;
        return Math.sqrt(x * x + y * y);
    }

    public static double verticalDistance(class_243 a, class_243 b) {
        return Math.abs(a.method_10214() - b.method_10214());
    }

    public static <T> T getRandomElement(T[] array) {
        int len = array.length;
        return array[RANDOM.nextInt(len)];
    }

    public static <T> T getRandomElement(List<T> list) {
        int len = list.size();
        return list.get(RANDOM.nextInt(len));
    }

    public static int sumOfArithmeticProgression(int start, int end, int number) {
        return (start + end) * number >>> 1;
    }

    public static double sumOfArithmeticProgression(double start, double end, int number) {
        return (start + end) * (double)number / 2.0;
    }
}

