/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.navigator;

import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.carpetorgaddition.network.s2c.WaypointUpdateS2CPacket;
import org.carpetorgaddition.periodic.navigator.AbstractNavigator;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.util.MathUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.util.WorldUtils;
import org.carpetorgaddition.wheel.TextBuilder;
import org.carpetorgaddition.wheel.Waypoint;
import org.carpetorgaddition.wheel.provider.TextProvider;
import org.jetbrains.annotations.NotNull;

public class WaypointNavigator
extends AbstractNavigator {
    private final Waypoint waypoint;
    private final class_1937 world;
    private class_1937 previousWorld;

    public WaypointNavigator(@NotNull class_3222 player, Waypoint waypoint) {
        super(player);
        this.waypoint = waypoint;
        if (this.waypoint.getBlockPos() == null) {
            throw new NullPointerException();
        }
        this.world = waypoint.getWorld();
    }

    @Override
    public void tick() {
        class_3218 playerWorld = FetcherUtils.getWorld(this.player);
        class_2338 targetPos = this.waypoint.getBlockPos();
        class_2338 playerPos = this.player.method_24515();
        if (this.world == playerWorld) {
            class_2561 text = this.getHUDText(targetPos.method_46558(), this.getIn(targetPos), WaypointNavigator.getDistance(playerPos, targetPos));
            MessageUtils.sendMessageToHud((class_1657)this.player, text);
        } else {
            class_2338 anotherPos = this.waypoint.getAnotherBlockPos();
            if (WorldUtils.canMappingPos(this.world, (class_1937)playerWorld) && anotherPos != null) {
                TextBuilder builder = new TextBuilder(TextProvider.simpleBlockPos(anotherPos));
                builder.setItalic();
                class_2561 in = TextBuilder.translate("carpet.commands.navigate.hud.in", this.waypoint.getName(), builder.build());
                class_2561 text = this.getHUDText(anotherPos.method_46558(), in, WaypointNavigator.getDistance(playerPos, anotherPos));
                MessageUtils.sendMessageToHud((class_1657)this.player, text);
                targetPos = anotherPos;
            } else {
                class_2561 dimensionName = TextProvider.dimension((class_1937)WorldUtils.getWorld(FetcherUtils.getServer(this.player), this.waypoint.getWorldAsString()));
                class_2561 in = TextBuilder.translate("carpet.commands.navigate.hud.in", this.waypoint.getName(), TextBuilder.combineAll(dimensionName, TextProvider.simpleBlockPos(targetPos)));
                MessageUtils.sendMessageToHud((class_1657)this.player, in);
            }
        }
        if (playerWorld != this.previousWorld) {
            this.previousWorld = playerWorld;
            this.syncWaypoint(new WaypointUpdateS2CPacket(targetPos, this.world));
        }
    }

    @Override
    public boolean shouldTerminate() {
        if (FetcherUtils.getWorld(this.player) == this.world && MathUtils.getBlockIntegerDistance(this.player.method_24515(), this.waypoint.getBlockPos()) <= 8) {
            MessageUtils.sendMessageToHud((class_1657)this.player, TextBuilder.translate("carpet.commands.navigate.hud.reach", new Object[0]));
            this.clear();
            return true;
        }
        return false;
    }

    @Override
    public WaypointNavigator copy(class_3222 player) {
        if (this.waypoint.getBlockPos() == null) {
            return null;
        }
        return new WaypointNavigator(player, this.waypoint);
    }

    @NotNull
    private class_2561 getIn(class_2338 blockPos) {
        return TextBuilder.translate("carpet.commands.navigate.hud.in", this.waypoint.getName(), TextProvider.simpleBlockPos(blockPos));
    }

    @NotNull
    private static class_2561 getDistance(class_2338 playerBlockPos, class_2338 blockPos) {
        return TextBuilder.translate("carpet.commands.navigate.hud.distance", MathUtils.getBlockIntegerDistance(playerBlockPos, blockPos));
    }
}

