/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.task.search;

import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3988;
import org.carpetorgaddition.command.FinderCommand;
import org.carpetorgaddition.periodic.task.search.AbstractTradeSearchTask;
import org.carpetorgaddition.util.EnchantmentUtils;
import org.carpetorgaddition.util.MathUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.wheel.BlockIterator;
import org.carpetorgaddition.wheel.TextBuilder;
import org.carpetorgaddition.wheel.provider.TextProvider;

public class TradeEnchantedBookSearchTask
extends AbstractTradeSearchTask {
    private final class_2561 treadName;
    private final class_1887 enchantment;

    public TradeEnchantedBookSearchTask(class_1937 world, BlockIterator blockIterator, class_2338 sourcePos, CommandContext<class_2168> context, class_1887 enchantment) {
        super(world, blockIterator, sourcePos, context);
        class_2561 text = EnchantmentUtils.getName(enchantment);
        this.treadName = TextBuilder.combineAll(text, class_1802.field_8598.method_7848());
        this.enchantment = enchantment;
    }

    @Override
    protected void searchVillager(class_3988 merchant) {
        class_1916 offers = merchant.method_8264();
        HashMap hashMap = new HashMap();
        for (int index = 0; index < offers.size(); ++index) {
            class_1799 enchantedBook = ((class_1914)offers.get(index)).method_8250();
            int level = this.getBookEnchantment(enchantedBook);
            if (level == -1) continue;
            ArrayList result = (ArrayList)hashMap.get(level);
            if (result == null) {
                ArrayList<Integer> list = new ArrayList<Integer>();
                list.add(index + 1);
                hashMap.put(level, list);
            } else {
                result.add(index + 1);
            }
            ++this.tradeCount;
        }
        if (hashMap.isEmpty()) {
            return;
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            this.results.add(new EnchantedBookFindResult(merchant, (ArrayList)entry.getValue(), (Integer)entry.getKey()));
        }
        ++this.villagerCount;
    }

    private int getBookEnchantment(class_1799 enchantedBook) {
        int level;
        if (enchantedBook.method_31574(class_1802.field_8598) && (level = EnchantmentUtils.getLevel(this.world, this.enchantment, enchantedBook)) > 0) {
            return level;
        }
        return -1;
    }

    @Override
    protected void notFound() {
        MessageUtils.sendMessage((class_2168)this.context.getSource(), "carpet.commands.finder.trade.find.not_trade", this.getTradeName(), FinderCommand.VILLAGER);
    }

    @Override
    protected class_2561 getTradeName() {
        return this.treadName;
    }

    public class EnchantedBookFindResult
    implements AbstractTradeSearchTask.Result {
        private final class_3988 merchant;
        private final ArrayList<Integer> list;
        private final int level;

        private EnchantedBookFindResult(class_3988 merchant, ArrayList<Integer> list, int level) {
            this.merchant = merchant;
            this.list = list;
            this.level = level;
        }

        @Override
        public class_2561 get() {
            class_2561 villagerName = this.merchant.method_5477();
            class_2561 enchantmentName = EnchantmentUtils.getName(TradeEnchantedBookSearchTask.this.enchantment, this.level);
            return TextBuilder.translate("carpet.commands.finder.trade.enchanted_book.each", TextProvider.blockPos(this.villagerPos(), class_124.field_1060), villagerName, AbstractTradeSearchTask.getIndexArray(this.list), enchantmentName);
        }

        @Override
        public class_2338 villagerPos() {
            return this.merchant.method_24515();
        }

        @Override
        public int compare(AbstractTradeSearchTask.Result o1, AbstractTradeSearchTask.Result o2) {
            EnchantedBookFindResult result1 = (EnchantedBookFindResult)o1;
            EnchantedBookFindResult result2 = (EnchantedBookFindResult)o2;
            int compare = Integer.compare(result1.level, result2.level);
            if (compare == 0) {
                return MathUtils.compareBlockPos(TradeEnchantedBookSearchTask.this.sourcePos, result1.villagerPos(), result2.villagerPos());
            }
            return -compare;
        }
    }
}

