/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.util;

import carpet.patches.EntityPlayerMPFake;
import carpet.utils.CommandHelper;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.carpetorgaddition.util.GenericUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.wheel.TextBuilder;

public class CommandUtils {
    public static final String PLAYER = "player";

    private CommandUtils() {
    }

    public static class_3222 getSourcePlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        return CommandUtils.getSourcePlayer((class_2168)context.getSource());
    }

    public static class_3222 getSourcePlayer(class_2168 source) throws CommandSyntaxException {
        return source.method_9207();
    }

    public static Optional<class_3222> getSourcePlayerNullable(CommandContext<class_2168> context) {
        return CommandUtils.getSourcePlayerNullable((class_2168)context.getSource());
    }

    public static Optional<class_3222> getSourcePlayerNullable(class_2168 source) {
        return Optional.ofNullable(source.method_44023());
    }

    public static class_3222 getArgumentPlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        return class_2186.method_9315(context, (String)PLAYER);
    }

    public static EntityPlayerMPFake getArgumentFakePlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = class_2186.method_9315(context, (String)PLAYER);
        CommandUtils.assertFakePlayer((class_1657)player);
        return (EntityPlayerMPFake)player;
    }

    public static Collection<GameProfile> getGameProfiles(CommandContext<class_2168> context, String arguments) throws CommandSyntaxException {
        return class_2191.method_9330(context, (String)arguments);
    }

    public static GameProfile getGameProfile(CommandContext<class_2168> context, String arguments) throws CommandSyntaxException {
        Collection<GameProfile> collection = CommandUtils.getGameProfiles(context, arguments);
        switch (collection.size()) {
            case 0: {
                throw class_2191.field_9869.create();
            }
            case 1: {
                break;
            }
            default: {
                TextBuilder builder = TextBuilder.of("carpet.command.argument.player.toomany", new Object[0]);
                ArrayList<class_2561> list = new ArrayList<class_2561>();
                for (GameProfile gameProfile : collection) {
                    list.add(TextBuilder.translate("%s: %s", class_1299.field_6097.method_5897(), gameProfile.getName()));
                }
                builder.setHover(TextBuilder.joinList(list));
                throw CommandUtils.createException(builder.build());
            }
        }
        return collection.iterator().next();
    }

    public static boolean isSelfOrFakePlayer(class_3222 player, CommandContext<class_2168> context) {
        return CommandUtils.isSelfOrFakePlayer(player, (class_2168)context.getSource());
    }

    public static boolean isSelfOrFakePlayer(class_3222 player, class_2168 source) {
        return CommandUtils.isSpecifiedOrFakePlayer(player, source.method_44023());
    }

    public static boolean isSpecifiedOrFakePlayer(class_3222 player, class_3222 specified) {
        return player == specified || player instanceof EntityPlayerMPFake;
    }

    public static CommandSyntaxException createException(String key, Object ... args) {
        return CommandUtils.createException(TextBuilder.translate(key, args));
    }

    public static CommandSyntaxException createException(Throwable e, String key, Object ... args) {
        String message = GenericUtils.getExceptionString(e);
        TextBuilder builder = TextBuilder.of(key, args);
        builder.setHover(message, new Object[0]);
        return new SimpleCommandExceptionType((Message)builder.build()).create();
    }

    public static CommandSyntaxException createException(class_2561 text) {
        return new SimpleCommandExceptionType((Message)text).create();
    }

    public static CommandSyntaxException createEntityNotFoundException() {
        return class_2186.field_9863.create();
    }

    public static CommandSyntaxException createPlayerNotFoundException() {
        return class_2186.field_9856.create();
    }

    public static CommandSyntaxException createIOErrorException(IOException e) {
        return CommandUtils.createException(e, "carpet.command.error.io", new Object[0]);
    }

    public static CommandSyntaxException createOperationTimeoutException() {
        return CommandUtils.createException("carpet.command.operation.timeout", new Object[0]);
    }

    public static CommandSyntaxException createSelfOrFakePlayerException() {
        return CommandUtils.createException("carpet.command.self_or_fake_player", new Object[0]);
    }

    public static CommandSyntaxException createNotFakePlayerException(class_1657 fakePlayer) {
        return CommandUtils.createException("carpet.command.not_fake_player", fakePlayer.method_5476());
    }

    public static void assertFakePlayer(class_1657 fakePlayer) throws CommandSyntaxException {
        if (fakePlayer instanceof EntityPlayerMPFake) {
            return;
        }
        throw CommandUtils.createNotFakePlayerException(fakePlayer);
    }

    public static UUID parseUuidFromString(String uuid) throws CommandSyntaxException {
        try {
            return UUID.fromString(uuid);
        }
        catch (IllegalArgumentException e) {
            throw CommandUtils.createException("carpet.command.uuid.parse.fail", new Object[0]);
        }
    }

    public static void execute(class_3222 player, String command) {
        CommandUtils.execute(player.method_5671(), command);
    }

    public static void execute(class_2168 source, String command) {
        class_2170 commandManager = source.method_9211().method_3734();
        commandManager.method_44252(source, command);
    }

    public static void handlingException(ThrowingRunnable runnable, CommandContext<class_2168> context) {
        CommandUtils.handlingException(runnable, (class_2168)context.getSource());
    }

    public static void handlingException(ThrowingRunnable runnable, class_2168 source) {
        try {
            runnable.run();
        }
        catch (CommandSyntaxException e) {
            CommandUtils.handlingException(e, source);
        }
    }

    public static void handlingException(CommandSyntaxException e, class_2168 source) {
        MessageUtils.sendVanillaErrorMessage(source, e);
    }

    public static boolean canUseCommand(int level, Object value) {
        Object object = value;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Boolean.class, String.class}, (Object)object, n)) {
            case 0 -> {
                Boolean bool = (Boolean)object;
                yield bool;
            }
            case 1 -> {
                String str = (String)object;
                switch (str.toLowerCase(Locale.ROOT)) {
                    case "ops": 
                    case "2": {
                        if (level >= 2) {
                            yield true;
                        }
                        yield false;
                    }
                    case "1": 
                    case "3": 
                    case "4": {
                        if (level >= Integer.parseInt(str)) {
                            yield true;
                        }
                        yield false;
                    }
                    case "0": 
                    case "true": {
                        yield true;
                    }
                }
                yield false;
            }
            case -1 -> false;
            default -> CommandUtils.canUseCommand(level, (Object)value.toString());
        };
    }

    public static Predicate<class_2168> canUseCommand(Supplier<String> supplier) {
        return source -> CommandUtils.canUseCommand(source, (String)supplier.get());
    }

    public static boolean canUseCommand(class_2168 source, Supplier<String> supplier) {
        return CommandUtils.canUseCommand(source, supplier.get());
    }

    public static boolean canUseCommand(class_2168 source, String rule) {
        return CommandHelper.canUseCommand((class_2168)source, (Object)rule);
    }

    @FunctionalInterface
    public static interface ThrowingRunnable {
        public void run() throws CommandSyntaxException;
    }
}

