/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.wheel;

import carpet.CarpetServer;
import carpet.patches.EntityPlayerMPFake;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_151;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2293;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import net.minecraft.class_9694;
import net.minecraft.class_9695;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.wheel.CommandRegistryAccessor;
import org.carpetorgaddition.wheel.TextBuilder;

public class ItemStackPredicate
implements Predicate<class_1799> {
    private final Predicate<class_1799> predicate;
    private final String input;
    private final boolean isWildcard;
    public static final ItemStackPredicate EMPTY = new ItemStackPredicate(class_1802.field_8162);
    public static final ItemStackPredicate WILDCARD = new ItemStackPredicate();

    private ItemStackPredicate() {
        this.predicate = itemStack -> !itemStack.method_7960();
        this.input = "*";
        this.isWildcard = true;
    }

    public ItemStackPredicate(CommandContext<class_2168> context, String arguments) {
        for (ParsedCommandNode commandNode : context.getNodes()) {
            ArgumentCommandNode node;
            CommandNode commandNode2 = commandNode.getNode();
            if (!(commandNode2 instanceof ArgumentCommandNode) || !Objects.equals((node = (ArgumentCommandNode)commandNode2).getName(), arguments)) continue;
            StringRange range = commandNode.getRange();
            this.input = context.getInput().substring(range.getStart(), range.getEnd());
            class_2293.class_2295 predicate = class_2293.method_9804(context, (String)arguments);
            this.isWildcard = this.isWildcard();
            this.predicate = this.isWildcard ? itemStack -> !itemStack.method_7960() && predicate.test(itemStack) : predicate;
            return;
        }
        throw new IllegalArgumentException();
    }

    public ItemStackPredicate(class_1792 item) {
        this.predicate = itemStack -> itemStack.method_31574(item);
        this.input = class_7923.field_41178.method_10221((Object)item).toString();
        this.isWildcard = false;
    }

    private ItemStackPredicate(Predicate<class_1799> predicate, String input) {
        this.input = input;
        this.isWildcard = this.isWildcard();
        this.predicate = this.isWildcard ? itemStack -> !itemStack.method_7960() && predicate.test((class_1799)itemStack) : predicate;
    }

    public boolean isEmpty() {
        return this.test(class_1799.field_8037);
    }

    @Override
    public boolean test(class_1799 itemStack) {
        return this.predicate.test(itemStack);
    }

    public static ItemStackPredicate parse(String input) {
        CommandRegistryAccessor accessor = (CommandRegistryAccessor)CarpetServer.minecraft_server.method_3734();
        class_7157 access = accessor.carpet_Org_Addition$getAccess();
        try {
            StringReader reader = new StringReader(input);
            class_2293.class_2295 predicate = class_2293.method_9801((class_7157)access).method_9800(reader);
            return new ItemStackPredicate((Predicate<class_1799>)predicate, input);
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isWildcard() {
        return "*".equals(this.input) || "*[]".equals(this.input);
    }

    public class_2561 getInitialUpperCase() {
        if (this.isEmpty()) {
            TextBuilder builder = new TextBuilder("[A]");
            builder.setColor(class_124.field_1063);
            builder.setHover(class_1802.field_8162.method_7848());
            return builder.build();
        }
        TextBuilder builder = null;
        if (this.input.startsWith("#")) {
            builder = new TextBuilder("[#]");
        } else if (this.input.startsWith("*")) {
            builder = new TextBuilder("[*]");
        } else if (this.input.contains("[")) {
            builder = new TextBuilder("[@]");
        }
        if (builder != null) {
            return builder.setHover(this.input, new Object[0]).build();
        }
        String[] split = this.input.split(":");
        int index = split.length == 1 ? 0 : 1;
        builder = new TextBuilder("[" + Character.toUpperCase(split[index].charAt(0)) + "]");
        class_2561 name = ((class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)this.input))).method_7848();
        return builder.setHover(name).build();
    }

    public class_2561 toText() throws class_151 {
        if (this.isEmpty()) {
            return class_1802.field_8162.method_7848();
        }
        if (this.isWildcard) {
            return TextBuilder.translate("carpet.command.item.predicate.wildcard", new Object[0]);
        }
        if (this.isConvertible()) {
            class_2960 identifier = class_2960.method_60654((String)this.input);
            return ((class_1792)class_7923.field_41178.method_10223(identifier)).method_7848();
        }
        if (this.input.length() > 30) {
            String substring = this.input.substring(0, 30);
            class_2561 ellipsis = TextBuilder.create("...");
            class_2561 result = TextBuilder.combineAll(substring, ellipsis);
            TextBuilder builder = new TextBuilder(result).setGrayItalic().setHover(this.input, new Object[0]);
            return builder.build();
        }
        return TextBuilder.create(this.input);
    }

    public class_1792 asItem() {
        if (this.isEmpty()) {
            return class_1802.field_8162;
        }
        if (this.isConvertible()) {
            return (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)this.input));
        }
        throw new UnsupportedOperationException(this.input + " cannot be converted to item");
    }

    public static class_1799 getCraftOutput(ItemStackPredicate[] predicates, int widthHeight, EntityPlayerMPFake fakePlayer) {
        for (ItemStackPredicate predicate : predicates) {
            if (predicate.isConvertible()) continue;
            return class_1799.field_8037;
        }
        List<class_1799> list = Arrays.stream(predicates).map(ItemStackPredicate::getInput).map(class_2960::method_60654).map(arg_0 -> ((class_7922)class_7923.field_41178).method_10223(arg_0)).map(class_1792::method_7854).toList();
        class_9694 input = class_9694.method_59986((int)widthHeight, (int)widthHeight, list);
        class_3218 world = FetcherUtils.getWorld((class_3222)fakePlayer);
        Optional optional = FetcherUtils.getServer((class_3222)fakePlayer).method_3772().method_8132(class_3956.field_17545, (class_9695)input, (class_1937)world);
        return optional.map(arg_0 -> ItemStackPredicate.lambda$getCraftOutput$4(input, (class_1937)world, arg_0)).orElse(class_1799.field_8037);
    }

    public static class_1792 stringAsItem(String id) {
        return (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)id));
    }

    public boolean isConvertible() {
        return !this.input.startsWith("#") && !this.input.startsWith("*") && !this.input.matches(".*\\[.*]");
    }

    public String getInput() {
        return this.input;
    }

    public String toString() {
        return this.input;
    }

    private static /* synthetic */ class_1799 lambda$getCraftOutput$4(class_9694 input, class_1937 world, class_8786 recipe) {
        return ((class_3955)recipe.comp_1933()).method_8116((class_9695)input, (class_7225.class_7874)world.method_30349());
    }
}

