/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.client.renderer.waypoint;

import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5321;
import net.minecraft.class_9779;
import org.carpetorgaddition.client.renderer.waypoint.Waypoint;
import org.carpetorgaddition.client.util.ClientCommandUtils;
import org.carpetorgaddition.util.MathUtils;
import org.carpetorgaddition.wheel.provider.CommandProvider;

public class NavigatorWaypoint
extends Waypoint {
    private double progress = 0.0;

    public NavigatorWaypoint(class_5321<class_1937> registryKey, class_243 vec3d) {
        super(registryKey, vec3d, Waypoint.NAVIGATOR, 1L, true);
    }

    @Override
    public void render(class_4587 matrixStack, class_4597 consumers, class_4184 camera, class_9779 tickCounter) {
        double delta = this.tickDelta - this.lastTickDelta;
        if (delta < 0.0) {
            delta -= Math.floor(delta);
        }
        this.progress += delta;
        super.render(matrixStack, consumers, camera, tickCounter);
    }

    @Override
    protected class_243 getInterpolation() {
        if (this.progress >= 1.0) {
            return super.getInterpolation();
        }
        return MathUtils.approach(this.lastTarget, this.getTarget(), this.progress);
    }

    @Override
    public void setTarget(class_5321<class_1937> registryKey, class_243 vec3d) {
        if (registryKey.equals((Object)this.registryKey)) {
            this.lastTarget = this.getTarget();
            this.progress = 0.0;
        }
        super.setTarget(registryKey, vec3d);
    }

    @Override
    public void requestServerToStop() {
        ClientCommandUtils.sendCommand(CommandProvider.stopNavigate());
    }

    @Override
    public String getName() {
        return "Waypoint";
    }
}

