/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.config.AbstractConfig;
import org.carpetorgaddition.config.GlobalConfigs;
import org.carpetorgaddition.util.IOUtils;
import org.jetbrains.annotations.Nullable;

public class CustomCommandConfig
extends AbstractConfig<JsonObject> {
    public static final String CUSTOM_COMMAND_NAME = "custom_command_name";
    private final Map<String, Set<String>> commands = new ConcurrentHashMap<String, Set<String>>();

    protected CustomCommandConfig(GlobalConfigs globalConfigs) {
        super(globalConfigs);
    }

    @Override
    public String getKey() {
        return CUSTOM_COMMAND_NAME;
    }

    @Override
    public JsonObject getJsonValue() {
        JsonObject json = new JsonObject();
        for (Map.Entry<String, Set<String>> entry : this.commands.entrySet()) {
            String key = entry.getKey();
            Set<String> value = entry.getValue();
            if (value.isEmpty()) {
                json.addProperty(key, key);
                continue;
            }
            if (value.size() == 1) {
                json.addProperty(key, value.iterator().next());
                continue;
            }
            JsonArray array = new JsonArray();
            for (String str : value) {
                array.add(str);
            }
            json.add(key, (JsonElement)array);
        }
        return json;
    }

    private JsonObject migrate(File file) {
        try {
            JsonObject json = IOUtils.loadJson(file).getAsJsonObject("commands");
            IOUtils.deprecatedFile(file);
            return json;
        }
        catch (Exception e) {
            CarpetOrgAddition.LOGGER.error("Encountered an unexpected error while migrating the custom command names configuration file", (Throwable)e);
            return new JsonObject();
        }
    }

    @Override
    public void load(@Nullable JsonObject json) {
        Object file;
        if (json == null && ((File)(file = IOUtils.configFile("custom_command_name.json"))).isFile()) {
            json = this.migrate((File)file);
        }
        if (json == null) {
            return;
        }
        try {
            for (Map.Entry entry : json.entrySet()) {
                Set<String> set;
                JsonElement value;
                String key = (String)entry.getKey();
                JsonElement jsonElement = value = (JsonElement)entry.getValue();
                int n = 0;
                block7: while (true) {
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JsonPrimitive.class, JsonArray.class}, (Object)jsonElement, n)) {
                        case 0: {
                            JsonPrimitive primitive = (JsonPrimitive)jsonElement;
                            if (!primitive.isString()) {
                                n = 1;
                                continue block7;
                            }
                            set = Set.of(value.getAsString());
                            break block7;
                        }
                        case 1: {
                            JsonArray array = (JsonArray)jsonElement;
                            set = array.asList().stream().filter(JsonElement::isJsonPrimitive).map(JsonElement::getAsString).collect(Collectors.toSet());
                            break block7;
                        }
                        default: {
                            set = Set.of(key);
                            break block7;
                        }
                    }
                    break;
                }
                Set<String> set2 = set;
                this.commands.put(key, set2);
            }
        }
        catch (RuntimeException e) {
            CarpetOrgAddition.LOGGER.warn("The custom command name configuration file is damaged.", (Throwable)e);
        }
    }

    public String[] getCommand(String command) {
        return (String[])this.commands.computeIfAbsent(command, Set::of).toArray(String[]::new);
    }
}

