/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.periodic.express;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.CarpetOrgAdditionSettings;
import org.carpetorgaddition.command.CommandRegister;
import org.carpetorgaddition.command.MailCommand;
import org.carpetorgaddition.periodic.express.ExpressManager;
import org.carpetorgaddition.util.CommandUtils;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.util.GenericUtils;
import org.carpetorgaddition.util.MessageUtils;
import org.carpetorgaddition.util.WorldUtils;
import org.carpetorgaddition.wheel.Counter;
import org.carpetorgaddition.wheel.TextBuilder;
import org.carpetorgaddition.wheel.WorldFormat;
import org.carpetorgaddition.wheel.provider.CommandProvider;
import org.carpetorgaddition.wheel.provider.TextProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Express
implements Comparable<Express> {
    private static final String NBT_DATA_VERSION = "NbtDataVersion";
    private final String sender;
    private final String recipient;
    private final class_1799 express;
    private boolean cancel = false;
    private final int id;
    @Nullable
    private final UUID uuid;
    private final MinecraftServer server;
    private final LocalDateTime time;
    private final WorldFormat worldFormat;
    private final int nbtDataVersion;
    public static final String EXPRESS = "express";

    public Express(MinecraftServer server, class_3222 sender, class_3222 recipient, int id) throws CommandSyntaxException {
        this(server, sender, recipient.method_7334(), Express.getPlayerHandStack(sender), id);
    }

    public Express(MinecraftServer server, class_3222 sender, GameProfile gameProfile, class_1799 itemStack, int id) {
        this(server, FetcherUtils.getPlayerName((class_1657)sender), gameProfile.getName(), gameProfile.getId(), itemStack, id, LocalDateTime.now(), GenericUtils.getNbtDataVersion());
    }

    public Express(MinecraftServer server, class_3222 sender, GameProfile gameProfile, int id) throws CommandSyntaxException {
        this(server, sender, gameProfile, Express.getPlayerHandStack(sender), id);
    }

    private Express(MinecraftServer server, String sender, String recipient, @Nullable UUID uuid, class_1799 express, int id, LocalDateTime time, int nbtDataVersion) {
        this.server = server;
        this.sender = sender;
        this.recipient = recipient;
        this.uuid = uuid;
        this.express = express;
        this.id = id;
        this.time = time;
        this.worldFormat = new WorldFormat(server, EXPRESS, new String[0]);
        this.nbtDataVersion = nbtDataVersion;
    }

    private static class_1799 getPlayerHandStack(class_3222 player) throws CommandSyntaxException {
        class_1799 mainHandStack = player.method_6047();
        if (mainHandStack.method_7960()) {
            class_1799 offHandStack = player.method_6079();
            if (offHandStack.method_7960()) {
                throw CommandUtils.createException("carpet.commands.mail.structure", new Object[0]);
            }
            return offHandStack.method_51164();
        }
        return mainHandStack.method_51164();
    }

    public void sending() {
        class_3324 playerManager = this.server.method_3760();
        class_3222 senderPlayer = playerManager.method_14566(this.sender);
        class_3222 recipientPlayer = playerManager.method_14566(this.recipient);
        if (senderPlayer == null) {
            CarpetOrgAddition.LOGGER.error("The express delivery is sent by non-existent player");
            return;
        }
        class_2561 cancelText = TextProvider.clickRun(CommandProvider.cancelExpress(this.getId(), false));
        Object[] senderArray = new Object[]{recipientPlayer == null ? this.recipient : recipientPlayer.method_5476(), this.express.method_7947(), this.express.method_7954(), cancelText};
        MessageUtils.sendMessage(senderPlayer, TextBuilder.translate("carpet.commands.mail.sending.sender", senderArray));
        class_2561 receiveText = TextProvider.clickRun(CommandProvider.receiveExpress(this.getId(), false));
        Object[] recipientArray = new Object[]{senderPlayer.method_5476(), this.express.method_7947(), this.express.method_7954(), receiveText};
        if (recipientPlayer == null) {
            TextBuilder builder = TextBuilder.of("carpet.commands.mail.sending.offline_player", new Object[0]);
            builder.setGrayItalic();
            MessageUtils.sendMessage(senderPlayer, builder.build());
        } else {
            MessageUtils.sendMessage(recipientPlayer, TextBuilder.translate("carpet.commands.mail.sending.recipient", recipientArray));
            Express.playXpOrbPickupSound(recipientPlayer);
        }
        CarpetOrgAddition.LOGGER.info("{}\u5411{}\u53d1\u9001\u4e86{}\u4e2a{}", new Object[]{this.sender, this.recipient, this.express.method_7947(), this.express.method_7964().getString()});
    }

    public void receive() throws IOException {
        class_3324 playerManager = this.server.method_3760();
        class_3222 player = playerManager.method_14566(this.recipient);
        if (player == null) {
            CarpetOrgAddition.LOGGER.error("The player who received the package does not exist");
            return;
        }
        if (this.cancel) {
            MessageUtils.sendMessage(player, TextBuilder.translate("carpet.commands.mail.receive.cancel", new Object[0]));
            return;
        }
        int count = this.express.method_7947();
        class_1799 copy = this.express.method_7972();
        Counter<class_1792> counter = new Counter<class_1792>();
        switch (this.insertStack(player).ordinal()) {
            case 0: {
                MessageUtils.sendMessage(player, TextBuilder.translate("carpet.commands.mail.receive.success", count, copy.method_7954()));
                counter.add(copy.method_7909(), count);
                Function<class_3222, class_2561> message = __ -> ExpressManager.getReceiveNotice(player, counter);
                this.sendMessageIfPlayerOnline(this.sender, message);
                Express.playItemPickupSound(player);
                break;
            }
            case 1: {
                int surplusCount = this.express.method_7947();
                MessageUtils.sendMessage(player, TextBuilder.translate("carpet.commands.mail.receive.partial_reception", count - surplusCount, surplusCount));
                counter.add(copy.method_7909(), count - surplusCount);
                Function<class_3222, class_2561> message = __ -> ExpressManager.getReceiveNotice(player, counter);
                this.sendMessageIfPlayerOnline(this.sender, message);
                Express.playItemPickupSound(player);
                break;
            }
            case 2: {
                MessageUtils.sendMessage(player, TextBuilder.translate("carpet.commands.mail.receive.insufficient_capacity", new Object[0]));
            }
        }
    }

    public void cancel() throws IOException {
        class_3324 playerManager = this.server.method_3760();
        class_3222 player = playerManager.method_14566(this.sender);
        if (player == null) {
            CarpetOrgAddition.LOGGER.error("The player who withdrew the package does not exist");
            return;
        }
        int count = this.express.method_7947();
        class_1799 copy = this.express.method_7972();
        switch (this.insertStack(player).ordinal()) {
            case 0: {
                MessageUtils.sendMessage(player, "carpet.commands.mail.cancel.success", count, copy.method_7954());
                Express.playItemPickupSound(player);
                break;
            }
            case 1: {
                int surplusCount = this.express.method_7947();
                MessageUtils.sendMessage(player, "carpet.commands.mail.cancel.partial_reception", count - surplusCount, surplusCount);
                Express.playItemPickupSound(player);
                break;
            }
            case 2: {
                MessageUtils.sendMessage(player, "carpet.commands.mail.cancel.insufficient_capacity", new Object[0]);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        Function<class_3222, class_2561> message = __ -> TextBuilder.of("carpet.commands.mail.cancel.notice", player.method_5476()).setGrayItalic().build();
        this.sendMessageIfPlayerOnline(this.recipient, message);
        this.cancel = true;
    }

    public void intercept(class_3222 operator) throws IOException {
        int count = this.express.method_7947();
        class_1799 copy = this.express.method_7972();
        switch (this.insertStack(operator).ordinal()) {
            case 0: {
                MessageUtils.sendMessage(operator, "carpet.commands.mail.intercept.success", count, copy.method_7954());
                Express.playItemPickupSound(operator);
                break;
            }
            case 1: {
                int surplusCount = this.express.method_7947();
                MessageUtils.sendMessage(operator, "carpet.commands.mail.intercept.partial_reception", count - surplusCount, surplusCount);
                Express.playItemPickupSound(operator);
                break;
            }
            case 2: {
                MessageUtils.sendMessage(operator, "carpet.commands.mail.intercept.insufficient_capacity", new Object[0]);
                return;
            }
        }
        class_2561 hover = TextBuilder.combineAll(copy.method_7909().method_63680(), "*", count - this.express.method_7947());
        this.sendMessageIfPlayerOnline(this.sender, player -> {
            class_2561 text = this.getOperatorPlayerName(operator, (class_3222)player);
            TextBuilder builder = TextBuilder.of("carpet.commands.mail.intercept.notice.sender", text, this.recipient);
            builder.setGrayItalic();
            builder.setHover(hover);
            return builder.build();
        });
        this.sendMessageIfPlayerOnline(this.recipient, player -> {
            class_2561 text = this.getOperatorPlayerName(operator, (class_3222)player);
            TextBuilder builder = TextBuilder.of("carpet.commands.mail.intercept.notice.recipient", text, this.sender);
            builder.setGrayItalic();
            builder.setHover(hover);
            return builder.build();
        });
    }

    private class_2561 getOperatorPlayerName(class_3222 operator, class_3222 player) {
        MailCommand instance = CommandRegister.getCommandInstance(MailCommand.class);
        return instance.intercept.test(player.method_64396()) ? operator.method_5476() : TextBuilder.translate("carpet.generic.operator", new Object[0]);
    }

    public static void playItemPickupSound(@NotNull class_3222 player) {
        WorldUtils.playSound(player, class_3417.field_15197, class_3419.field_15248);
    }

    public static void playXpOrbPickupSound(@NotNull class_3222 player) {
        WorldUtils.playSound(player, class_3417.field_14627, class_3419.field_15248);
    }

    public InsertResult receiveEach() throws IOException {
        class_3222 player = this.server.method_3760().method_14566(this.recipient);
        if (player == null) {
            CarpetOrgAddition.LOGGER.error("\u627e\u4e0d\u5230\u63a5\u6536\u5feb\u9012\u7684\u73a9\u5bb6\uff0c\u6b63\u5728\u505c\u6b62\u63a5\u6536");
            throw new NullPointerException();
        }
        return this.insertStack(player);
    }

    public InsertResult cancelEach() throws IOException {
        class_3222 player = this.server.method_3760().method_14566(this.sender);
        if (player == null) {
            CarpetOrgAddition.LOGGER.error("\u627e\u4e0d\u5230\u64a4\u56de\u5feb\u9012\u7684\u73a9\u5bb6\uff0c\u6b63\u5728\u505c\u6b62\u64a4\u56de");
            throw new NullPointerException();
        }
        return this.insertStack(player);
    }

    private InsertResult insertStack(class_3222 player) throws IOException {
        int count = this.express.method_7947();
        player.method_31548().method_7394(this.express);
        if (count == this.express.method_7947()) {
            return InsertResult.FAIL;
        }
        if (this.express.method_7960()) {
            this.delete();
            return InsertResult.COMPLETE;
        }
        this.save();
        return InsertResult.PART;
    }

    private void sendMessageIfPlayerOnline(String playerName, Function<class_3222, class_2561> message) {
        class_3222 player = this.server.method_3760().method_14566(playerName);
        if (player == null) {
            return;
        }
        MessageUtils.sendMessage(player, message.apply(player));
    }

    public void checkRecipientPermission() {
        class_3324 playerManager = this.server.method_3760();
        class_3222 recipientPlayer = playerManager.method_14566(this.recipient);
        if (recipientPlayer == null) {
            return;
        }
        class_3222 senderPlayer = playerManager.method_14566(this.sender);
        Express.checkRecipientPermission(senderPlayer, recipientPlayer);
    }

    public static void checkRecipientPermission(@Nullable class_3222 senderPlayer, class_3222 recipientPlayer) {
        if (CommandUtils.canUseCommand(recipientPlayer.method_64396(), CarpetOrgAdditionSettings.commandMail)) {
            return;
        }
        if (senderPlayer == null) {
            return;
        }
        class_2561 message = TextBuilder.of("carpet.commands.mail.sending.permission", new Object[0]).setGrayItalic().build();
        MessageUtils.sendMessage(senderPlayer, message);
    }

    public void save() throws IOException {
        class_2507.method_10630((class_2487)this.writeNbt(this.server), (Path)this.worldFormat.file(this.getId() + ".nbt").toPath());
    }

    public void delete() {
        File file = this.worldFormat.file(this.getId() + ".nbt");
        if (file.delete()) {
            return;
        }
        CarpetOrgAddition.LOGGER.warn("\u672a\u80fd\u6210\u529f\u5220\u9664\u540d\u4e3a{}\u7684\u6587\u4ef6", (Object)file);
    }

    public boolean isComplete() {
        return this.express.method_7960();
    }

    public class_2487 writeNbt(MinecraftServer server) {
        class_8942.class_11340 logging;
        try (class_8942.class_11340 class_113402 = logging = Express.createErrorReporter();){
            class_11362 nbt = class_11362.method_71459((class_8942)logging, (class_7225.class_7874)server.method_30611());
            nbt.method_71465("data_version", 2);
            nbt.method_71465(NBT_DATA_VERSION, GenericUtils.getNbtDataVersion());
            nbt.method_71469("sender", this.sender);
            nbt.method_71469("recipient", this.recipient);
            if (this.uuid != null) {
                nbt.method_71469("uuid", this.uuid.toString());
            }
            nbt.method_71472("cancel", this.cancel);
            nbt.method_71465("id", this.id);
            int[] args = new int[]{this.time.getYear(), this.time.getMonthValue(), this.time.getDayOfMonth(), this.time.getHour(), this.time.getMinute(), this.time.getSecond()};
            nbt.method_71473("time", args);
            nbt.method_71468("item", class_1799.field_24671, (Object)this.express);
            class_2487 class_24872 = nbt.method_71475();
            return class_24872;
        }
    }

    public static Express readNbt(MinecraftServer server, class_2487 nbt) {
        class_8942.class_11340 logging;
        try (class_8942.class_11340 class_113402 = logging = Express.createErrorReporter();){
            class_11368 view = class_11352.method_71417((class_8942)logging, (class_7225.class_7874)server.method_30611(), (class_2487)nbt);
            int nbtDataVersion = nbt.method_10550(NBT_DATA_VERSION).orElse(-1);
            String sender = view.method_71441("sender").orElse("[Unknown]");
            String recipient = view.method_71441("recipient").orElse("[Unknown]");
            UUID uuid = GenericUtils.uuidFromString(nbt.method_10558("uuid").orElse(null)).orElse(null);
            boolean cancel = view.method_71433("cancel", false);
            class_1799 stack = view.method_71426("item", class_1799.field_24671).orElse(class_1799.field_8037);
            int id = view.method_71439("id").orElse(-1);
            int[] times = view.method_71442("time").orElse(new int[]{0, 0, 0, 0, 0, 0});
            LocalDateTime localDateTime = LocalDateTime.of(times[0], times[1], times[2], times[3], times[4], times[5]);
            Express express = new Express(server, sender, recipient, uuid, stack, id, localDateTime, nbtDataVersion);
            express.cancel = cancel;
            Express express2 = express;
            return express2;
        }
    }

    private static class_8942.class_11340 createErrorReporter() {
        return new class_8942.class_11340(Express.class::toString, CarpetOrgAddition.LOGGER);
    }

    public int getId() {
        return this.id;
    }

    public String getSender() {
        return this.sender;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public class_2561 getTime() {
        return TextBuilder.translate("carpet.command.time.format", this.time.getYear(), this.time.getMonthValue(), this.time.getDayOfMonth(), this.time.getHour(), this.time.getMinute(), this.time.getSecond());
    }

    public class_1799 getExpress() {
        return this.express;
    }

    public boolean isSender(class_3222 player) {
        return Objects.equals(this.sender, FetcherUtils.getPlayerName((class_1657)player));
    }

    public boolean isRecipient(class_3222 player) {
        return Objects.equals(this.recipient, FetcherUtils.getPlayerName((class_1657)player));
    }

    public boolean isCancel() {
        return this.cancel;
    }

    public boolean equals(Object obj) {
        if (this.isComplete()) {
            return false;
        }
        if (this.getClass() == obj.getClass()) {
            Express other = (Express)obj;
            if (other.isComplete()) {
                return false;
            }
            return this.id == other.id;
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    @Override
    public int compareTo(@NotNull Express o) {
        return this.id - o.id;
    }

    public int getNbtDataVersion() {
        return this.nbtDataVersion;
    }

    public static enum InsertResult {
        COMPLETE,
        PART,
        FAIL;

    }
}

