/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.rule;

import carpet.api.settings.CarpetRule;
import carpet.api.settings.InvalidRuleValueException;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2168;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.CarpetOrgAddition;
import org.carpetorgaddition.CarpetOrgAdditionExtension;
import org.carpetorgaddition.dataupdate.CarpetConfDataUpdater;
import org.carpetorgaddition.dataupdate.DataUpdater;
import org.carpetorgaddition.util.IOUtils;
import org.carpetorgaddition.wheel.WorldFormat;

public class RuleConfig {
    public static final String CONFIG_FINE_NAME = "config.json";
    public static final String RULES = "rules";
    private final MinecraftServer server;
    private final File file;

    public RuleConfig(MinecraftServer server) {
        this.server = server;
        this.file = new WorldFormat(server, null, new String[0]).file(CONFIG_FINE_NAME);
    }

    public void load() {
        class_2168 source = this.server.method_3739();
        for (Map.Entry<String, String> entry : this.read().entrySet()) {
            CarpetRule rule = CarpetOrgAdditionExtension.getSettingManager().getCarpetRule(entry.getKey());
            if (rule == null) {
                CarpetOrgAddition.LOGGER.warn("Unknown rule: {} - ignoring...", (Object)entry.getKey());
                continue;
            }
            try {
                rule.set(source, entry.getValue());
            }
            catch (InvalidRuleValueException e) {
                CarpetOrgAddition.LOGGER.warn("Couldn't set value for rule {}", (Object)entry.getKey(), (Object)e);
            }
        }
    }

    public void put(CarpetRule<?> rule, String value) {
        Map<String, String> map = this.read();
        map.put(rule.name(), value);
        this.save(map);
    }

    public void remove(CarpetRule<?> rule) {
        Map<String, String> map = this.read();
        if (map.remove(rule.name()) == null) {
            return;
        }
        this.save(map);
    }

    private Map<String, String> read() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.file.isFile()) {
            try {
                JsonObject json = IOUtils.loadJson(this.file);
                CarpetConfDataUpdater updater = new CarpetConfDataUpdater();
                json = updater.update(json, DataUpdater.getVersion(json));
                for (Map.Entry entry : json.get(RULES).getAsJsonObject().entrySet()) {
                    map.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                }
            }
            catch (IOException | RuntimeException e) {
                CarpetOrgAddition.LOGGER.warn("When reading Carpet Org Addition rules, an unexpected error occurred", (Throwable)e);
            }
        }
        return map;
    }

    private void save(Map<String, String> map) {
        JsonObject json = new JsonObject();
        json.addProperty("data_version", (Number)2);
        JsonObject rules = new JsonObject();
        map.forEach((arg_0, arg_1) -> ((JsonObject)rules).addProperty(arg_0, arg_1));
        json.add(RULES, (JsonElement)rules);
        this.save(json);
    }

    private void save(JsonObject json) {
        try {
            IOUtils.write(this.file, json);
        }
        catch (IOException e) {
            CarpetOrgAddition.LOGGER.warn("When saving Carpet Org Addition rules, an unexpected error occurred", (Throwable)e);
        }
    }

    public void migrate(JsonObject rules) {
        JsonObject json = new JsonObject();
        json.addProperty("data_version", (Number)0);
        json.add(RULES, (JsonElement)rules);
        CarpetConfDataUpdater dataUpdater = new CarpetConfDataUpdater();
        JsonObject update = dataUpdater.update(json, DataUpdater.getVersion(json));
        this.save(update);
        CarpetOrgAddition.LOGGER.info("The Carpet Org Addition rules have been migrated from carpet.conf to carpetorgaddition/config.json");
    }

    public boolean isMigrated() {
        return this.file.isFile();
    }
}

