/*
 * Decompiled with CFR 0.152.
 */
package org.carpetorgaddition.rule;

import carpet.api.settings.CarpetRule;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.carpetorgaddition.rule.CustomRuleControl;
import org.carpetorgaddition.rule.CustomRuleEntry;
import org.carpetorgaddition.util.FetcherUtils;
import org.carpetorgaddition.util.IOUtils;
import org.carpetorgaddition.wheel.WorldFormat;
import org.jetbrains.annotations.NotNull;

public class RuleSelfManager {
    public static final HashMap<String, CarpetRule<?>> NAME_TO_RULES = new HashMap();
    private static final BiMap<CarpetRule<?>, CustomRuleControl<?>> RULE_TO_CONTROL = HashBiMap.create();
    private final HashMap<String, HashSet<String>> rules = new HashMap();
    private final File file;
    private boolean changed = false;

    public RuleSelfManager(MinecraftServer server) {
        WorldFormat worldFormat = new WorldFormat(server, null, new String[0]);
        this.file = worldFormat.file("ruleself", "json");
    }

    public boolean isEnabled(class_3222 player, String rule) {
        if (this.rules.isEmpty()) {
            return false;
        }
        HashSet<String> rules = this.rules.get(FetcherUtils.getPlayerName((class_1657)player));
        if (rules == null) {
            return false;
        }
        return rules.contains(rule);
    }

    public boolean isEnabled(class_3222 player, CustomRuleControl<?> control) {
        Optional<CustomRuleEntry> optional = RuleSelfManager.get(control);
        return optional.filter(entry -> this.isEnabled(player, entry.getName())).isPresent();
    }

    public void setEnabled(class_3222 player, String rule, boolean enabled) {
        boolean changed;
        String playerName = FetcherUtils.getPlayerName((class_1657)player);
        HashSet<String> rules = this.rules.get(playerName);
        if (rules == null) {
            if (enabled) {
                HashSet<String> value = new HashSet<String>();
                value.add(rule);
                this.rules.put(playerName, value);
                this.changed = true;
            }
            return;
        }
        boolean bl = changed = enabled ? rules.add(rule) : rules.remove(rule);
        if (changed) {
            this.changed = true;
        }
        if (rules.isEmpty()) {
            this.rules.remove(playerName);
        }
    }

    public void onServerSave() {
        this.save();
    }

    public void save() {
        if (this.changed) {
            try {
                JsonObject json = new JsonObject();
                json.addProperty("data_version", (Number)2);
                JsonObject ruleSelfJson = this.createRuleSelfJson();
                json.add("ruleself", (JsonElement)ruleSelfJson);
                IOUtils.write(this.file, json);
            }
            catch (IOException e) {
                IOUtils.loggerError(e);
            }
        }
    }

    private JsonObject createRuleSelfJson() {
        JsonObject json = new JsonObject();
        for (Map.Entry<String, HashSet<String>> entry : this.rules.entrySet()) {
            JsonArray array = new JsonArray();
            HashSet<String> value = entry.getValue();
            for (String rule : value) {
                array.add(rule);
            }
            json.add(entry.getKey(), (JsonElement)array);
        }
        return json;
    }

    public void load() {
        if (this.file.isFile()) {
            try {
                JsonObject json = IOUtils.loadJson(this.file);
                JsonObject ruleself = json.get("ruleself").getAsJsonObject();
                for (Map.Entry entry : ruleself.entrySet()) {
                    HashSet<String> rules = new HashSet<String>();
                    for (JsonElement element : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                        rules.add(element.getAsString());
                    }
                    this.rules.put((String)entry.getKey(), rules);
                }
            }
            catch (IOException e) {
                IOUtils.loggerError(e);
            }
        }
    }

    public static void put(CustomRuleControl<?> control, CarpetRule<?> rule) {
        NAME_TO_RULES.put(rule.name(), rule);
        RULE_TO_CONTROL.put(rule, control);
    }

    public static Optional<CustomRuleEntry> get(String name) {
        CarpetRule<?> rule = NAME_TO_RULES.get(name);
        CustomRuleControl control = (CustomRuleControl)RULE_TO_CONTROL.get(rule);
        return CustomRuleEntry.of(name, rule, control);
    }

    public static Optional<CustomRuleEntry> get(@NotNull CarpetRule<?> rule) {
        CustomRuleControl control = (CustomRuleControl)RULE_TO_CONTROL.get(rule);
        String name = rule.name();
        return CustomRuleEntry.of(name, rule, control);
    }

    public static Optional<CustomRuleEntry> get(CustomRuleControl<?> control) {
        CarpetRule rule = (CarpetRule)RULE_TO_CONTROL.inverse().get(control);
        if (rule == null) {
            return Optional.empty();
        }
        String name = rule.name();
        return CustomRuleEntry.of(name, rule, control);
    }

    public static List<String> values() {
        return NAME_TO_RULES.values().stream().map(CarpetRule::name).toList();
    }
}

